/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.named_data.jndn.Data;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encrypt.DecryptKey;
import net.named_data.jndn.encrypt.EncryptKey;
import net.named_data.jndn.encrypt.GroupManagerDb;
import net.named_data.jndn.encrypt.Interval;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.encrypt.algo.Encryptor;
import net.named_data.jndn.encrypt.algo.RsaAlgorithm;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.util.Blob;

public class GroupManager {
    private final Name namespace_;
    private final GroupManagerDb database_;
    private final int keySize_;
    private final int freshnessHours_;
    private final KeyChain keyChain_;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;

    public GroupManager(Name prefix, Name dataType, GroupManagerDb database, int keySize, int freshnessHours, KeyChain keyChain) throws SecurityException {
        this.namespace_ = new Name(prefix).append(Encryptor.NAME_COMPONENT_READ).append(dataType);
        this.database_ = database;
        this.keySize_ = keySize;
        this.freshnessHours_ = freshnessHours;
        this.keyChain_ = keyChain;
    }

    public final List getGroupKey(double timeSlot, boolean needRegenerate) throws GroupManagerDb.Error, SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        TreeMap memberKeys = new TreeMap();
        ArrayList<Data> result = new ArrayList<Data>();
        Interval finalInterval = this.calculateInterval(timeSlot, memberKeys);
        if (!finalInterval.isValid()) {
            return result;
        }
        String startTimeStamp = Schedule.toIsoString(finalInterval.getStartTime());
        String endTimeStamp = Schedule.toIsoString(finalInterval.getEndTime());
        Blob[] privateKeyBlob = new Blob[]{null};
        Blob[] publicKeyBlob = new Blob[]{null};
        Name eKeyName = new Name(this.namespace_);
        eKeyName.append(Encryptor.NAME_COMPONENT_E_KEY).append(startTimeStamp).append(endTimeStamp);
        if (!needRegenerate && this.database_.hasEKey(eKeyName)) {
            this.getEKey(eKeyName, publicKeyBlob, privateKeyBlob);
        } else {
            this.generateKeyPair(privateKeyBlob, publicKeyBlob);
            if (this.database_.hasEKey(eKeyName)) {
                this.deleteEKey(eKeyName);
            }
            this.addEKey(eKeyName, publicKeyBlob[0], privateKeyBlob[0]);
        }
        Data data = this.createEKeyData(startTimeStamp, endTimeStamp, publicKeyBlob[0]);
        result.add(data);
        Iterator iterator = memberKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = iterator.next();
            Name keyName = (Name)entry.getKey();
            Blob certificateKey = (Blob)entry.getValue();
            data = this.createDKeyData(startTimeStamp, endTimeStamp, keyName, privateKeyBlob[0], certificateKey);
            result.add(data);
        }
        return result;
    }

    public final List getGroupKey(double timeSlot) throws GroupManagerDb.Error, SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        return this.getGroupKey(timeSlot, true);
    }

    public final void addSchedule(String scheduleName, Schedule schedule) throws GroupManagerDb.Error {
        this.database_.addSchedule(scheduleName, schedule);
    }

    public final void deleteSchedule(String scheduleName) throws GroupManagerDb.Error {
        this.database_.deleteSchedule(scheduleName);
    }

    public final void updateSchedule(String scheduleName, Schedule schedule) throws GroupManagerDb.Error {
        this.database_.updateSchedule(scheduleName, schedule);
    }

    public final void addMember(String scheduleName, Data memberCertificate) throws GroupManagerDb.Error, DerDecodingException {
        IdentityCertificate cert = new IdentityCertificate(memberCertificate);
        this.database_.addMember(scheduleName, cert.getPublicKeyName(), cert.getPublicKeyInfo().getKeyDer());
    }

    public final void removeMember(Name identity) throws GroupManagerDb.Error {
        this.database_.deleteMember(identity);
    }

    public final void updateMemberSchedule(Name identity, String scheduleName) throws GroupManagerDb.Error {
        this.database_.updateMemberSchedule(identity, scheduleName);
    }

    public void cleanEKeys() throws GroupManagerDb.Error {
        this.database_.cleanEKeys();
    }

    private Interval calculateInterval(double timeSlot, Map memberKeys) throws GroupManagerDb.Error {
        Interval positiveResult = new Interval();
        Interval negativeResult = new Interval();
        memberKeys.clear();
        List scheduleNames = this.database_.listAllScheduleNames();
        for (int i = 0; i < scheduleNames.size(); ++i) {
            String scheduleName = (String)scheduleNames.get(i);
            Schedule schedule = this.database_.getSchedule(scheduleName);
            Schedule.Result result = schedule.getCoveringInterval(timeSlot);
            Interval tempInterval = result.interval;
            if (result.isPositive) {
                if (!positiveResult.isValid()) {
                    positiveResult = tempInterval;
                }
                positiveResult.intersectWith(tempInterval);
                Map map = this.database_.getScheduleMembers(scheduleName);
                memberKeys.putAll(map);
                continue;
            }
            if (!negativeResult.isValid()) {
                negativeResult = tempInterval;
            }
            negativeResult.intersectWith(tempInterval);
        }
        if (!positiveResult.isValid()) {
            return new Interval(false);
        }
        Interval finalInterval = negativeResult.isValid() ? positiveResult.intersectWith(negativeResult) : positiveResult;
        return finalInterval;
    }

    private void generateKeyPair(Blob[] privateKeyBlob, Blob[] publicKeyBlob) throws SecurityException {
        RsaKeyParams params = new RsaKeyParams(this.keySize_);
        DecryptKey privateKey = RsaAlgorithm.generateKey(params);
        privateKeyBlob[0] = privateKey.getKeyBits();
        EncryptKey publicKey = RsaAlgorithm.deriveEncryptKey(privateKeyBlob[0]);
        publicKeyBlob[0] = publicKey.getKeyBits();
    }

    private Data createEKeyData(String startTimeStamp, String endTimeStamp, Blob publicKeyBlob) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        Name name = new Name(this.namespace_);
        name.append(Encryptor.NAME_COMPONENT_E_KEY).append(startTimeStamp).append(endTimeStamp);
        Data data = new Data(name);
        data.getMetaInfo().setFreshnessPeriod((long)this.freshnessHours_ * 3600000L);
        data.setContent(publicKeyBlob);
        this.keyChain_.sign(data);
        return data;
    }

    private Data createDKeyData(String startTimeStamp, String endTimeStamp, Name keyName, Blob privateKeyBlob, Blob certificateKey) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        Name name = new Name(this.namespace_);
        name.append(Encryptor.NAME_COMPONENT_D_KEY);
        name.append(startTimeStamp).append(endTimeStamp);
        Data data = new Data(name);
        data.getMetaInfo().setFreshnessPeriod((long)this.freshnessHours_ * 3600000L);
        EncryptParams encryptParams = new EncryptParams(EncryptAlgorithmType.RsaOaep);
        try {
            Encryptor.encryptData(data, privateKeyBlob, keyName, certificateKey, encryptParams);
        }
        catch (Exception ex) {
            throw new SecurityException("createDKeyData: Error in encryptData: " + ex.getMessage());
        }
        this.keyChain_.sign(data);
        return data;
    }

    private void addEKey(Name eKeyName, Blob publicKey, Blob privateKey) throws GroupManagerDb.Error {
        this.database_.addEKey(eKeyName, publicKey, privateKey);
    }

    private void getEKey(Name eKeyName, Blob[] publicKey, Blob[] privateKey) throws GroupManagerDb.Error {
        this.database_.getEKey(eKeyName, publicKey, privateKey);
    }

    private void deleteEKey(Name eKeyName) throws GroupManagerDb.Error {
        this.database_.deleteEKey(eKeyName);
    }

    public static void setFriendAccess(Friend friend) {
        if (friend.getClass().getName().endsWith("net.named_data.jndn.tests.integration_tests.TestGroupManager")) {
            friend.setGroupManagerFriendAccess(new FriendAccessImpl());
        }
    }

    private static class FriendAccessImpl
    extends FriendAccess {
        private FriendAccessImpl() {
        }

        @Override
        public Interval calculateInterval(GroupManager groupManager, double timeSlot, Map memberKeys) throws GroupManagerDb.Error {
            return groupManager.calculateInterval(timeSlot, memberKeys);
        }

        @Override
        public Data createDKeyData(GroupManager groupManager, String startTimeStamp, String endTimeStamp, Name keyName, Blob privateKeyBlob, Blob certificateKey) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
            return groupManager.createDKeyData(startTimeStamp, endTimeStamp, keyName, privateKeyBlob, certificateKey);
        }

        @Override
        public Data createEKeyData(GroupManager groupManager, String startTimeStamp, String endTimeStamp, Blob publicKeyBlob) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
            return groupManager.createEKeyData(startTimeStamp, endTimeStamp, publicKeyBlob);
        }
    }

    public static abstract class FriendAccess {
        public abstract Interval calculateInterval(GroupManager var1, double var2, Map var4) throws GroupManagerDb.Error;

        public abstract Data createDKeyData(GroupManager var1, String var2, String var3, Name var4, Blob var5, Blob var6) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error;

        public abstract Data createEKeyData(GroupManager var1, String var2, String var3, Blob var4) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error;
    }

    public static interface Friend {
        public void setGroupManagerFriendAccess(FriendAccess var1);
    }
}

