/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.Signature;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCounter;

public class Sha256WithRsaSignature
extends Signature {
    private Blob signature_ = new Blob();
    private final ChangeCounter keyLocator_ = new ChangeCounter(new KeyLocator());
    private final ChangeCounter validityPeriod_ = new ChangeCounter(new ValidityPeriod());
    private long changeCount_ = 0L;

    public Sha256WithRsaSignature() {
    }

    public Sha256WithRsaSignature(Sha256WithRsaSignature signature) {
        this.signature_ = signature.signature_;
        this.keyLocator_.set(new KeyLocator(signature.getKeyLocator()));
        this.validityPeriod_.set(new ValidityPeriod(signature.getValidityPeriod()));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new Sha256WithRsaSignature(this);
    }

    @Override
    public final Blob getSignature() {
        return this.signature_;
    }

    public final KeyLocator getKeyLocator() {
        return (KeyLocator)this.keyLocator_.get();
    }

    public final ValidityPeriod getValidityPeriod() {
        return (ValidityPeriod)this.validityPeriod_.get();
    }

    @Override
    public final void setSignature(Blob signature) {
        this.signature_ = signature == null ? new Blob() : signature;
        ++this.changeCount_;
    }

    public final void setKeyLocator(KeyLocator keyLocator) {
        this.keyLocator_.set(keyLocator == null ? new KeyLocator() : new KeyLocator(keyLocator));
        ++this.changeCount_;
    }

    public final void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod_.set(validityPeriod == null ? new ValidityPeriod() : new ValidityPeriod(validityPeriod));
        ++this.changeCount_;
    }

    @Override
    public final long getChangeCount() {
        boolean changed = this.keyLocator_.checkChanged();
        boolean bl = changed = this.validityPeriod_.checkChanged() || changed;
        if (changed) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }
}

