/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigChecker;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexTopMatcher;

public class ConfigRegexChecker
extends ConfigChecker {
    private final NdnRegexTopMatcher regex_;

    public ConfigRegexChecker(String regexString) throws NdnRegexMatcherBase.Error {
        this.regex_ = new NdnRegexTopMatcher(regexString);
    }

    @Override
    protected boolean checkNames(Name packetName, Name keyLocatorName, ValidationState state) throws ValidatorConfigError {
        boolean result;
        try {
            result = this.regex_.match(keyLocatorName);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error matching regex: " + ex);
        }
        if (!result) {
            state.fail(new ValidationError(9, "KeyLocator check failed: regex " + this.regex_.getExpr() + " for packet " + packetName.toUri() + " is invalid (KeyLocator=" + keyLocatorName.toUri() + ")"));
        }
        return result;
    }
}

