/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateFetcher;
import net.named_data.jndn.security.v2.CertificateFetcherOffline;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateStorage;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.DataValidationFailureCallback;
import net.named_data.jndn.security.v2.DataValidationState;
import net.named_data.jndn.security.v2.DataValidationSuccessCallback;
import net.named_data.jndn.security.v2.InterestValidationFailureCallback;
import net.named_data.jndn.security.v2.InterestValidationState;
import net.named_data.jndn.security.v2.InterestValidationSuccessCallback;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationPolicy;
import net.named_data.jndn.security.v2.ValidationState;

public class Validator
extends CertificateStorage {
    private final ValidationPolicy policy_;
    private final CertificateFetcher certificateFetcher_;
    private int maxDepth_;
    private static final Logger logger_ = Logger.getLogger(Validator.class.getName());

    public Validator(ValidationPolicy policy, CertificateFetcher certificateFetcher) {
        this.policy_ = policy;
        this.certificateFetcher_ = certificateFetcher;
        this.maxDepth_ = 25;
        if (this.policy_ == null) {
            throw new IllegalArgumentException("The policy is null");
        }
        if (this.certificateFetcher_ == null) {
            throw new IllegalArgumentException("The certificateFetcher is null");
        }
        this.policy_.setValidator(this);
        this.certificateFetcher_.setCertificateStorage(this);
    }

    public Validator(ValidationPolicy policy) {
        this.policy_ = policy;
        this.certificateFetcher_ = new CertificateFetcherOffline();
        this.maxDepth_ = 25;
        if (this.policy_ == null) {
            throw new IllegalArgumentException("The policy is null");
        }
        this.policy_.setValidator(this);
        this.certificateFetcher_.setCertificateStorage(this);
    }

    public final ValidationPolicy getPolicy() {
        return this.policy_;
    }

    public final CertificateFetcher getFetcher() {
        return this.certificateFetcher_;
    }

    public final void setMaxDepth(int maxDepth) {
        this.maxDepth_ = maxDepth;
    }

    public final int getMaxDepth() {
        return this.maxDepth_;
    }

    public final void validate(Data data, DataValidationSuccessCallback successCallback, DataValidationFailureCallback failureCallback) throws CertificateV2.Error, ValidatorConfigError {
        DataValidationState state = new DataValidationState(data, successCallback, failureCallback);
        logger_.log(Level.FINE, "Start validating data {0}", data.getName().toUri());
        this.policy_.checkPolicy(data, (ValidationState)state, new ValidationPolicy.ValidationContinuation(){

            @Override
            public void continueValidation(CertificateRequest certificateRequest, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
                if (certificateRequest == null) {
                    state.bypassValidation_();
                } else {
                    Validator.this.requestCertificate(certificateRequest, state);
                }
            }
        });
    }

    public final void validate(Interest interest, InterestValidationSuccessCallback successCallback, InterestValidationFailureCallback failureCallback) throws CertificateV2.Error, ValidatorConfigError {
        InterestValidationState state = new InterestValidationState(interest, successCallback, failureCallback);
        logger_.log(Level.FINE, "Start validating interest {0}", interest.getName().toUri());
        this.policy_.checkPolicy(interest, (ValidationState)state, new ValidationPolicy.ValidationContinuation(){

            @Override
            public void continueValidation(CertificateRequest certificateRequest, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
                if (certificateRequest == null) {
                    state.bypassValidation_();
                } else {
                    Validator.this.requestCertificate(certificateRequest, state);
                }
            }
        });
    }

    private void validateCertificate(final CertificateV2 certificate, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
        logger_.log(Level.FINE, "Start validating certificate {0}", certificate.getName().toUri());
        if (!certificate.isValid()) {
            state.fail(new ValidationError(4, "Retrieved certificate is not yet valid or expired `" + certificate.getName().toUri() + "`"));
            return;
        }
        this.policy_.checkCertificatePolicy(certificate, state, new ValidationPolicy.ValidationContinuation(){

            @Override
            public void continueValidation(CertificateRequest certificateRequest, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
                if (certificateRequest == null) {
                    state.fail(new ValidationError(9, "Validation policy is not allowed to designate `" + certificate.getName().toUri() + "` as a trust anchor"));
                } else {
                    state.addCertificate(certificate);
                    Validator.this.requestCertificate(certificateRequest, state);
                }
            }
        });
    }

    private void requestCertificate(CertificateRequest certificateRequest, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
        if (state.getDepth() >= this.maxDepth_) {
            state.fail(new ValidationError(7, "Exceeded validation depth limit"));
            return;
        }
        if (state.hasSeenCertificateName(certificateRequest.interest_.getName())) {
            state.fail(new ValidationError(5, "Validation loop detected for certificate `" + certificateRequest.interest_.getName().toUri() + "`"));
            return;
        }
        logger_.log(Level.FINE, "Retrieving {0}", certificateRequest.interest_.getName().toUri());
        CertificateV2 certificate = this.findTrustedCertificate(certificateRequest.interest_);
        if (certificate != null) {
            logger_.log(Level.FINE, "Found trusted certificate " + certificate.getName().toUri());
            certificate = state.verifyCertificateChain_(certificate);
            if (certificate != null) {
                state.verifyOriginalPacket_(certificate);
            }
            for (int i = 0; i < state.getCertificateChain_().size(); ++i) {
                this.cacheVerifiedCertificate(state.getCertificateChain_().get(i));
            }
            return;
        }
        this.certificateFetcher_.fetch(certificateRequest, state, new CertificateFetcher.ValidationContinuation(){

            @Override
            public void continueValidation(CertificateV2 certificate, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
                Validator.this.validateCertificate(certificate, state);
            }
        });
    }
}

