/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.security.v2.CertificateFetcher;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;

public class CertificateFetcherFromNetwork
extends CertificateFetcher {
    private final Face face_;
    private static final Logger logger_ = Logger.getLogger(CertificateFetcherFromNetwork.class.getName());

    public CertificateFetcherFromNetwork(Face face) {
        this.face_ = face;
    }

    @Override
    protected void doFetch(final CertificateRequest certificateRequest, final ValidationState state, final CertificateFetcher.ValidationContinuation continueValidation) throws CertificateV2.Error {
        try {
            this.face_.expressInterest(certificateRequest.interest_, new OnData(){

                @Override
                public void onData(Interest interest, Data data) {
                    CertificateV2 certificate;
                    logger_.log(Level.FINE, "Fetched certificate from network {0}", data.getName().toUri());
                    try {
                        certificate = new CertificateV2(data);
                    }
                    catch (Throwable ex) {
                        state.fail(new ValidationError(6, "Fetched a malformed certificate `" + data.getName().toUri() + "` (" + ex + ")"));
                        return;
                    }
                    try {
                        continueValidation.continueValidation(certificate, state);
                    }
                    catch (Throwable ex) {
                        state.fail(new ValidationError(3, "Error in continueValidation: " + ex));
                    }
                }
            }, new OnTimeout(){

                @Override
                public void onTimeout(Interest interest) {
                    logger_.log(Level.FINE, "Timeout while fetching certificate {0}, retrying", certificateRequest.interest_.getName().toUri());
                    --certificateRequest.nRetriesLeft_;
                    if (certificateRequest.nRetriesLeft_ >= 0) {
                        try {
                            CertificateFetcherFromNetwork.this.fetch(certificateRequest, state, continueValidation);
                        }
                        catch (Exception ex) {
                            state.fail(new ValidationError(3, "Error in fetch: " + ex));
                        }
                    } else {
                        state.fail(new ValidationError(3, "Cannot fetch certificate after all retries `" + certificateRequest.interest_.getName().toUri() + "`"));
                    }
                }
            }, new OnNetworkNack(){

                @Override
                public void onNetworkNack(Interest interest, NetworkNack networkNack) {
                    logger_.log(Level.FINE, "NACK ({0}) while fetching certificate {1}", new Object[]{networkNack.getReason(), certificateRequest.interest_.getName().toUri()});
                    --certificateRequest.nRetriesLeft_;
                    if (certificateRequest.nRetriesLeft_ >= 0) {
                        try {
                            CertificateFetcherFromNetwork.this.fetch(certificateRequest, state, continueValidation);
                        }
                        catch (Exception ex) {
                            state.fail(new ValidationError(3, "Error in fetch: " + ex));
                        }
                    } else {
                        state.fail(new ValidationError(3, "Cannot fetch certificate after all retries `" + certificateRequest.interest_.getName().toUri() + "`"));
                    }
                }
            });
        }
        catch (IOException ex) {
            state.fail(new ValidationError(3, "Error in expressInterest: ex"));
        }
    }
}

