/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.util.Blob;

public class CertificateCache {
    private final HashMap cache_ = new HashMap();

    public void insertCertificate(IdentityCertificate certificate) {
        Name certName = certificate.getName().getPrefix(-1);
        this.cache_.put(certName.toUri(), certificate.wireEncode());
    }

    public void deleteCertificate(Name certificateName) {
        this.cache_.remove(certificateName.toUri());
    }

    public IdentityCertificate getCertificate(Name certificateName) {
        Blob certData = (Blob)this.cache_.get(certificateName.toUri());
        if (certData == null) {
            return null;
        }
        IdentityCertificate cert = new IdentityCertificate();
        try {
            cert.wireDecode(certData.buf());
        }
        catch (EncodingException ex) {
            Logger.getLogger(CertificateCache.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage());
        }
        return cert;
    }

    public void reset() {
        this.cache_.clear();
    }
}

