/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib.detail;

import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.pib.PibKeyContainer;
import net.named_data.jndn.util.Common;

public class PibIdentityImpl {
    private final Name identityName_;
    private PibKey defaultKey_ = null;
    private final PibKeyContainer keys_;
    private final PibImpl pibImpl_;
    private static Common dummyCommon_ = new Common();

    public PibIdentityImpl(Name identityName, PibImpl pibImpl, boolean needInit) throws PibImpl.Error, Pib.Error {
        this.identityName_ = new Name(identityName);
        this.keys_ = new PibKeyContainer(identityName, pibImpl);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        if (needInit) {
            this.pibImpl_.addIdentity(this.identityName_);
        } else if (!this.pibImpl_.hasIdentity(this.identityName_)) {
            throw new Pib.Error("Identity " + this.identityName_.toUri() + " does not exist");
        }
    }

    public final Name getName() {
        return this.identityName_;
    }

    public final PibKey addKey(ByteBuffer key, Name keyName) throws PibImpl.Error, Pib.Error {
        return this.keys_.add(key, keyName);
    }

    public final void removeKey(Name keyName) throws PibImpl.Error {
        if (this.defaultKey_ != null && this.defaultKey_.getName().equals(keyName)) {
            this.defaultKey_ = null;
        }
        this.keys_.remove(keyName);
    }

    public final PibKey getKey(Name keyName) throws Pib.Error, PibImpl.Error {
        return this.keys_.get(keyName);
    }

    public final PibKey setDefaultKey(Name keyName) throws Pib.Error, PibImpl.Error {
        this.defaultKey_ = this.keys_.get(keyName);
        this.pibImpl_.setDefaultKeyOfIdentity(this.identityName_, keyName);
        return this.defaultKey_;
    }

    public final PibKey setDefaultKey(ByteBuffer key, Name keyName) throws PibImpl.Error, Pib.Error {
        this.addKey(key, keyName);
        return this.setDefaultKey(keyName);
    }

    public final PibKey getDefaultKey() throws Pib.Error, PibImpl.Error {
        if (this.defaultKey_ == null) {
            this.defaultKey_ = this.keys_.get(this.pibImpl_.getDefaultKeyOfIdentity(this.identityName_));
        }
        return this.defaultKey_;
    }

    public PibKeyContainer getKeys_() {
        return this.keys_;
    }
}

