/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibIdentityContainer;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.util.Common;

public class Pib {
    private final String scheme_;
    private final String location_;
    private PibIdentity defaultIdentity_ = null;
    private final PibIdentityContainer identities_;
    private final PibImpl pibImpl_;
    private static Common dummyCommon_ = new Common();

    public final String getScheme() {
        return this.scheme_;
    }

    public final String getPibLocator() {
        return this.scheme_ + ":" + this.location_;
    }

    public final void setTpmLocator(String tpmLocator) throws PibImpl.Error {
        if (tpmLocator.equals(this.pibImpl_.getTpmLocator())) {
            return;
        }
        this.reset_();
        this.pibImpl_.setTpmLocator(tpmLocator);
    }

    public final String getTpmLocator() throws Error, PibImpl.Error {
        String tpmLocator = this.pibImpl_.getTpmLocator();
        if (tpmLocator.equals("")) {
            throw new Error("TPM info does not exist");
        }
        return tpmLocator;
    }

    public final PibIdentity getIdentity(Name identityName) throws PibImpl.Error, Error {
        return this.identities_.get(identityName);
    }

    public final PibIdentity getDefaultIdentity() throws PibImpl.Error, Error {
        if (this.defaultIdentity_ == null) {
            this.defaultIdentity_ = this.identities_.get(this.pibImpl_.getDefaultIdentity());
        }
        return this.defaultIdentity_;
    }

    public Pib(String scheme, String location, PibImpl pibImpl) throws PibImpl.Error {
        this.scheme_ = scheme;
        this.location_ = location;
        this.identities_ = new PibIdentityContainer(pibImpl);
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
    }

    public final void reset_() throws PibImpl.Error {
        this.pibImpl_.clearIdentities();
        this.pibImpl_.setTpmLocator("");
        this.defaultIdentity_ = null;
        this.identities_.reset();
    }

    public final PibIdentity addIdentity_(Name identityName) throws PibImpl.Error, Error {
        return this.identities_.add(identityName);
    }

    public final void removeIdentity_(Name identityName) throws PibImpl.Error {
        if (this.defaultIdentity_ != null && this.defaultIdentity_.getName().equals(identityName)) {
            this.defaultIdentity_ = null;
        }
        this.identities_.remove(identityName);
    }

    public final PibIdentity setDefaultIdentity_(Name identityName) throws PibImpl.Error, Error {
        this.defaultIdentity_ = this.identities_.add(identityName);
        this.pibImpl_.setDefaultIdentity(identityName);
        return this.defaultIdentity_;
    }

    public final PibIdentityContainer getIdentities_() {
        return this.identities_;
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

