/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public class VerificationHelpers {
    public static boolean verifySignature(ByteBuffer buffer, byte[] signature, PublicKey publicKey, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == DigestAlgorithm.SHA256) {
            if (publicKey.getKeyType() == KeyType.RSA) {
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    java.security.PublicKey securityPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKey.getKeyDer().getImmutableArray()));
                    java.security.Signature rsaSignature = java.security.Signature.getInstance("SHA256withRSA");
                    rsaSignature.initVerify(securityPublicKey);
                    rsaSignature.update(buffer);
                    return rsaSignature.verify(signature);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (publicKey.getKeyType() == KeyType.ECDSA) {
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("EC");
                    java.security.PublicKey securityPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKey.getKeyDer().getImmutableArray()));
                    java.security.Signature ecdsaSignature = java.security.Signature.getInstance("SHA256withECDSA");
                    ecdsaSignature.initVerify(securityPublicKey);
                    ecdsaSignature.update(buffer);
                    return ecdsaSignature.verify(signature);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            throw new IllegalArgumentException("verifySignature: Invalid key type");
        }
        throw new IllegalArgumentException("verifySignature: Invalid digest algorithm");
    }

    public static boolean verifySignature(ByteBuffer buffer, byte[] signature, PublicKey publicKey) {
        return VerificationHelpers.verifySignature(buffer, signature, publicKey, DigestAlgorithm.SHA256);
    }

    public static boolean verifySignature(ByteBuffer buffer, Blob signature, PublicKey publicKey, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifySignature(buffer, signature.getImmutableArray(), publicKey, digestAlgorithm);
    }

    public static boolean verifySignature(ByteBuffer buffer, Blob signature, PublicKey publicKey) {
        return VerificationHelpers.verifySignature(buffer, signature.getImmutableArray(), publicKey, DigestAlgorithm.SHA256);
    }

    public static boolean verifySignature(Blob buffer, Blob signature, PublicKey publicKey, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifySignature(buffer.buf(), signature.getImmutableArray(), publicKey, digestAlgorithm);
    }

    public static boolean verifySignature(Blob buffer, Blob signature, PublicKey publicKey) {
        return VerificationHelpers.verifySignature(buffer.buf(), signature.getImmutableArray(), publicKey, DigestAlgorithm.SHA256);
    }

    public static boolean verifySignature(ByteBuffer buffer, byte[] signature, Blob publicKeyDer, DigestAlgorithm digestAlgorithm) {
        try {
            return VerificationHelpers.verifySignature(buffer, signature, new PublicKey(publicKeyDer), digestAlgorithm);
        }
        catch (UnrecognizedKeyFormatException ex) {
            return false;
        }
    }

    public static boolean verifySignature(ByteBuffer buffer, byte[] signature, Blob publicKeyDer) {
        return VerificationHelpers.verifySignature(buffer, signature, publicKeyDer, DigestAlgorithm.SHA256);
    }

    public static boolean verifySignature(ByteBuffer buffer, Blob signature, Blob publicKeyDer, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifySignature(buffer, signature.getImmutableArray(), publicKeyDer, digestAlgorithm);
    }

    public static boolean verifySignature(ByteBuffer buffer, Blob signature, Blob publicKeyDer) {
        return VerificationHelpers.verifySignature(buffer, signature.getImmutableArray(), publicKeyDer, DigestAlgorithm.SHA256);
    }

    public static boolean verifySignature(Blob buffer, Blob signature, Blob publicKeyDer, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifySignature(buffer.buf(), signature.getImmutableArray(), publicKeyDer, digestAlgorithm);
    }

    public static boolean verifySignature(Blob buffer, Blob signature, Blob publicKeyDer) {
        return VerificationHelpers.verifySignature(buffer.buf(), signature.getImmutableArray(), publicKeyDer, DigestAlgorithm.SHA256);
    }

    public static boolean verifyDataSignature(Data data, PublicKey publicKey, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        return VerificationHelpers.verifySignature(encoding.signedBuf(), data.getSignature().getSignature(), publicKey, digestAlgorithm);
    }

    public static boolean verifyDataSignature(Data data, PublicKey publicKey, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDataSignature(data, publicKey, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataSignature(Data data, PublicKey publicKey) {
        return VerificationHelpers.verifyDataSignature(data, publicKey, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataSignature(Data data, Blob publicKeyDer, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        try {
            return VerificationHelpers.verifyDataSignature(data, new PublicKey(publicKeyDer), digestAlgorithm);
        }
        catch (UnrecognizedKeyFormatException ex) {
            return false;
        }
    }

    public static boolean verifyDataSignature(Data data, Blob publicKeyDer, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDataSignature(data, publicKeyDer, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataSignature(Data data, Blob publicKeyDer) {
        return VerificationHelpers.verifyDataSignature(data, publicKeyDer, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataSignature(Data data, CertificateV2 certificate, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        try {
            return VerificationHelpers.verifyDataSignature(data, certificate.getPublicKey(), digestAlgorithm, wireFormat);
        }
        catch (CertificateV2.Error ex) {
            return false;
        }
    }

    public static boolean verifyDataSignature(Data data, CertificateV2 certificate, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDataSignature(data, certificate, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataSignature(Data data, CertificateV2 certificate) {
        return VerificationHelpers.verifyDataSignature(data, certificate, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, PublicKey publicKey, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        Signature signature = VerificationHelpers.extractSignature(interest, wireFormat);
        if (signature == null) {
            return false;
        }
        SignedBlob encoding = interest.wireEncode(wireFormat);
        return VerificationHelpers.verifySignature(encoding.signedBuf(), signature.getSignature(), publicKey, digestAlgorithm);
    }

    public static boolean verifyInterestSignature(Interest interest, PublicKey publicKey, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyInterestSignature(interest, publicKey, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, PublicKey publicKey) {
        return VerificationHelpers.verifyInterestSignature(interest, publicKey, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, Blob publicKeyDer, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        try {
            return VerificationHelpers.verifyInterestSignature(interest, new PublicKey(publicKeyDer), digestAlgorithm);
        }
        catch (UnrecognizedKeyFormatException ex) {
            return false;
        }
    }

    public static boolean verifyInterestSignature(Interest interest, Blob publicKeyDer, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyInterestSignature(interest, publicKeyDer, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, Blob publicKeyDer) {
        return VerificationHelpers.verifyInterestSignature(interest, publicKeyDer, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, CertificateV2 certificate, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        try {
            return VerificationHelpers.verifyInterestSignature(interest, certificate.getPublicKey(), digestAlgorithm, wireFormat);
        }
        catch (CertificateV2.Error ex) {
            return false;
        }
    }

    public static boolean verifyInterestSignature(Interest interest, CertificateV2 certificate, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyInterestSignature(interest, certificate, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestSignature(Interest interest, CertificateV2 certificate) {
        return VerificationHelpers.verifyInterestSignature(interest, certificate, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDigest(ByteBuffer buffer, byte[] digest, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == DigestAlgorithm.SHA256) {
            byte[] bufferDigest = Common.digestSha256(buffer);
            return Arrays.equals(bufferDigest, digest);
        }
        throw new IllegalArgumentException("verifyDigest: Invalid digest algorithm");
    }

    public static boolean verifyDigest(ByteBuffer buffer, Blob digest, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDigest(buffer, digest.getImmutableArray(), digestAlgorithm);
    }

    public static boolean verifyDigest(Blob buffer, Blob digest, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDigest(buffer.buf(), digest.getImmutableArray(), digestAlgorithm);
    }

    public static boolean verifyDataDigest(Data data, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        return VerificationHelpers.verifyDigest(encoding.signedBuf(), data.getSignature().getSignature(), digestAlgorithm);
    }

    public static boolean verifyDataDigest(Data data, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyDataDigest(data, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestDigest(Interest interest, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) {
        Signature signature = VerificationHelpers.extractSignature(interest, wireFormat);
        if (signature == null) {
            return false;
        }
        SignedBlob encoding = interest.wireEncode(wireFormat);
        return VerificationHelpers.verifyDigest(encoding.signedBuf(), signature.getSignature(), digestAlgorithm);
    }

    public static boolean verifyInterestDigest(Interest interest, DigestAlgorithm digestAlgorithm) {
        return VerificationHelpers.verifyInterestDigest(interest, digestAlgorithm, WireFormat.getDefaultWireFormat());
    }

    private static Signature extractSignature(Interest interest, WireFormat wireFormat) {
        if (interest.getName().size() < 2) {
            return null;
        }
        try {
            return wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf(), false);
        }
        catch (EncodingException ex) {
            return null;
        }
    }
}

