/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.util.ChangeCountable;
import net.named_data.jndn.util.Common;

public class ValidityPeriod
implements ChangeCountable {
    private double notBefore_ = Double.MAX_VALUE;
    private double notAfter_ = -1.7976931348623157E308;
    private long changeCount_ = 0L;

    public ValidityPeriod() {
    }

    public ValidityPeriod(ValidityPeriod validityPeriod) {
        this.notBefore_ = validityPeriod.notBefore_;
        this.notAfter_ = validityPeriod.notAfter_;
    }

    public ValidityPeriod(double notBefore, double notAfter) {
        this.setPeriod(notBefore, notAfter);
    }

    public final boolean hasPeriod() {
        return this.notBefore_ != Double.MAX_VALUE || this.notAfter_ != -1.7976931348623157E308;
    }

    public final double getNotBefore() {
        return this.notBefore_;
    }

    public final double getNotAfter() {
        return this.notAfter_;
    }

    public final void clear() {
        this.notBefore_ = Double.MAX_VALUE;
        this.notAfter_ = -1.7976931348623157E308;
        ++this.changeCount_;
    }

    public final ValidityPeriod setPeriod(double notBefore, double notAfter) {
        this.notBefore_ = Math.round(Math.ceil((double)Math.round(notBefore) / 1000.0) * 1000.0);
        this.notAfter_ = Math.round(Math.floor((double)Math.round(notAfter) / 1000.0) * 1000.0);
        ++this.changeCount_;
        return this;
    }

    public final boolean equals(ValidityPeriod other) {
        return this.notBefore_ == other.notBefore_ && this.notAfter_ == other.notAfter_;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValidityPeriod)) {
            return false;
        }
        return this.equals((ValidityPeriod)other);
    }

    public final boolean isValid(double time) {
        return this.notBefore_ <= time && time <= this.notAfter_;
    }

    public final boolean isValid() {
        return this.isValid(Math.round(Math.ceil((double)Math.round(Common.getNowMilliseconds()) / 1000.0) * 1000.0));
    }

    public static boolean canGetFromSignature(Signature signature) {
        return signature instanceof Sha256WithRsaSignature || signature instanceof Sha256WithEcdsaSignature;
    }

    public static ValidityPeriod getFromSignature(Signature signature) {
        if (signature instanceof Sha256WithRsaSignature) {
            return ((Sha256WithRsaSignature)signature).getValidityPeriod();
        }
        if (signature instanceof Sha256WithEcdsaSignature) {
            return ((Sha256WithEcdsaSignature)signature).getValidityPeriod();
        }
        throw new Error("ValidityPeriod.getFromSignature: Signature type does not have a ValidityPeriod");
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }
}

