/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.Data;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Link;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encrypt.EncryptError;
import net.named_data.jndn.encrypt.ProducerDb;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.encrypt.algo.AesAlgorithm;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.encrypt.algo.Encryptor;
import net.named_data.jndn.security.AesKeyParams;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.util.Blob;

public class Producer {
    public static final EncryptError.OnError defaultOnError = new EncryptError.OnError(){

        @Override
        public void onError(EncryptError.ErrorCode errorCode, String message) {
        }
    };
    private final Face face_;
    private Name namespace_;
    private final KeyChain keyChain_;
    private final Map eKeyInfo_ = new HashMap();
    private final Map keyRequests_ = new HashMap();
    private final ProducerDb database_;
    private final int maxRepeatAttempts_;
    private final Link keyRetrievalLink_;
    private static final Logger logger_ = Logger.getLogger(Producer.class.getName());
    private static final int START_TIME_STAMP_INDEX = -2;
    private static final int END_TIME_STAMP_INDEX = -1;
    private static final Link NO_LINK = new Link();

    public Producer(Name prefix, Name dataType, Face face, KeyChain keyChain, ProducerDb database, int repeatAttempts, Link keyRetrievalLink) {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.database_ = database;
        this.maxRepeatAttempts_ = repeatAttempts;
        this.keyRetrievalLink_ = new Link(keyRetrievalLink);
        this.construct(prefix, dataType);
    }

    public Producer(Name prefix, Name dataType, Face face, KeyChain keyChain, ProducerDb database, int repeatAttempts) {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.database_ = database;
        this.maxRepeatAttempts_ = repeatAttempts;
        this.keyRetrievalLink_ = NO_LINK;
        this.construct(prefix, dataType);
    }

    public Producer(Name prefix, Name dataType, Face face, KeyChain keyChain, ProducerDb database) {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.database_ = database;
        this.maxRepeatAttempts_ = 3;
        this.keyRetrievalLink_ = NO_LINK;
        this.construct(prefix, dataType);
    }

    private void construct(Name prefix, Name dataType) {
        Name fixedPrefix = new Name(prefix);
        Name fixedDataType = new Name(dataType);
        fixedPrefix.append(Encryptor.NAME_COMPONENT_READ);
        while (fixedDataType.size() > 0) {
            Name nodeName = new Name(fixedPrefix);
            nodeName.append(fixedDataType);
            nodeName.append(Encryptor.NAME_COMPONENT_E_KEY);
            this.eKeyInfo_.put(nodeName, new KeyInfo());
            fixedDataType = fixedDataType.getPrefix(-1);
        }
        fixedPrefix.append(dataType);
        this.namespace_ = new Name(prefix);
        this.namespace_.append(Encryptor.NAME_COMPONENT_SAMPLE);
        this.namespace_.append(dataType);
    }

    public final Name createContentKey(double timeSlot, OnEncryptedKeys onEncryptedKeys, EncryptError.OnError onError) throws ProducerDb.Error, IOException, SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        double hourSlot = Producer.getRoundedTimeSlot(timeSlot);
        Name contentKeyName = new Name(this.namespace_);
        contentKeyName.append(Encryptor.NAME_COMPONENT_C_KEY);
        contentKeyName.append(Schedule.toIsoString(hourSlot));
        if (this.database_.hasContentKey(timeSlot)) {
            return contentKeyName;
        }
        AesKeyParams aesParams = new AesKeyParams(128);
        Blob contentKeyBits = AesAlgorithm.generateKey(aesParams).getKeyBits();
        this.database_.addContentKey(timeSlot, contentKeyBits);
        double timeCount = Math.round(timeSlot);
        this.keyRequests_.put(timeCount, new KeyRequest(this.eKeyInfo_.size()));
        KeyRequest keyRequest = (KeyRequest)this.keyRequests_.get(timeCount);
        Exclude timeRange = new Exclude();
        Producer.excludeAfter(timeRange, new Name.Component(Schedule.toIsoString(timeSlot)));
        Iterator iterator = this.eKeyInfo_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = iterator.next();
            KeyInfo keyInfo = (KeyInfo)entry.getValue();
            if (timeSlot < keyInfo.beginTimeSlot || timeSlot >= keyInfo.endTimeSlot) {
                keyRequest.repeatAttempts.put(entry.getKey(), 0);
                this.sendKeyInterest(new Interest((Name)entry.getKey()).setExclude(timeRange).setChildSelector(1), timeSlot, onEncryptedKeys, onError);
                continue;
            }
            Name eKeyName = new Name((Name)entry.getKey());
            eKeyName.append(Schedule.toIsoString(keyInfo.beginTimeSlot));
            eKeyName.append(Schedule.toIsoString(keyInfo.endTimeSlot));
            this.encryptContentKey(keyInfo.keyBits, eKeyName, timeSlot, onEncryptedKeys, onError);
        }
        return contentKeyName;
    }

    public final Name createContentKey(double timeSlot, OnEncryptedKeys onEncryptedKeys) throws ProducerDb.Error, IOException, SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        return this.createContentKey(timeSlot, onEncryptedKeys, defaultOnError);
    }

    public final void produce(Data data, double timeSlot, Blob content, EncryptError.OnError onError) throws ProducerDb.Error, IOException, SecurityException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        Name contentKeyName = this.createContentKey(timeSlot, null, onError);
        Blob contentKey = this.database_.getContentKey(timeSlot);
        Name dataName = new Name(this.namespace_);
        dataName.append(Schedule.toIsoString(timeSlot));
        data.setName(dataName);
        EncryptParams params = new EncryptParams(EncryptAlgorithmType.AesCbc, 16);
        Encryptor.encryptData(data, content, contentKeyName, contentKey, params);
        this.keyChain_.sign(data);
    }

    public final void produce(Data data, double timeSlot, Blob content) throws ProducerDb.Error, IOException, SecurityException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        this.produce(data, timeSlot, content, defaultOnError);
    }

    private static double getRoundedTimeSlot(double timeSlot) {
        return Math.round(Math.floor((double)Math.round(timeSlot) / 3600000.0) * 3600000.0);
    }

    private void sendKeyInterest(Interest interest, final double timeSlot, final OnEncryptedKeys onEncryptedKeys, final EncryptError.OnError onError) throws IOException {
        Interest request;
        OnData onKey = new OnData(){

            @Override
            public void onData(Interest interest, Data data) {
                try {
                    Producer.this.handleCoveringKey(interest, data, timeSlot, onEncryptedKeys, onError);
                }
                catch (Exception ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        };
        OnTimeout onTimeout = new OnTimeout(){

            @Override
            public void onTimeout(Interest interest) {
                try {
                    Producer.this.handleTimeout(interest, timeSlot, onEncryptedKeys, onError);
                }
                catch (IOException ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        };
        OnNetworkNack onNetworkNack = new OnNetworkNack(){

            @Override
            public void onNetworkNack(Interest interest, NetworkNack networkNack) {
                Producer.this.handleNetworkNack(interest, networkNack, timeSlot, onEncryptedKeys, onError);
            }
        };
        if (this.keyRetrievalLink_.getDelegations().size() == 0) {
            request = interest;
        } else {
            request = new Interest(interest);
            request.setLinkWireEncoding(this.keyRetrievalLink_.wireEncode());
        }
        this.face_.expressInterest(request, onKey, onTimeout, onNetworkNack);
    }

    private void handleTimeout(Interest interest, double timeSlot, OnEncryptedKeys onEncryptedKeys, EncryptError.OnError onError) throws IOException {
        double timeCount = Math.round(timeSlot);
        KeyRequest keyRequest = (KeyRequest)this.keyRequests_.get(timeCount);
        Name interestName = interest.getName();
        if ((Integer)keyRequest.repeatAttempts.get(interestName) < this.maxRepeatAttempts_) {
            keyRequest.repeatAttempts.put(interestName, (Integer)keyRequest.repeatAttempts.get(interestName) + 1);
            this.sendKeyInterest(interest, timeSlot, onEncryptedKeys, onError);
        } else {
            this.handleNetworkNack(interest, new NetworkNack(), timeSlot, onEncryptedKeys, onError);
        }
    }

    private void handleNetworkNack(Interest interest, NetworkNack networkNack, double timeSlot, OnEncryptedKeys onEncryptedKeys, EncryptError.OnError onError) {
        double timeCount = Math.round(timeSlot);
        this.updateKeyRequest((KeyRequest)this.keyRequests_.get(timeCount), timeCount, onEncryptedKeys);
    }

    private void updateKeyRequest(KeyRequest keyRequest, double timeCount, OnEncryptedKeys onEncryptedKeys) {
        --keyRequest.interestCount;
        if (keyRequest.interestCount == 0 && onEncryptedKeys != null) {
            try {
                onEncryptedKeys.onEncryptedKeys(keyRequest.encryptedKeys);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onEncryptedKeys", exception);
            }
            this.keyRequests_.remove(timeCount);
        }
    }

    private void handleCoveringKey(Interest interest, Data data, double timeSlot, OnEncryptedKeys onEncryptedKeys, EncryptError.OnError onError) throws EncodingException, ProducerDb.Error, SecurityException, IOException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        double timeCount = Math.round(timeSlot);
        KeyRequest keyRequest = (KeyRequest)this.keyRequests_.get(timeCount);
        Name interestName = interest.getName();
        Name keyName = data.getName();
        double begin = Schedule.fromIsoString(keyName.get(-2).getValue().toString());
        double end = Schedule.fromIsoString(keyName.get(-1).getValue().toString());
        if (timeSlot >= end) {
            Exclude timeRange = new Exclude(interest.getExclude());
            Producer.excludeBefore(timeRange, keyName.get(-2));
            keyRequest.repeatAttempts.put(interestName, 0);
            this.sendKeyInterest(new Interest(interestName).setExclude(timeRange).setChildSelector(1), timeSlot, onEncryptedKeys, onError);
        } else {
            Blob encryptionKey = data.getContent();
            if (this.encryptContentKey(encryptionKey, keyName, timeSlot, onEncryptedKeys, onError)) {
                KeyInfo keyInfo = (KeyInfo)this.eKeyInfo_.get(interestName);
                keyInfo.beginTimeSlot = begin;
                keyInfo.endTimeSlot = end;
                keyInfo.keyBits = encryptionKey;
            }
        }
    }

    private boolean encryptContentKey(Blob encryptionKey, Name eKeyName, double timeSlot, OnEncryptedKeys onEncryptedKeys, EncryptError.OnError onError) throws ProducerDb.Error, SecurityException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        double timeCount = Math.round(timeSlot);
        KeyRequest keyRequest = (KeyRequest)this.keyRequests_.get(timeCount);
        Name keyName = new Name(this.namespace_);
        keyName.append(Encryptor.NAME_COMPONENT_C_KEY);
        keyName.append(Schedule.toIsoString(Producer.getRoundedTimeSlot(timeSlot)));
        Blob contentKey = this.database_.getContentKey(timeSlot);
        Data cKeyData = new Data();
        cKeyData.setName(keyName);
        EncryptParams params = new EncryptParams(EncryptAlgorithmType.RsaOaep);
        try {
            Encryptor.encryptData(cKeyData, contentKey, eKeyName, encryptionKey, params);
        }
        catch (Exception ex) {
            try {
                onError.onError(EncryptError.ErrorCode.EncryptionFailure, ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return false;
        }
        this.keyChain_.sign(cKeyData);
        keyRequest.encryptedKeys.add(cKeyData);
        this.updateKeyRequest(keyRequest, timeCount, onEncryptedKeys);
        return true;
    }

    private static ArrayList getExcludeEntries(Exclude exclude) {
        ArrayList<ExcludeEntry> entries = new ArrayList<ExcludeEntry>();
        for (int i = 0; i < exclude.size(); ++i) {
            if (exclude.get(i).getType() == Exclude.Type.ANY) {
                if (entries.size() == 0) {
                    entries.add(new ExcludeEntry(new Name.Component(), true));
                    continue;
                }
                ((ExcludeEntry)entries.get((int)(entries.size() - 1))).anyFollowsComponent_ = true;
                continue;
            }
            entries.add(new ExcludeEntry(exclude.get(i).getComponent(), false));
        }
        return entries;
    }

    private static void setExcludeEntries(Exclude exclude, ArrayList entries) {
        exclude.clear();
        for (int i = 0; i < entries.size(); ++i) {
            ExcludeEntry entry = (ExcludeEntry)entries.get(i);
            if (i == 0 && entry.component_.getValue().size() == 0 && entry.anyFollowsComponent_) {
                exclude.appendAny();
                continue;
            }
            exclude.appendComponent(entry.component_);
            if (!entry.anyFollowsComponent_) continue;
            exclude.appendAny();
        }
    }

    private static int findEntryBeforeOrAt(ArrayList entries, Name.Component component) {
        int i;
        for (i = entries.size() - 1; i >= 0 && ((ExcludeEntry)entries.get((int)i)).component_.compare(component) > 0; --i) {
        }
        return i;
    }

    private static void excludeAfter(Exclude exclude, Name.Component from) {
        int iNewFrom;
        ArrayList entries = Producer.getExcludeEntries(exclude);
        int iFoundFrom = Producer.findEntryBeforeOrAt(entries, from);
        if (iFoundFrom < 0) {
            entries.add(0, new ExcludeEntry(from, true));
            iNewFrom = 0;
        } else {
            ExcludeEntry foundFrom = (ExcludeEntry)entries.get(iFoundFrom);
            if (!foundFrom.anyFollowsComponent_) {
                if (foundFrom.component_.equals(from)) {
                    foundFrom.anyFollowsComponent_ = true;
                    iNewFrom = iFoundFrom;
                } else {
                    entries.add(iFoundFrom + 1, new ExcludeEntry(from, true));
                    iNewFrom = iFoundFrom + 1;
                }
            } else {
                iNewFrom = iFoundFrom;
            }
        }
        int iRemoveBegin = iNewFrom + 1;
        int nRemoveNeeded = entries.size() - iRemoveBegin;
        for (int i = 0; i < nRemoveNeeded; ++i) {
            entries.remove(iRemoveBegin);
        }
        Producer.setExcludeEntries(exclude, entries);
    }

    private static void excludeBefore(Exclude exclude, Name.Component to) {
        Producer.excludeRange(exclude, new Name.Component(), to);
    }

    private static void excludeRange(Exclude exclude, Name.Component from, Name.Component to) {
        int iNewFrom;
        if (from.compare(to) >= 0) {
            if (from.compare(to) == 0) {
                throw new Error("excludeRange: from == to. To exclude a single component, sue excludeOne.");
            }
            throw new Error("excludeRange: from must be less than to. Invalid range: [" + from.toEscapedString() + ", " + to.toEscapedString() + "]");
        }
        ArrayList entries = Producer.getExcludeEntries(exclude);
        int iFoundFrom = Producer.findEntryBeforeOrAt(entries, from);
        if (iFoundFrom < 0) {
            entries.add(0, new ExcludeEntry(from, true));
            iNewFrom = 0;
        } else {
            ExcludeEntry foundFrom = (ExcludeEntry)entries.get(iFoundFrom);
            if (!foundFrom.anyFollowsComponent_) {
                if (foundFrom.component_.equals(from)) {
                    foundFrom.anyFollowsComponent_ = true;
                    iNewFrom = iFoundFrom;
                } else {
                    entries.add(iFoundFrom + 1, new ExcludeEntry(from, true));
                    iNewFrom = iFoundFrom + 1;
                }
            } else {
                iNewFrom = iFoundFrom;
            }
        }
        int iFoundTo = Producer.findEntryBeforeOrAt(entries, to);
        ExcludeEntry foundTo = (ExcludeEntry)entries.get(iFoundTo);
        if (iFoundTo == iNewFrom) {
            entries.add(iNewFrom + 1, new ExcludeEntry(to, false));
        } else {
            int iRemoveEnd;
            if (!foundTo.anyFollowsComponent_) {
                if (foundTo.component_.equals(to)) {
                    iRemoveEnd = iFoundTo;
                } else {
                    entries.add(iFoundTo + 1, new ExcludeEntry(to, false));
                    iRemoveEnd = iFoundTo + 1;
                }
            } else {
                iRemoveEnd = iFoundTo + 1;
            }
            int iRemoveBegin = iNewFrom + 1;
            int nRemoveNeeded = iRemoveEnd - iRemoveBegin;
            for (int i = 0; i < nRemoveNeeded; ++i) {
                entries.remove(iRemoveBegin);
            }
        }
        Producer.setExcludeEntries(exclude, entries);
    }

    private static class ExcludeEntry {
        public Name.Component component_;
        public boolean anyFollowsComponent_;

        public ExcludeEntry(Name.Component component, boolean anyFollowsComponent) {
            this.component_ = component;
            this.anyFollowsComponent_ = anyFollowsComponent;
        }
    }

    private static class KeyRequest {
        public int interestCount;
        public final Map repeatAttempts = new HashMap();
        public final List encryptedKeys = new ArrayList();

        public KeyRequest(int interests) {
            this.interestCount = interests;
        }
    }

    private static class KeyInfo {
        public double beginTimeSlot;
        public double endTimeSlot;
        public Blob keyBits;

        private KeyInfo() {
        }
    }

    public static interface OnEncryptedKeys {
        public void onEncryptedKeys(List var1);
    }
}

