/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.nio.ByteBuffer;

public class DynamicByteBuffer {
    private ByteBuffer buffer_;

    public DynamicByteBuffer(int initialCapacity) {
        this.buffer_ = ByteBuffer.allocate(initialCapacity);
    }

    public final void ensureCapacity(int capacity) {
        if (this.buffer_.capacity() >= capacity) {
            this.buffer_.limit(this.buffer_.capacity());
            return;
        }
        int newCapacity = this.buffer_.capacity() * 2;
        if (capacity > newCapacity) {
            newCapacity = capacity;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        int savePosition = this.buffer_.position();
        this.buffer_.flip();
        newBuffer.put(this.buffer_);
        newBuffer.position(savePosition);
        newBuffer.limit(newBuffer.capacity());
        this.buffer_ = newBuffer;
    }

    public final void ensureRemainingCapacity(int remainingCapacity) {
        this.ensureCapacity(this.buffer_.position() + remainingCapacity);
    }

    public final void ensuredPut(byte b) {
        this.ensureCapacity(this.buffer_.position() + 1);
        this.buffer_.put(b);
    }

    public final void ensuredPut(ByteBuffer buffer) {
        this.ensureRemainingCapacity(buffer.remaining());
        int savePosition = buffer.position();
        this.buffer_.put(buffer);
        buffer.position(savePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensuredPut(ByteBuffer buffer, int position, int limit) {
        this.ensureRemainingCapacity(limit - position);
        int savePosition = buffer.position();
        int saveLimit = buffer.limit();
        try {
            buffer.position(position);
            buffer.limit(limit);
            this.buffer_.put(buffer);
        }
        finally {
            buffer.position(savePosition);
            buffer.limit(saveLimit);
        }
    }

    public final void ensureCapacityFromBack(int capacity) {
        if (this.buffer_.capacity() >= capacity) {
            this.buffer_.limit(this.buffer_.capacity());
            return;
        }
        int newCapacity = this.buffer_.capacity() * 2;
        if (capacity > newCapacity) {
            newCapacity = capacity;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        int saveRemaining = this.buffer_.remaining();
        newBuffer.position(newBuffer.capacity() - saveRemaining);
        newBuffer.put(this.buffer_);
        newBuffer.position(newBuffer.capacity() - saveRemaining);
        this.buffer_ = newBuffer;
    }

    public final int setRemainingFromBack(int remaining) {
        this.ensureCapacityFromBack(remaining);
        this.buffer_.position(this.buffer_.limit() - remaining);
        return this.buffer_.position();
    }

    public final void ensuredPutFromBack(byte b) {
        this.buffer_.put(this.setRemainingFromBack(this.buffer_.remaining() + 1), b);
    }

    public final ByteBuffer buffer() {
        return this.buffer_;
    }

    public final ByteBuffer flippedBuffer() {
        ByteBuffer result = this.buffer_.duplicate();
        result.flip();
        return result;
    }

    public final int position() {
        return this.buffer_.position();
    }

    public final void position(int newPosition) {
        this.buffer_.position(newPosition);
    }

    public final int limit() {
        return this.buffer_.limit();
    }

    public final int remaining() {
        return this.buffer_.remaining();
    }
}

