/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.util.Common;

public class DigestTree {
    private final ArrayList<Node> digestNode_ = new ArrayList();
    private String root_ = "00";
    private static Common dummyCommon_ = new Common();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean update(String dataPrefix, long sessionNo, long sequenceNo) {
        int nodeIndex = this.find(dataPrefix, sessionNo);
        Logger.getLogger(DigestTree.class.getName()).log(Level.FINE, "{0}, {1}", new Object[]{dataPrefix, sessionNo});
        Logger.getLogger(DigestTree.class.getName()).log(Level.FINE, "DigestTree.update session {0}, nodeIndex {1}", new Object[]{sessionNo, nodeIndex});
        if (nodeIndex >= 0) {
            if (this.digestNode_.get(nodeIndex).getSequenceNo() >= sequenceNo) return false;
            this.digestNode_.get(nodeIndex).setSequenceNo(sequenceNo);
        } else {
            int i;
            Logger.getLogger(DigestTree.class.getName()).log(Level.FINE, "new comer {0}, session {1}, sequence {2}", new Object[]{dataPrefix, sessionNo, sequenceNo});
            Node temp = new Node(dataPrefix, sessionNo, sequenceNo);
            for (i = 0; i < this.digestNode_.size() && this.digestNode_.get(i).lessThan(temp); ++i) {
            }
            this.digestNode_.add(i, temp);
        }
        this.recomputeRoot();
        return true;
    }

    public final int find(String dataPrefix, long sessionNo) {
        for (int i = 0; i < this.digestNode_.size(); ++i) {
            if (!this.digestNode_.get(i).getDataPrefix().equals(dataPrefix) || this.digestNode_.get(i).getSessionNo() != sessionNo) continue;
            return i;
        }
        return -1;
    }

    public final int size() {
        return this.digestNode_.size();
    }

    public final Node get(int i) {
        return this.digestNode_.get(i);
    }

    public final String getRoot() {
        return this.root_;
    }

    private static int fromHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private static void updateHex(MessageDigest messageDigest, String hex) {
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(16 * DigestTree.fromHexChar(hex.charAt(2 * i)) + DigestTree.fromHexChar(hex.charAt(2 * i + 1)) & 0xFF);
        }
        messageDigest.update(data);
    }

    private void recomputeRoot() {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new Error("MessageDigest: SHA-256 is not supported: " + exception.getMessage());
        }
        for (int i = 0; i < this.digestNode_.size(); ++i) {
            DigestTree.updateHex(sha256, this.digestNode_.get(i).getDigest());
        }
        byte[] digestRoot = sha256.digest();
        this.root_ = Common.toHex(digestRoot);
        Logger.getLogger(DigestTree.class.getName()).log(Level.FINE, "update root to: {0}", this.root_);
    }

    public static class Node {
        private final String dataPrefix_;
        private final long sessionNo_;
        private long sequenceNo_;
        private String digest_;

        public Node(String dataPrefix, long sessionNo, long sequenceNo) {
            this.dataPrefix_ = dataPrefix;
            this.sessionNo_ = sessionNo;
            this.sequenceNo_ = sequenceNo;
            this.recomputeDigest();
        }

        public final String getDataPrefix() {
            return this.dataPrefix_;
        }

        public final long getSessionNo() {
            return this.sessionNo_;
        }

        public final long getSequenceNo() {
            return this.sequenceNo_;
        }

        public final String getDigest() {
            return this.digest_;
        }

        public final void setSequenceNo(long sequenceNo) {
            this.sequenceNo_ = sequenceNo;
            this.recomputeDigest();
        }

        public final boolean lessThan(Node node2) {
            int prefixComparison = this.dataPrefix_.compareTo(node2.dataPrefix_);
            if (prefixComparison != 0) {
                return prefixComparison < 0;
            }
            return this.sessionNo_ < node2.sessionNo_;
        }

        private void recomputeDigest() {
            MessageDigest sha256;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new Error("MessageDigest: SHA-256 is not supported: " + exception.getMessage());
            }
            byte[] number = new byte[4];
            Node.int32ToLittleEndian((int)this.sessionNo_, number);
            sha256.update(number);
            Node.int32ToLittleEndian((int)this.sequenceNo_, number);
            sha256.update(number);
            byte[] sequenceDigest = sha256.digest();
            sha256.reset();
            try {
                sha256.update(this.dataPrefix_.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("UTF-8 encoder not supported: " + ex.getMessage());
            }
            byte[] nameDigest = sha256.digest();
            sha256.reset();
            sha256.update(nameDigest);
            sha256.update(sequenceDigest);
            byte[] nodeDigest = sha256.digest();
            this.digest_ = Common.toHex(nodeDigest);
        }

        private static void int32ToLittleEndian(int value, byte[] result) {
            for (int i = 0; i < 4; ++i) {
                result[i] = (byte)(value & 0xFF);
                value >>= 8;
            }
        }
    }
}

