/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnInterestValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.IdentityStorage;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.SignedBlob;

public class SelfVerifyPolicyManager
extends PolicyManager {
    private final IdentityStorage identityStorage_;
    private static final Logger logger_ = Logger.getLogger(SelfVerifyPolicyManager.class.getName());

    public SelfVerifyPolicyManager(IdentityStorage identityStorage) {
        this.identityStorage_ = identityStorage;
    }

    public SelfVerifyPolicyManager() {
        this.identityStorage_ = null;
    }

    @Override
    public boolean skipVerifyAndTrust(Data data) {
        return false;
    }

    @Override
    public boolean skipVerifyAndTrust(Interest interest) {
        return false;
    }

    @Override
    public boolean requireVerify(Data data) {
        return true;
    }

    @Override
    public boolean requireVerify(Interest interest) {
        return true;
    }

    @Override
    public ValidationRequest checkVerificationPolicy(Data data, int stepCount, OnVerified onVerified, OnDataValidationFailed onValidationFailed) throws SecurityException {
        String[] failureReason = new String[]{"unknown"};
        if (this.verify(data.getSignature(), data.wireEncode(), failureReason)) {
            try {
                onVerified.onVerified(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerified", ex);
            }
        } else {
            try {
                onValidationFailed.onDataValidationFailed(data, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onDataValidationFailed", ex);
            }
        }
        return null;
    }

    @Override
    public ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed, WireFormat wireFormat) throws SecurityException {
        Signature signature;
        if (interest.getName().size() < 2) {
            try {
                onValidationFailed.onInterestValidationFailed(interest, "The signed interest has less than 2 components: " + interest.getName().toUri());
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
            }
            return null;
        }
        try {
            signature = wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf(), false);
        }
        catch (EncodingException ex) {
            logger_.log(Level.INFO, "Cannot decode the signed interest SignatureInfo and value", ex);
            try {
                onValidationFailed.onInterestValidationFailed(interest, "Error decoding the signed interest signature: " + ex);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
            }
            return null;
        }
        String[] failureReason = new String[]{"unknown"};
        if (this.verify(signature, interest.wireEncode(wireFormat), failureReason)) {
            try {
                onVerified.onVerifiedInterest(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifiedInterest", ex);
            }
        } else {
            try {
                onValidationFailed.onInterestValidationFailed(interest, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
        }
        return null;
    }

    @Override
    public boolean checkSigningPolicy(Name dataName, Name certificateName) {
        return true;
    }

    @Override
    public Name inferSigningIdentity(Name dataName) {
        return new Name();
    }

    private boolean verify(Signature signatureInfo, SignedBlob signedBlob, String[] failureReason) throws SecurityException {
        Blob publicKeyDer = null;
        if (KeyLocator.canGetFromSignature(signatureInfo) && (publicKeyDer = this.getPublicKeyDer(KeyLocator.getFromSignature(signatureInfo), failureReason)).isNull()) {
            return false;
        }
        if (SelfVerifyPolicyManager.verifySignature(signatureInfo, signedBlob, publicKeyDer)) {
            return true;
        }
        failureReason[0] = "The signature did not verify with the given public key";
        return false;
    }

    private Blob getPublicKeyDer(KeyLocator keyLocator, String[] failureReason) throws SecurityException {
        if (keyLocator.getType() == KeyLocatorType.KEYNAME && this.identityStorage_ != null) {
            Name keyName;
            try {
                keyName = IdentityCertificate.certificateNameToPublicKeyName(keyLocator.getKeyName());
            }
            catch (Throwable ex) {
                failureReason[0] = "Cannot get a public key name from the certificate named: " + keyLocator.getKeyName().toUri();
                return new Blob();
            }
            try {
                return this.identityStorage_.getKey(keyName);
            }
            catch (SecurityException ex) {
                failureReason[0] = "The identityStorage doesn't have the key named " + keyName.toUri();
                return new Blob();
            }
        }
        failureReason[0] = "The signature KeyLocator doesn't have a key name";
        return new Blob();
    }
}

