/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyClass;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.util.Blob;

public abstract class PrivateKeyStorage {
    public abstract void generateKeyPair(Name var1, KeyParams var2) throws SecurityException;

    public abstract void deleteKeyPair(Name var1) throws SecurityException;

    public abstract PublicKey getPublicKey(Name var1) throws SecurityException;

    public abstract Blob sign(ByteBuffer var1, Name var2, DigestAlgorithm var3) throws SecurityException;

    public final Blob sign(ByteBuffer data, Name keyName) throws SecurityException {
        return this.sign(data, keyName, DigestAlgorithm.SHA256);
    }

    public abstract Blob decrypt(Name var1, ByteBuffer var2, boolean var3) throws SecurityException;

    public final Blob decrypt(Name keyName, ByteBuffer data) throws SecurityException {
        return this.decrypt(keyName, data, false);
    }

    public abstract Blob encrypt(Name var1, ByteBuffer var2, boolean var3) throws SecurityException;

    public final Blob encrypt(Name keyName, ByteBuffer data) throws SecurityException {
        return this.encrypt(keyName, data, false);
    }

    public abstract void generateKey(Name var1, KeyParams var2) throws SecurityException;

    public abstract boolean doesKeyExist(Name var1, KeyClass var2) throws SecurityException;
}

