/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.certificate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerEncodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.certificate.CertificateExtension;
import net.named_data.jndn.security.certificate.CertificateSubjectDescription;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class Certificate
extends Data {
    private final ArrayList subjectDescriptionList_ = new ArrayList();
    private final ArrayList extensionList_ = new ArrayList();
    private double notBefore_ = Double.MAX_VALUE;
    private double notAfter_ = -1.7976931348623157E308;
    private PublicKey key_ = new PublicKey();

    public Certificate() {
    }

    public Certificate(Data data) throws DerDecodingException {
        super(data);
        this.decode();
    }

    public final void encode() throws DerEncodingException, DerDecodingException {
        DerNode.DerSequence root = this.toDer();
        this.setContent(((DerNode)root).encode());
        this.getMetaInfo().setType(ContentType.KEY);
    }

    @Override
    public void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        super.wireDecode(input, wireFormat);
        try {
            this.decode();
        }
        catch (DerDecodingException ex) {
            throw new EncodingException(ex.getMessage());
        }
    }

    public final void addSubjectDescription(CertificateSubjectDescription description) {
        this.subjectDescriptionList_.add(description);
    }

    public final List getSubjectDescriptionList() {
        return this.subjectDescriptionList_;
    }

    public final void addExtension(CertificateExtension extension) {
        this.extensionList_.add(extension);
    }

    public final List getExtensionList() {
        return this.extensionList_;
    }

    public final void setNotBefore(double notBefore) {
        this.notBefore_ = notBefore;
    }

    public final double getNotBefore() {
        return this.notBefore_;
    }

    public final void setNotAfter(double notAfter) {
        this.notAfter_ = notAfter;
    }

    public final double getNotAfter() {
        return this.notAfter_;
    }

    public final void setPublicKeyInfo(PublicKey key) {
        this.key_ = key;
    }

    public final PublicKey getPublicKeyInfo() {
        return this.key_;
    }

    public final boolean isTooEarly() {
        double now = Common.getNowMilliseconds();
        return now < this.notBefore_;
    }

    public final boolean isTooLate() {
        double now = Common.getNowMilliseconds();
        return now > this.notAfter_;
    }

    private DerNode.DerSequence toDer() throws DerEncodingException, DerDecodingException {
        DerNode.DerSequence root = new DerNode.DerSequence();
        DerNode.DerSequence validity = new DerNode.DerSequence();
        DerNode.DerGeneralizedTime notBefore = new DerNode.DerGeneralizedTime(this.notBefore_);
        DerNode.DerGeneralizedTime notAfter = new DerNode.DerGeneralizedTime(this.notAfter_);
        validity.addChild(notBefore);
        validity.addChild(notAfter);
        root.addChild(validity);
        DerNode.DerSequence subjectList = new DerNode.DerSequence();
        for (int i = 0; i < this.subjectDescriptionList_.size(); ++i) {
            subjectList.addChild(((CertificateSubjectDescription)this.subjectDescriptionList_.get(i)).toDer());
        }
        root.addChild(subjectList);
        root.addChild(this.key_.toDer());
        if (this.extensionList_.size() > 0) {
            DerNode.DerSequence extensionList = new DerNode.DerSequence();
            for (int i = 0; i < this.extensionList_.size(); ++i) {
                extensionList.addChild(((CertificateExtension)this.extensionList_.get(i)).toDer());
            }
            root.addChild(extensionList);
        }
        return root;
    }

    private void decode() throws DerDecodingException {
        DerNode parsedNode = DerNode.parse(this.getContent().buf());
        List rootChildren = parsedNode.getChildren();
        List validityChildren = DerNode.getSequence(rootChildren, 0).getChildren();
        this.notBefore_ = (Double)((DerNode.DerGeneralizedTime)validityChildren.get(0)).toVal();
        this.notAfter_ = (Double)((DerNode.DerGeneralizedTime)validityChildren.get(1)).toVal();
        List subjectChildren = DerNode.getSequence(rootChildren, 1).getChildren();
        for (int i = 0; i < subjectChildren.size(); ++i) {
            DerNode.DerSequence sd = DerNode.getSequence(subjectChildren, i);
            List descriptionChildren = sd.getChildren();
            String oidStr = (String)((DerNode)descriptionChildren.get(0)).toVal();
            String value = "" + (Blob)((DerNode)descriptionChildren.get(1)).toVal();
            this.addSubjectDescription(new CertificateSubjectDescription(oidStr, value));
        }
        Blob publicKeyInfo = ((DerNode)rootChildren.get(2)).encode();
        try {
            this.key_ = new PublicKey(publicKeyInfo);
        }
        catch (UnrecognizedKeyFormatException ex) {
            throw new DerDecodingException(ex.getMessage());
        }
        if (rootChildren.size() > 3) {
            List extensionChildren = DerNode.getSequence(rootChildren, 3).getChildren();
            for (int i = 0; i < extensionChildren.size(); ++i) {
                DerNode.DerSequence extInfo = DerNode.getSequence(extensionChildren, i);
                List children = extInfo.getChildren();
                String oidStr = (String)((DerNode)children.get(0)).toVal();
                boolean isCritical = (Boolean)((DerNode.DerBoolean)children.get(1)).toVal();
                Blob value = (Blob)((DerNode)children.get(2)).toVal();
                this.addExtension(new CertificateExtension(oidStr, isCritical, value));
            }
        }
    }

    public String toString() {
        int i;
        String s = "Certificate name:\n";
        s = s + "  " + this.getName().toUri() + "\n";
        s = s + "Validity:\n";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String notBeforeStr = dateFormat.format(new Date(Math.round(this.notBefore_)));
        String notAfterStr = dateFormat.format(new Date(Math.round(this.notAfter_)));
        s = s + "  NotBefore: " + notBeforeStr + "\n";
        s = s + "  NotAfter: " + notAfterStr + "\n";
        for (int i2 = 0; i2 < this.subjectDescriptionList_.size(); ++i2) {
            CertificateSubjectDescription sd = (CertificateSubjectDescription)this.subjectDescriptionList_.get(i2);
            s = s + "Subject Description:\n";
            s = s + "  " + sd.getOidString() + ": " + sd.getValue() + "\n";
        }
        s = s + "Public key bits:\n";
        Blob keyDer = this.key_.getKeyDer();
        String encodedKey = Common.base64Encode(keyDer.getImmutableArray());
        for (i = 0; i < encodedKey.length(); i += 64) {
            s = s + encodedKey.substring(i, Math.min(i + 64, encodedKey.length())) + "\n";
        }
        if (this.extensionList_.size() > 0) {
            s = s + "Extensions:\n";
            for (i = 0; i < this.extensionList_.size(); ++i) {
                CertificateExtension ext = (CertificateExtension)this.extensionList_.get(i);
                s = s + "  OID: " + ext.getOid() + "\n";
                s = s + "  Is critical: " + (ext.getIsCritical() ? (char)'Y' : 'N') + "\n";
                s = s + "  Value: " + ext.getValue().toHex() + "\n";
            }
        }
        return s;
    }
}

