/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.impl;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.impl.InterestFilterTable;
import net.named_data.jndn.util.Common;

public class RegisteredPrefixTable {
    private final ArrayList<Entry> table_ = new ArrayList();
    private final InterestFilterTable interestFilterTable_;
    private final ArrayList<Long> removeRequests_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger(RegisteredPrefixTable.class.getName());
    private static Common dummyCommon_ = new Common();

    public RegisteredPrefixTable(InterestFilterTable interestFilterTable) {
        this.interestFilterTable_ = interestFilterTable;
    }

    public final synchronized boolean add(long registeredPrefixId, Name prefix, long relatedInterestFilterId) {
        int removeRequestIndex = this.removeRequests_.indexOf(registeredPrefixId);
        if (removeRequestIndex >= 0) {
            this.removeRequests_.remove(removeRequestIndex);
            return false;
        }
        this.table_.add(new Entry(registeredPrefixId, prefix, relatedInterestFilterId));
        return true;
    }

    public final synchronized void removeRegisteredPrefix(long registeredPrefixId) {
        int count = 0;
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            Entry entry = this.table_.get(i);
            if (entry.getRegisteredPrefixId() != registeredPrefixId) continue;
            ++count;
            if (entry.getRelatedInterestFilterId() > 0L) {
                this.interestFilterTable_.unsetInterestFilter(entry.getRelatedInterestFilterId());
            }
            this.table_.remove(i);
        }
        if (count == 0) {
            logger_.log(Level.WARNING, "removeRegisteredPrefix: Didn't find registeredPrefixId {0}", registeredPrefixId);
        }
        if (count == 0 && this.removeRequests_.indexOf(registeredPrefixId) < 0) {
            this.removeRequests_.add(registeredPrefixId);
        }
    }

    private static class Entry {
        private final long registeredPrefixId_;
        private final Name prefix_;
        private final long relatedInterestFilterId_;

        public Entry(long registeredPrefixId, Name prefix, long relatedInterestFilterId) {
            this.registeredPrefixId_ = registeredPrefixId;
            this.prefix_ = prefix;
            this.relatedInterestFilterId_ = relatedInterestFilterId;
        }

        public final long getRegisteredPrefixId() {
            return this.registeredPrefixId_;
        }

        public final Name getPrefix() {
            return this.prefix_;
        }

        public final long getRelatedInterestFilterId() {
            return this.relatedInterestFilterId_;
        }
    }
}

