/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encrypt.ConsumerDb;
import net.named_data.jndn.encrypt.EncryptError;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.algo.AesAlgorithm;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.encrypt.algo.Encryptor;
import net.named_data.jndn.encrypt.algo.RsaAlgorithm;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.util.Blob;

public class Consumer {
    private final ConsumerDb database_;
    private final KeyChain keyChain_;
    private final Face face_;
    private Name groupName_;
    private final Name consumerName_;
    private final HashMap cKeyMap_ = new HashMap();
    private final HashMap dKeyMap_ = new HashMap();
    private static final Logger logger_ = Logger.getLogger(Consumer.class.getName());

    public Consumer(Face face, KeyChain keyChain, Name groupName, Name consumerName, ConsumerDb database) {
        this.database_ = database;
        this.keyChain_ = keyChain;
        this.face_ = face;
        this.groupName_ = new Name(groupName);
        this.consumerName_ = new Name(consumerName);
    }

    public final void consume(Name contentName, final OnConsumeComplete onConsumeComplete, final EncryptError.OnError onError) {
        final Interest interest = new Interest(contentName);
        final OnData onData = new OnData(){

            @Override
            public void onData(Interest contentInterest, final Data contentData) {
                try {
                    Consumer.this.keyChain_.verifyData(contentData, new OnVerified(){

                        @Override
                        public void onVerified(Data validData) {
                            Consumer.this.decryptContent(validData, new OnPlainText(){

                                @Override
                                public void onPlainText(Blob plainText) {
                                    try {
                                        onConsumeComplete.onConsumeComplete(contentData, plainText);
                                    }
                                    catch (Exception ex) {
                                        logger_.log(Level.SEVERE, "Error in onConsumeComplete", ex);
                                    }
                                }
                            }, onError);
                        }
                    }, new OnDataValidationFailed(){

                        @Override
                        public void onDataValidationFailed(Data d, String reason) {
                            try {
                                onError.onError(EncryptError.ErrorCode.Validation, "verifyData failed. Reason: " + reason);
                            }
                            catch (Exception ex) {
                                logger_.log(Level.SEVERE, "Error in onError", ex);
                            }
                        }
                    });
                }
                catch (SecurityException ex) {
                    try {
                        onError.onError(EncryptError.ErrorCode.SecurityException, "verifyData error: " + ex.getMessage());
                    }
                    catch (Exception exception) {
                        logger_.log(Level.SEVERE, "Error in onError", exception);
                    }
                }
            }
        };
        OnTimeout onTimeout = new OnTimeout(){

            @Override
            public void onTimeout(Interest contentInterest) {
                try {
                    Consumer.this.face_.expressInterest(interest, onData, new OnTimeout(){

                        @Override
                        public void onTimeout(Interest contentInterest) {
                            try {
                                onError.onError(EncryptError.ErrorCode.Timeout, interest.getName().toUri());
                            }
                            catch (Exception ex) {
                                logger_.log(Level.SEVERE, "Error in onError", ex);
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    try {
                        onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
                    }
                    catch (Exception exception) {
                        logger_.log(Level.SEVERE, "Error in onError", exception);
                    }
                }
            }
        };
        try {
            this.face_.expressInterest(interest, onData, onTimeout);
        }
        catch (IOException ex) {
            try {
                onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
        }
    }

    public final void setGroup(Name groupName) {
        this.groupName_ = new Name(groupName);
    }

    public final void addDecryptionKey(Name keyName, Blob keyBlob) throws ConsumerDb.Error {
        if (!this.consumerName_.match(keyName)) {
            throw new Error("addDecryptionKey: The consumer name must be a prefix of the key name");
        }
        this.database_.addKey(keyName, keyBlob);
    }

    private static void decrypt(Blob encryptedBlob, Blob keyBits, OnPlainText onPlainText, EncryptError.OnError onError) {
        EncryptedContent encryptedContent = new EncryptedContent();
        try {
            encryptedContent.wireDecode(encryptedBlob);
        }
        catch (EncodingException ex) {
            try {
                onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        Consumer.decrypt(encryptedContent, keyBits, onPlainText, onError);
    }

    private static void decrypt(EncryptedContent encryptedContent, Blob keyBits, OnPlainText onPlainText, EncryptError.OnError onError) {
        Blob payload = encryptedContent.getPayload();
        if (encryptedContent.getAlgorithmType() == EncryptAlgorithmType.AesCbc) {
            Blob content;
            EncryptParams decryptParams = new EncryptParams(EncryptAlgorithmType.AesCbc);
            decryptParams.setInitialVector(encryptedContent.getInitialVector());
            try {
                content = AesAlgorithm.decrypt(keyBits, payload, decryptParams);
            }
            catch (Exception ex) {
                try {
                    onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
                }
                catch (Exception exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
                return;
            }
            try {
                onPlainText.onPlainText(content);
            }
            catch (Exception ex) {
                logger_.log(Level.SEVERE, "Error in onPlainText", ex);
            }
        } else if (encryptedContent.getAlgorithmType() == EncryptAlgorithmType.RsaOaep) {
            Blob content;
            EncryptParams decryptParams = new EncryptParams(EncryptAlgorithmType.RsaOaep);
            try {
                content = RsaAlgorithm.decrypt(keyBits, payload, decryptParams);
            }
            catch (Exception ex) {
                try {
                    onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
                }
                catch (Exception exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
                return;
            }
            try {
                onPlainText.onPlainText(content);
            }
            catch (Exception ex) {
                logger_.log(Level.SEVERE, "Error in onPlainText", ex);
            }
        } else {
            try {
                onError.onError(EncryptError.ErrorCode.UnsupportedEncryptionScheme, encryptedContent.getAlgorithmType().toString());
            }
            catch (Exception ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
        }
    }

    private void decryptContent(Data data, final OnPlainText onPlainText, final EncryptError.OnError onError) {
        final EncryptedContent dataEncryptedContent = new EncryptedContent();
        try {
            dataEncryptedContent.wireDecode(data.getContent());
        }
        catch (EncodingException ex) {
            try {
                onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        final Name cKeyName = dataEncryptedContent.getKeyLocator().getKeyName();
        Blob cKey = (Blob)this.cKeyMap_.get(cKeyName);
        if (cKey != null) {
            Consumer.decrypt(dataEncryptedContent, cKey, onPlainText, onError);
        } else {
            Name interestName = new Name(cKeyName);
            interestName.append(Encryptor.NAME_COMPONENT_FOR).append(this.groupName_);
            final Interest interest = new Interest(interestName);
            final OnData onData = new OnData(){

                @Override
                public void onData(Interest cKeyInterest, Data cKeyData) {
                    try {
                        Consumer.this.keyChain_.verifyData(cKeyData, new OnVerified(){

                            @Override
                            public void onVerified(Data validCKeyData) {
                                Consumer.this.decryptCKey(validCKeyData, new OnPlainText(){

                                    @Override
                                    public void onPlainText(Blob cKeyBits) {
                                        Consumer.this.cKeyMap_.put(cKeyName, cKeyBits);
                                        Consumer.decrypt(dataEncryptedContent, cKeyBits, onPlainText, onError);
                                    }
                                }, onError);
                            }
                        }, new OnDataValidationFailed(){

                            @Override
                            public void onDataValidationFailed(Data d, String reason) {
                                try {
                                    onError.onError(EncryptError.ErrorCode.Validation, "verifyData failed. Reason: " + reason);
                                }
                                catch (Exception ex) {
                                    logger_.log(Level.SEVERE, "Error in onError", ex);
                                }
                            }
                        });
                    }
                    catch (SecurityException ex) {
                        try {
                            onError.onError(EncryptError.ErrorCode.SecurityException, "verifyData error: " + ex.getMessage());
                        }
                        catch (Exception exception) {
                            logger_.log(Level.SEVERE, "Error in onError", exception);
                        }
                    }
                }
            };
            OnTimeout onTimeout = new OnTimeout(){

                @Override
                public void onTimeout(Interest dKeyInterest) {
                    try {
                        Consumer.this.face_.expressInterest(interest, onData, new OnTimeout(){

                            @Override
                            public void onTimeout(Interest contentInterest) {
                                try {
                                    onError.onError(EncryptError.ErrorCode.Timeout, interest.getName().toUri());
                                }
                                catch (Exception ex) {
                                    logger_.log(Level.SEVERE, "Error in onError", ex);
                                }
                            }
                        });
                    }
                    catch (IOException ex) {
                        try {
                            onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
                        }
                        catch (Exception exception) {
                            logger_.log(Level.SEVERE, "Error in onError", exception);
                        }
                    }
                }
            };
            try {
                this.face_.expressInterest(interest, onData, onTimeout);
            }
            catch (IOException ex) {
                try {
                    onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
                }
                catch (Exception exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
            }
        }
    }

    private void decryptCKey(Data cKeyData, final OnPlainText onPlainText, final EncryptError.OnError onError) {
        Blob cKeyContent = cKeyData.getContent();
        final EncryptedContent cKeyEncryptedContent = new EncryptedContent();
        try {
            cKeyEncryptedContent.wireDecode(cKeyContent);
        }
        catch (EncodingException ex) {
            try {
                onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        Name eKeyName = cKeyEncryptedContent.getKeyLocator().getKeyName();
        final Name dKeyName = eKeyName.getPrefix(-3);
        dKeyName.append(Encryptor.NAME_COMPONENT_D_KEY).append(eKeyName.getSubName(-2));
        Blob dKey = (Blob)this.dKeyMap_.get(dKeyName);
        if (dKey != null) {
            Consumer.decrypt(cKeyEncryptedContent, dKey, onPlainText, onError);
        } else {
            Name interestName = new Name(dKeyName);
            interestName.append(Encryptor.NAME_COMPONENT_FOR).append(this.consumerName_);
            final Interest interest = new Interest(interestName);
            final OnData onData = new OnData(){

                @Override
                public void onData(Interest dKeyInterest, Data dKeyData) {
                    try {
                        Consumer.this.keyChain_.verifyData(dKeyData, new OnVerified(){

                            @Override
                            public void onVerified(Data validDKeyData) {
                                Consumer.this.decryptDKey(validDKeyData, new OnPlainText(){

                                    @Override
                                    public void onPlainText(Blob dKeyBits) {
                                        Consumer.this.dKeyMap_.put(dKeyName, dKeyBits);
                                        Consumer.decrypt(cKeyEncryptedContent, dKeyBits, onPlainText, onError);
                                    }
                                }, onError);
                            }
                        }, new OnDataValidationFailed(){

                            @Override
                            public void onDataValidationFailed(Data d, String reason) {
                                try {
                                    onError.onError(EncryptError.ErrorCode.Validation, "verifyData failed. Reason: " + reason);
                                }
                                catch (Exception ex) {
                                    logger_.log(Level.SEVERE, "Error in onError", ex);
                                }
                            }
                        });
                    }
                    catch (SecurityException ex) {
                        try {
                            onError.onError(EncryptError.ErrorCode.SecurityException, "verifyData error: " + ex.getMessage());
                        }
                        catch (Exception exception) {
                            logger_.log(Level.SEVERE, "Error in onError", exception);
                        }
                    }
                }
            };
            OnTimeout onTimeout = new OnTimeout(){

                @Override
                public void onTimeout(Interest dKeyInterest) {
                    try {
                        Consumer.this.face_.expressInterest(interest, onData, new OnTimeout(){

                            @Override
                            public void onTimeout(Interest contentInterest) {
                                try {
                                    onError.onError(EncryptError.ErrorCode.Timeout, interest.getName().toUri());
                                }
                                catch (Exception ex) {
                                    logger_.log(Level.SEVERE, "Error in onError", ex);
                                }
                            }
                        });
                    }
                    catch (IOException ex) {
                        try {
                            onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
                        }
                        catch (Exception exception) {
                            logger_.log(Level.SEVERE, "Error in onError", exception);
                        }
                    }
                }
            };
            try {
                this.face_.expressInterest(interest, onData, onTimeout);
            }
            catch (IOException ex) {
                try {
                    onError.onError(EncryptError.ErrorCode.IOException, "expressInterest error: " + ex.getMessage());
                }
                catch (Exception exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
            }
        }
    }

    private void decryptDKey(Data dKeyData, OnPlainText onPlainText, final EncryptError.OnError onError) {
        Blob consumerKeyBlob;
        Blob dataContent = dKeyData.getContent();
        EncryptedContent encryptedNonce = new EncryptedContent();
        try {
            encryptedNonce.wireDecode(dataContent);
        }
        catch (EncodingException ex) {
            try {
                onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        Name consumerKeyName = encryptedNonce.getKeyLocator().getKeyName();
        try {
            consumerKeyBlob = this.getDecryptionKey(consumerKeyName);
        }
        catch (ConsumerDb.Error ex) {
            try {
                onError.onError(EncryptError.ErrorCode.NoDecryptKey, "Database error: " + ex.getMessage());
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        if (consumerKeyBlob.size() == 0) {
            try {
                onError.onError(EncryptError.ErrorCode.NoDecryptKey, "The desired consumer decryption key in not in the database");
            }
            catch (Exception exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
            return;
        }
        ByteBuffer encryptedPayloadBuffer = dataContent.buf().duplicate();
        encryptedPayloadBuffer.position(encryptedNonce.wireEncode().size());
        final Blob encryptedPayloadBlob = new Blob(encryptedPayloadBuffer, false);
        if (encryptedPayloadBlob.size() == 0) {
            try {
                onError.onError(EncryptError.ErrorCode.InvalidEncryptedFormat, "The data packet does not satisfy the D-KEY packet format");
            }
            catch (Exception ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
            return;
        }
        final OnPlainText callerOnPlainText = onPlainText;
        Consumer.decrypt(encryptedNonce, consumerKeyBlob, new OnPlainText(){

            @Override
            public void onPlainText(Blob nonceKeyBits) {
                Consumer.decrypt(encryptedPayloadBlob, nonceKeyBits, callerOnPlainText, onError);
            }
        }, onError);
    }

    private Blob getDecryptionKey(Name decryptionKeyName) throws ConsumerDb.Error {
        return this.database_.getKey(decryptionKeyName);
    }

    public static void setFriendAccess(Friend friend) {
        if (friend.getClass().getName().equals("src.net.named_data.jndn.tests.integration_tests.TestGroupConsumer")) {
            friend.setConsumerFriendAccess(new FriendAccessImpl());
        }
    }

    private static class FriendAccessImpl
    extends FriendAccess {
        private FriendAccessImpl() {
        }

        @Override
        public void decrypt(Blob encryptedBlob, Blob keyBits, OnPlainText onPlainText, EncryptError.OnError onError) {
            Consumer.decrypt(encryptedBlob, keyBits, onPlainText, onError);
        }
    }

    public static abstract class FriendAccess {
        public abstract void decrypt(Blob var1, Blob var2, OnPlainText var3, EncryptError.OnError var4);
    }

    public static interface Friend {
        public void setConsumerFriendAccess(FriendAccess var1);
    }

    public static interface OnPlainText {
        public void onPlainText(Blob var1);
    }

    public static interface OnConsumeComplete {
        public void onConsumeComplete(Data var1, Blob var2);
    }
}

