/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.ContentType;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.ChangeCountable;

public class MetaInfo
implements ChangeCountable {
    private ContentType type_ = ContentType.BLOB;
    private int otherTypeCode_ = -1;
    private double freshnessPeriod_ = -1.0;
    private Name.Component finalBlockId_ = new Name.Component();
    private long changeCount_ = 0L;

    public MetaInfo() {
    }

    public MetaInfo(MetaInfo metaInfo) {
        this.type_ = metaInfo.type_;
        this.freshnessPeriod_ = metaInfo.freshnessPeriod_;
        this.finalBlockId_ = metaInfo.finalBlockId_;
    }

    public final ContentType getType() {
        return this.type_;
    }

    public final int getOtherTypeCode() {
        return this.otherTypeCode_;
    }

    public final double getFreshnessPeriod() {
        return this.freshnessPeriod_;
    }

    public final int getFreshnessSeconds() {
        return this.freshnessPeriod_ < 0.0 ? -1 : (int)Math.round(this.freshnessPeriod_ / 1000.0);
    }

    public final Name.Component getFinalBlockId() {
        return this.finalBlockId_;
    }

    public final Name.Component getFinalBlockID() {
        return this.getFinalBlockId();
    }

    public final void setType(ContentType type) {
        this.type_ = type;
        ++this.changeCount_;
    }

    public final void setOtherTypeCode(int otherTypeCode) {
        if (otherTypeCode < 0) {
            throw new Error("MetaInfo other type code must be non-negative");
        }
        this.otherTypeCode_ = otherTypeCode;
        ++this.changeCount_;
    }

    public final void setFreshnessPeriod(double freshnessPeriod) {
        this.freshnessPeriod_ = freshnessPeriod;
        ++this.changeCount_;
    }

    public final void setFreshnessSeconds(int freshnessSeconds) {
        this.setFreshnessPeriod(freshnessSeconds < 0 ? -1.0 : (double)freshnessSeconds * 1000.0);
    }

    public final void setFinalBlockId(Name.Component finalBlockId) {
        this.finalBlockId_ = finalBlockId == null ? new Name.Component() : finalBlockId;
        ++this.changeCount_;
    }

    public final void setFinalBlockID(Name.Component finalBlockId) {
        this.setFinalBlockId(finalBlockId);
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }
}

