/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.named_data.jndn.Name;

public class NdnRegexMatcher {
    public static Matcher match(String pattern, Name name) {
        String nameUri = name.toUri();
        pattern = NdnRegexMatcher.sanitizeSets(pattern);
        pattern = pattern.replaceAll("<>", "(?:<.+?>)");
        pattern = pattern.replaceAll(">", "");
        Matcher match = Pattern.compile(pattern = pattern.replaceAll("<(?!!)", "/")).matcher(nameUri);
        if (match.find()) {
            return match;
        }
        return null;
    }

    private static String sanitizeSets(String pattern) {
        String newPattern = pattern;
        Pattern regex1 = Pattern.compile("\\[(\\^?)(.*?)\\]");
        Matcher match = regex1.matcher(pattern);
        while (match.find()) {
            int end;
            int start = match.start(2);
            if (start - (end = match.end(2)) == 0) continue;
            String oldStr = match.group(2);
            String newStr = oldStr.replace("><", ">|<");
            newPattern = newPattern.substring(0, start) + newStr + newPattern.substring(end);
        }
        boolean isNegative = newPattern.contains("[^");
        if (isNegative) {
            newPattern = newPattern.replace("[^", "(?:(?!");
            newPattern = newPattern.replace("]", ")(?:/.*)*)");
        } else {
            newPattern = newPattern.replace("[", "(");
            newPattern = newPattern.replace("]", ")");
        }
        return newPattern;
    }
}

