/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.util.ArrayList;

public class BoostInfoTree {
    private ArrayList<TreeEntry> subtrees_ = new ArrayList();
    private String value_ = "";
    private BoostInfoTree parent_ = null;
    private BoostInfoTree lastChild_ = null;

    public BoostInfoTree(String value, BoostInfoTree parent) {
        this.value_ = value;
        this.parent_ = parent;
    }

    public BoostInfoTree(String value) {
        this.value_ = value;
    }

    public BoostInfoTree() {
    }

    public final void addSubtree(String treeName, BoostInfoTree newTree) {
        ArrayList subtreeList = this.find(treeName);
        if (subtreeList != null) {
            subtreeList.add(newTree);
        } else {
            TreeEntry entry = new TreeEntry(treeName);
            this.subtrees_.add(entry);
            entry.subtreeList_.add(newTree);
        }
        newTree.parent_ = this;
        this.lastChild_ = newTree;
    }

    public final BoostInfoTree createSubtree(String treeName, String value) {
        BoostInfoTree newTree = new BoostInfoTree(value, this);
        this.addSubtree(treeName, newTree);
        return newTree;
    }

    public final BoostInfoTree createSubtree(String treeName) {
        return this.createSubtree(treeName, "");
    }

    public final ArrayList get(String key) {
        int i;
        ArrayList<BoostInfoTree> foundVals = new ArrayList<BoostInfoTree>();
        if ((key = key.replaceFirst("^/+", "")).length() == 0) {
            foundVals.add(this);
            return foundVals;
        }
        String[] path = key.split("/");
        ArrayList subtrees = this.find(path[0]);
        if (subtrees == null) {
            return foundVals;
        }
        if (path.length == 1) {
            return (ArrayList)subtrees.clone();
        }
        String newPath = "";
        for (i = 1; i < path.length; ++i) {
            if (i > 1) {
                newPath = newPath + "/";
            }
            newPath = newPath + path[i];
        }
        for (i = 0; i < subtrees.size(); ++i) {
            BoostInfoTree t = (BoostInfoTree)subtrees.get(i);
            ArrayList partial = t.get(newPath);
            foundVals.addAll(partial);
        }
        return foundVals;
    }

    public final String getFirstValue(String key) {
        ArrayList list = this.get(key);
        if (list.size() >= 1) {
            return ((BoostInfoTree)list.get((int)0)).value_;
        }
        return null;
    }

    public final String getValue() {
        return this.value_;
    }

    public final BoostInfoTree getParent() {
        return this.parent_;
    }

    public final BoostInfoTree getLastChild() {
        return this.lastChild_;
    }

    public final String prettyPrint(int indentLevel) {
        String prefix = new String(new char[indentLevel]).replace("\u0000", " ");
        String s = "";
        if (this.parent_ != null) {
            if (this.value_.length() > 0) {
                s = s + "\"" + this.value_ + "\"";
            }
            s = s + "\n";
        }
        if (this.subtrees_.size() > 0) {
            if (this.parent_ != null) {
                s = s + prefix + "{\n";
            }
            String nextLevel = new String(new char[indentLevel + 2]).replace("\u0000", " ");
            for (int i = 0; i < this.subtrees_.size(); ++i) {
                TreeEntry entry = this.subtrees_.get(i);
                for (int iSubTree = 0; iSubTree < entry.subtreeList_.size(); ++iSubTree) {
                    s = s + nextLevel + entry.treeName_ + " " + ((BoostInfoTree)entry.subtreeList_.get(iSubTree)).prettyPrint(indentLevel + 2);
                }
            }
            if (this.parent_ != null) {
                s = s + prefix + "}\n";
            }
        }
        return s;
    }

    public final String prettyPrint() {
        return this.prettyPrint(1);
    }

    public String toString() {
        return this.prettyPrint();
    }

    private ArrayList find(String treeName) {
        for (int i = 0; i < this.subtrees_.size(); ++i) {
            TreeEntry entry = this.subtrees_.get(i);
            if (!entry.treeName_.equals(treeName)) continue;
            return entry.subtreeList_;
        }
        return null;
    }

    private class TreeEntry {
        public String treeName_;
        public ArrayList subtreeList_ = new ArrayList();

        public TreeEntry(String treeName) {
            this.treeName_ = treeName;
        }
    }
}

