/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.OnVerifyFailed;
import net.named_data.jndn.security.OnVerifyInterestFailed;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.IdentityStorage;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.SignedBlob;

public class SelfVerifyPolicyManager
extends PolicyManager {
    private final IdentityStorage identityStorage_;
    private static final Logger logger_ = Logger.getLogger(SelfVerifyPolicyManager.class.getName());

    public SelfVerifyPolicyManager(IdentityStorage identityStorage) {
        this.identityStorage_ = identityStorage;
    }

    public SelfVerifyPolicyManager() {
        this.identityStorage_ = null;
    }

    @Override
    public boolean skipVerifyAndTrust(Data data) {
        return false;
    }

    @Override
    public boolean skipVerifyAndTrust(Interest interest) {
        return false;
    }

    @Override
    public boolean requireVerify(Data data) {
        return true;
    }

    @Override
    public boolean requireVerify(Interest interest) {
        return true;
    }

    @Override
    public ValidationRequest checkVerificationPolicy(Data data, int stepCount, OnVerified onVerified, OnVerifyFailed onVerifyFailed) throws SecurityException {
        if (this.verify(data.getSignature(), data.wireEncode())) {
            try {
                onVerified.onVerified(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerified", ex);
            }
        } else {
            try {
                onVerifyFailed.onVerifyFailed(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifyFailed", ex);
            }
        }
        return null;
    }

    @Override
    public ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed, WireFormat wireFormat) throws SecurityException {
        Signature signature;
        try {
            signature = wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf());
        }
        catch (EncodingException ex) {
            logger_.log(Level.INFO, "Cannot decode the signed interest SignatureInfo and value", ex);
            try {
                onVerifyFailed.onVerifyInterestFailed(interest);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", exception);
            }
            return null;
        }
        if (this.verify(signature, interest.wireEncode(wireFormat))) {
            try {
                onVerified.onVerifiedInterest(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifiedInterest", ex);
            }
        } else {
            try {
                onVerifyFailed.onVerifyInterestFailed(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", ex);
            }
        }
        return null;
    }

    @Override
    public boolean checkSigningPolicy(Name dataName, Name certificateName) {
        return true;
    }

    @Override
    public Name inferSigningIdentity(Name dataName) {
        return new Name();
    }

    private boolean verify(Signature signatureInfo, SignedBlob signedBlob) throws SecurityException {
        Blob publicKeyDer = null;
        if (KeyLocator.canGetFromSignature(signatureInfo) && (publicKeyDer = this.getPublicKeyDer(KeyLocator.getFromSignature(signatureInfo))).isNull()) {
            return false;
        }
        return SelfVerifyPolicyManager.verifySignature(signatureInfo, signedBlob, publicKeyDer);
    }

    private Blob getPublicKeyDer(KeyLocator keyLocator) throws SecurityException {
        if (keyLocator.getType() == KeyLocatorType.KEYNAME && this.identityStorage_ != null) {
            try {
                return this.identityStorage_.getKey(IdentityCertificate.certificateNameToPublicKeyName(keyLocator.getKeyName()));
            }
            catch (SecurityException ex) {
                return new Blob();
            }
        }
        return new Blob();
    }
}

