/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerEncodingException;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.EcdsaKeyParams;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.CertificateSubjectDescription;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.identity.BasicIdentityStorage;
import net.named_data.jndn.security.identity.FilePrivateKeyStorage;
import net.named_data.jndn.security.identity.IdentityStorage;
import net.named_data.jndn.security.identity.PrivateKeyStorage;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.ConfigFile;
import net.named_data.jndn.util.SignedBlob;

public class IdentityManager {
    private final IdentityStorage identityStorage_;
    private final PrivateKeyStorage privateKeyStorage_;

    public IdentityManager(IdentityStorage identityStorage, PrivateKeyStorage privateKeyStorage) {
        this.identityStorage_ = identityStorage;
        this.privateKeyStorage_ = privateKeyStorage;
    }

    public IdentityManager(IdentityStorage identityStorage) throws SecurityException {
        ConfigFile config;
        try {
            config = new ConfigFile();
        }
        catch (IOException ex) {
            throw new SecurityException("IOException " + ex.getMessage());
        }
        String[] canonicalTpmLocator = new String[]{null};
        this.identityStorage_ = identityStorage;
        this.privateKeyStorage_ = IdentityManager.getDefaultPrivateKeyStorage(config, canonicalTpmLocator);
        this.checkTpm(canonicalTpmLocator[0]);
    }

    public IdentityManager() throws SecurityException {
        ConfigFile config;
        try {
            config = new ConfigFile();
        }
        catch (IOException ex) {
            throw new SecurityException("IOException " + ex.getMessage());
        }
        String[] canonicalTpmLocator = new String[]{null};
        this.identityStorage_ = IdentityManager.getDefaultIdentityStorage(config);
        this.privateKeyStorage_ = IdentityManager.getDefaultPrivateKeyStorage(config, canonicalTpmLocator);
        this.checkTpm(canonicalTpmLocator[0]);
    }

    public final Name createIdentityAndCertificate(Name identityName, KeyParams params) throws SecurityException {
        this.identityStorage_.addIdentity(identityName);
        Name keyName = null;
        boolean generateKey = true;
        try {
            keyName = this.identityStorage_.getDefaultKeyNameForIdentity(identityName);
            PublicKey key = new PublicKey(this.identityStorage_.getKey(keyName));
            if (key.getKeyType() == params.getKeyType()) {
                generateKey = false;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (generateKey) {
            keyName = this.generateKeyPair(identityName, true, params);
            this.identityStorage_.setDefaultKeyNameForIdentity(keyName);
        }
        Name certName = null;
        boolean makeCert = true;
        try {
            certName = this.identityStorage_.getDefaultCertificateNameForKey(keyName);
            makeCert = false;
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (makeCert) {
            IdentityCertificate selfCert = this.selfSign(keyName);
            this.addCertificateAsIdentityDefault(selfCert);
            certName = selfCert.getName();
        }
        return certName;
    }

    public final Name createIdentity(Name identityName, KeyParams params) throws SecurityException {
        return IdentityCertificate.certificateNameToPublicKeyName(this.createIdentityAndCertificate(identityName, params));
    }

    public final void deleteIdentity(Name identityName) throws SecurityException {
        try {
            if (this.identityStorage_.getDefaultIdentity().equals(identityName)) {
                return;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        ArrayList keysToDelete = new ArrayList();
        this.identityStorage_.getAllKeyNamesOfIdentity(identityName, keysToDelete, true);
        this.identityStorage_.getAllKeyNamesOfIdentity(identityName, keysToDelete, false);
        this.identityStorage_.deleteIdentityInfo(identityName);
        for (int i = 0; i < keysToDelete.size(); ++i) {
            this.privateKeyStorage_.deleteKeyPair((Name)keysToDelete.get(i));
        }
    }

    public final void setDefaultIdentity(Name identityName) throws SecurityException {
        this.identityStorage_.setDefaultIdentity(identityName);
    }

    public final Name getDefaultIdentity() throws SecurityException {
        return this.identityStorage_.getDefaultIdentity();
    }

    public final IdentityCertificate getDefaultCertificate() throws SecurityException {
        return this.identityStorage_.getDefaultCertificate();
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        Name keyName = this.generateKeyPair(identityName, isKsk, new RsaKeyParams(keySize));
        return keyName;
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        return this.generateRSAKeyPair(identityName, isKsk, 2048);
    }

    public final Name generateRSAKeyPair(Name identityName) throws SecurityException {
        return this.generateRSAKeyPair(identityName, false, 2048);
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        Name keyName = this.generateKeyPair(identityName, isKsk, new EcdsaKeyParams(keySize));
        return keyName;
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        return this.generateEcdsaKeyPair(identityName, isKsk, 256);
    }

    public final Name generateEcdsaKeyPair(Name identityName) throws SecurityException {
        return this.generateEcdsaKeyPair(identityName, false, 256);
    }

    public final void setDefaultKeyForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        this.identityStorage_.setDefaultKeyNameForIdentity(keyName, identityNameCheck);
    }

    public final void setDefaultKeyForIdentity(Name keyName) throws SecurityException {
        this.setDefaultKeyForIdentity(keyName, new Name());
    }

    public final Name getDefaultKeyNameForIdentity(Name identityName) throws SecurityException {
        return this.identityStorage_.getDefaultKeyNameForIdentity(identityName);
    }

    public final Name getDefaultKeyNameForIdentity() throws SecurityException {
        return this.getDefaultKeyNameForIdentity(new Name());
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        Name keyName = this.generateKeyPair(identityName, isKsk, new RsaKeyParams(keySize));
        this.identityStorage_.setDefaultKeyNameForIdentity(keyName);
        return keyName;
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        return this.generateRSAKeyPairAsDefault(identityName, isKsk, 2048);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName) throws SecurityException {
        return this.generateRSAKeyPairAsDefault(identityName, false, 2048);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        Name keyName = this.generateKeyPair(identityName, isKsk, new EcdsaKeyParams(keySize));
        this.identityStorage_.setDefaultKeyNameForIdentity(keyName);
        return keyName;
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        return this.generateEcdsaKeyPairAsDefault(identityName, isKsk, 256);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName) throws SecurityException {
        return this.generateEcdsaKeyPairAsDefault(identityName, false, 256);
    }

    public final PublicKey getPublicKey(Name keyName) throws SecurityException {
        return new PublicKey(this.identityStorage_.getKey(keyName));
    }

    public final Name createIdentityCertificate(Name certificatePrefix, Name signerCertificateName, double notBefore, double notAfter) throws SecurityException {
        Name keyName = IdentityManager.getKeyNameFromCertificatePrefix(certificatePrefix);
        Blob keyBlob = this.identityStorage_.getKey(keyName);
        PublicKey publicKey = new PublicKey(keyBlob);
        IdentityCertificate certificate = this.createIdentityCertificate(certificatePrefix, publicKey, signerCertificateName, notBefore, notAfter);
        this.identityStorage_.addCertificate(certificate);
        return certificate.getName();
    }

    public final IdentityCertificate prepareUnsignedIdentityCertificate(Name keyName, Name signingIdentity, double notBefore, double notAfter, List subjectDescription, Name certPrefix) throws SecurityException {
        PublicKey publicKey;
        try {
            publicKey = new PublicKey(this.identityStorage_.getKey(keyName));
        }
        catch (SecurityException e) {
            return null;
        }
        return this.prepareUnsignedIdentityCertificate(keyName, publicKey, signingIdentity, notBefore, notAfter, subjectDescription, certPrefix);
    }

    public final IdentityCertificate prepareUnsignedIdentityCertificate(Name keyName, Name signingIdentity, double notBefore, double notAfter, List subjectDescription) throws SecurityException {
        return this.prepareUnsignedIdentityCertificate(keyName, signingIdentity, notBefore, notAfter, subjectDescription, null);
    }

    public final IdentityCertificate prepareUnsignedIdentityCertificate(Name keyName, PublicKey publicKey, Name signingIdentity, double notBefore, double notAfter, List subjectDescription, Name certPrefix) throws SecurityException {
        if (keyName.size() < 1) {
            return null;
        }
        String tempKeyIdPrefix = keyName.get(-1).toEscapedString();
        if (tempKeyIdPrefix.length() < 4) {
            return null;
        }
        String keyIdPrefix = tempKeyIdPrefix.substring(0, 4);
        if (!keyIdPrefix.equals("ksk-") && !keyIdPrefix.equals("dsk-")) {
            return null;
        }
        IdentityCertificate certificate = new IdentityCertificate();
        Name certName = new Name();
        if (certPrefix == null) {
            if (signingIdentity.match(keyName)) {
                certName.append(signingIdentity).append("KEY").append(keyName.getSubName(signingIdentity.size())).append("ID-CERT").appendVersion((long)Common.getNowMilliseconds());
            } else {
                certName.append(keyName.getPrefix(-1)).append("KEY").append(keyName.get(-1)).append("ID-CERT").appendVersion((long)Common.getNowMilliseconds());
            }
        } else if (certPrefix.match(keyName) && !certPrefix.equals(keyName)) {
            certName.append(certPrefix).append("KEY").append(keyName.getSubName(certPrefix.size())).append("ID-CERT").appendVersion((long)Common.getNowMilliseconds());
        } else {
            return null;
        }
        certificate.setName(certName);
        certificate.setNotBefore(notBefore);
        certificate.setNotAfter(notAfter);
        certificate.setPublicKeyInfo(publicKey);
        if (subjectDescription == null || subjectDescription.isEmpty()) {
            certificate.addSubjectDescription(new CertificateSubjectDescription("2.5.4.41", keyName.getPrefix(-1).toUri()));
        } else {
            for (int i = 0; i < subjectDescription.size(); ++i) {
                certificate.addSubjectDescription((CertificateSubjectDescription)subjectDescription.get(i));
            }
        }
        try {
            certificate.encode();
        }
        catch (DerEncodingException ex) {
            throw new SecurityException("DerEncodingException: " + ex);
        }
        catch (DerDecodingException ex) {
            throw new SecurityException("DerDecodingException: " + ex);
        }
        return certificate;
    }

    public final IdentityCertificate prepareUnsignedIdentityCertificate(Name keyName, PublicKey publicKey, Name signingIdentity, double notBefore, double notAfter, List subjectDescription) throws SecurityException {
        return this.prepareUnsignedIdentityCertificate(keyName, publicKey, signingIdentity, notBefore, notAfter, subjectDescription, null);
    }

    public final IdentityCertificate createIdentityCertificate(Name certificatePrefix, PublicKey publicKey, Name signerCertificateName, double notBefore, double notAfter) throws SecurityException {
        IdentityCertificate signerCertificate;
        IdentityCertificate certificate = new IdentityCertificate();
        Name keyName = IdentityManager.getKeyNameFromCertificatePrefix(certificatePrefix);
        Name certificateName = new Name(certificatePrefix);
        certificateName.append("ID-CERT").appendVersion((long)Common.getNowMilliseconds());
        certificate.setName(certificateName);
        certificate.setNotBefore(notBefore);
        certificate.setNotAfter(notAfter);
        certificate.setPublicKeyInfo(publicKey);
        certificate.addSubjectDescription(new CertificateSubjectDescription("2.5.4.41", keyName.toUri()));
        try {
            certificate.encode();
        }
        catch (DerEncodingException ex) {
            throw new SecurityException("DerDecodingException: " + ex);
        }
        catch (DerDecodingException ex) {
            throw new SecurityException("DerEncodingException: " + ex);
        }
        Sha256WithRsaSignature sha256Sig = new Sha256WithRsaSignature();
        KeyLocator keyLocator = new KeyLocator();
        keyLocator.setType(KeyLocatorType.KEYNAME);
        keyLocator.setKeyName(signerCertificateName);
        sha256Sig.setKeyLocator(keyLocator);
        certificate.setSignature(sha256Sig);
        SignedBlob unsignedData = certificate.wireEncode();
        try {
            signerCertificate = this.getCertificate(signerCertificateName);
        }
        catch (DerDecodingException ex) {
            throw new SecurityException("DerDecodingException: " + ex);
        }
        Name signerkeyName = signerCertificate.getPublicKeyName();
        Blob sigBits = this.privateKeyStorage_.sign(unsignedData.signedBuf(), signerkeyName);
        sha256Sig.setSignature(sigBits);
        return certificate;
    }

    public final void addCertificate(IdentityCertificate certificate) throws SecurityException {
        this.identityStorage_.addCertificate(certificate);
    }

    public final void setDefaultCertificateForKey(IdentityCertificate certificate) throws SecurityException {
        Name keyName = certificate.getPublicKeyName();
        if (!this.identityStorage_.doesKeyExist(keyName)) {
            throw new SecurityException("No corresponding Key record for certificate!");
        }
        this.identityStorage_.setDefaultCertificateNameForKey(keyName, certificate.getName());
    }

    public final void addCertificateAsIdentityDefault(IdentityCertificate certificate) throws SecurityException {
        this.identityStorage_.addCertificate(certificate);
        Name keyName = certificate.getPublicKeyName();
        this.setDefaultKeyForIdentity(keyName);
        this.setDefaultCertificateForKey(certificate);
    }

    public final void addCertificateAsDefault(IdentityCertificate certificate) throws SecurityException {
        this.identityStorage_.addCertificate(certificate);
        this.setDefaultCertificateForKey(certificate);
    }

    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException, DerDecodingException {
        return this.identityStorage_.getCertificate(certificateName);
    }

    public final Name getDefaultCertificateNameForIdentity(Name identityName) throws SecurityException {
        return this.identityStorage_.getDefaultCertificateNameForIdentity(identityName);
    }

    public final Name getDefaultCertificateName() throws SecurityException {
        return this.identityStorage_.getDefaultCertificateNameForIdentity(this.getDefaultIdentity());
    }

    public void getAllIdentities(ArrayList nameList, boolean isDefault) throws SecurityException {
        this.identityStorage_.getAllIdentities(nameList, isDefault);
    }

    public final void getAllKeyNamesOfIdentity(Name identityName, ArrayList nameList, boolean isDefault) throws SecurityException {
        this.identityStorage_.getAllKeyNamesOfIdentity(identityName, nameList, isDefault);
    }

    public void getAllCertificateNamesOfKey(Name keyName, ArrayList nameList, boolean isDefault) throws SecurityException {
        this.identityStorage_.getAllCertificateNamesOfKey(keyName, nameList, isDefault);
    }

    public final Signature signByCertificate(ByteBuffer buffer, Name certificateName) throws SecurityException {
        DigestAlgorithm[] digestAlgorithm = new DigestAlgorithm[1];
        Signature signature = this.makeSignatureByCertificate(certificateName, digestAlgorithm);
        signature.setSignature(this.privateKeyStorage_.sign(buffer, IdentityCertificate.certificateNameToPublicKeyName(certificateName), digestAlgorithm[0]));
        return signature;
    }

    public final void signByCertificate(Data data, Name certificateName) throws SecurityException {
        this.signByCertificate(data, certificateName, WireFormat.getDefaultWireFormat());
    }

    public final void signByCertificate(Data data, Name certificateName, WireFormat wireFormat) throws SecurityException {
        DigestAlgorithm[] digestAlgorithm = new DigestAlgorithm[1];
        Signature signature = this.makeSignatureByCertificate(certificateName, digestAlgorithm);
        data.setSignature(signature);
        SignedBlob encoding = data.wireEncode(wireFormat);
        data.getSignature().setSignature(this.privateKeyStorage_.sign(encoding.signedBuf(), IdentityCertificate.certificateNameToPublicKeyName(certificateName), digestAlgorithm[0]));
        data.wireEncode(wireFormat);
    }

    public final void signInterestByCertificate(Interest interest, Name certificateName, WireFormat wireFormat) throws SecurityException {
        DigestAlgorithm[] digestAlgorithm = new DigestAlgorithm[1];
        Signature signature = this.makeSignatureByCertificate(certificateName, digestAlgorithm);
        interest.getName().append(wireFormat.encodeSignatureInfo(signature));
        interest.getName().append(new Name.Component());
        SignedBlob encoding = interest.wireEncode(wireFormat);
        signature.setSignature(this.privateKeyStorage_.sign(encoding.signedBuf(), IdentityCertificate.certificateNameToPublicKeyName(certificateName), digestAlgorithm[0]));
        interest.setName(interest.getName().getPrefix(-1).append(wireFormat.encodeSignatureValue(signature)));
    }

    public final void signWithSha256(Data data, WireFormat wireFormat) {
        data.setSignature(new DigestSha256Signature());
        SignedBlob encoding = data.wireEncode(wireFormat);
        byte[] signedPortionDigest = Common.digestSha256(encoding.signedBuf());
        data.getSignature().setSignature(new Blob(signedPortionDigest, false));
        data.wireEncode(wireFormat);
    }

    public final void signInterestWithSha256(Interest interest, WireFormat wireFormat) {
        DigestSha256Signature signature = new DigestSha256Signature();
        interest.getName().append(wireFormat.encodeSignatureInfo(signature));
        interest.getName().append(new Name.Component());
        SignedBlob encoding = interest.wireEncode(wireFormat);
        byte[] signedPortionDigest = Common.digestSha256(encoding.signedBuf());
        signature.setSignature(new Blob(signedPortionDigest, false));
        interest.setName(interest.getName().getPrefix(-1).append(wireFormat.encodeSignatureValue(signature)));
    }

    public IdentityCertificate selfSign(Name keyName) throws SecurityException {
        IdentityCertificate certificate = new IdentityCertificate();
        Blob keyBlob = this.identityStorage_.getKey(keyName);
        PublicKey publicKey = new PublicKey(keyBlob);
        Calendar calendar = Calendar.getInstance();
        double notBefore = calendar.getTimeInMillis();
        calendar.add(1, 2);
        double notAfter = calendar.getTimeInMillis();
        certificate.setNotBefore(notBefore);
        certificate.setNotAfter(notAfter);
        Name certificateName = keyName.getPrefix(-1).append("KEY").append(keyName.get(-1)).append("ID-CERT").appendVersion((long)certificate.getNotBefore());
        certificate.setName(certificateName);
        certificate.setPublicKeyInfo(publicKey);
        certificate.addSubjectDescription(new CertificateSubjectDescription("2.5.4.41", keyName.toUri()));
        try {
            certificate.encode();
        }
        catch (DerEncodingException ex) {
            Logger.getLogger(IdentityManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (DerDecodingException ex) {
            Logger.getLogger(IdentityManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        this.signByCertificate(certificate, certificate.getName());
        return certificate;
    }

    private Name generateKeyPair(Name identityName, boolean isKsk, KeyParams params) throws SecurityException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Get new key ID");
        Name keyName = this.identityStorage_.getNewKeyName(identityName, isKsk);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Generate key pair in private storage");
        this.privateKeyStorage_.generateKeyPair(keyName, params);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Create a key record in public storage");
        PublicKey pubKey = this.privateKeyStorage_.getPublicKey(keyName);
        this.identityStorage_.addKey(keyName, params.getKeyType(), pubKey.getKeyDer());
        return keyName;
    }

    private static Name getKeyNameFromCertificatePrefix(Name certificatePrefix) throws SecurityException {
        int i;
        Name result = new Name();
        String keyString = "KEY";
        for (i = 0; i < certificatePrefix.size() && !certificatePrefix.get(i).toEscapedString().equals(keyString); ++i) {
        }
        if (i >= certificatePrefix.size()) {
            throw new SecurityException("Identity Certificate Prefix does not have a KEY component");
        }
        result.append(certificatePrefix.getSubName(0, i));
        result.append(certificatePrefix.getSubName(i + 1, certificatePrefix.size() - i - 1));
        return result;
    }

    private Signature makeSignatureByCertificate(Name certificateName, DigestAlgorithm[] digestAlgorithm) throws SecurityException {
        Name keyName = IdentityCertificate.certificateNameToPublicKeyName(certificateName);
        PublicKey publicKey = this.privateKeyStorage_.getPublicKey(keyName);
        KeyType keyType = publicKey.getKeyType();
        if (keyType == KeyType.RSA) {
            Sha256WithRsaSignature signature = new Sha256WithRsaSignature();
            digestAlgorithm[0] = DigestAlgorithm.SHA256;
            signature.getKeyLocator().setType(KeyLocatorType.KEYNAME);
            signature.getKeyLocator().setKeyName(certificateName.getPrefix(-1));
            return signature;
        }
        if (keyType == KeyType.ECDSA) {
            Sha256WithEcdsaSignature signature = new Sha256WithEcdsaSignature();
            digestAlgorithm[0] = DigestAlgorithm.SHA256;
            signature.getKeyLocator().setType(KeyLocatorType.KEYNAME);
            signature.getKeyLocator().setKeyName(certificateName.getPrefix(-1));
            return signature;
        }
        throw new SecurityException("Key type is not recognized");
    }

    private static IdentityStorage getDefaultIdentityStorage(ConfigFile config) throws SecurityException {
        String pibLocator = config.get("pib", "");
        if (!pibLocator.equals("") && !pibLocator.equals("pib-sqlite3")) {
            throw new SecurityException("Invalid config file pib value: " + pibLocator);
        }
        return new BasicIdentityStorage();
    }

    private static PrivateKeyStorage getDefaultPrivateKeyStorage(ConfigFile config, String[] canonicalTpmLocator) throws SecurityException {
        String tpmLocator = config.get("tpm", "");
        if (tpmLocator.equals("")) {
            if (System.getProperty("os.name").equals("Mac OS X")) {
                canonicalTpmLocator[0] = "tpm-osxkeychain:";
                throw new SecurityException("OSXPrivateKeyStorage is not implemented yet. You must create an IdentityManager with a different PrivateKeyStorage.");
            }
            canonicalTpmLocator[0] = "tpm-file:";
            return new FilePrivateKeyStorage();
        }
        if (tpmLocator.equals("tpm-osxkeychain")) {
            canonicalTpmLocator[0] = "tpm-osxkeychain:";
            throw new SecurityException("OSXPrivateKeyStorage is not implemented yet. You must create an IdentityManager with a different PrivateKeyStorage.");
        }
        if (tpmLocator.equals("tpm-file")) {
            canonicalTpmLocator[0] = "tpm-file:";
            return new FilePrivateKeyStorage();
        }
        throw new SecurityException("Invalid config file tpm value: " + tpmLocator);
    }

    private void checkTpm(String canonicalTpmLocator) throws SecurityException {
        String tpmLocator;
        try {
            tpmLocator = this.identityStorage_.getTpmLocator();
        }
        catch (SecurityException ex) {
            return;
        }
        if (!tpmLocator.equals("") && !tpmLocator.equals(canonicalTpmLocator)) {
            throw new SecurityException("The TPM locator supplied does not match the TPM locator in the PIB: " + tpmLocator + " != " + canonicalTpmLocator);
        }
    }
}

