/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.certificate;

import net.named_data.jndn.Data;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.security.certificate.Certificate;
import net.named_data.jndn.util.Blob;

public class IdentityCertificate
extends Certificate {
    private Name publicKeyName_ = new Name();

    public IdentityCertificate() {
    }

    public IdentityCertificate(Data data) throws DerDecodingException {
        super(data);
        if (!IdentityCertificate.isCorrectName(data.getName())) {
            throw new SecurityException("Wrong Identity Certificate Name!");
        }
        this.setPublicKeyName();
    }

    public IdentityCertificate(IdentityCertificate identityCertificate) throws DerDecodingException {
        super(identityCertificate);
        this.publicKeyName_ = identityCertificate.publicKeyName_;
    }

    @Override
    public Data setName(Name name) {
        if (!IdentityCertificate.isCorrectName(name)) {
            throw new SecurityException("Wrong Identity Certificate Name!");
        }
        super.setName(name);
        this.setPublicKeyName();
        return this;
    }

    @Override
    public void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        super.wireDecode(input, wireFormat);
        this.setPublicKeyName();
    }

    public final Name getPublicKeyName() {
        return this.publicKeyName_;
    }

    public static boolean isIdentityCertificate(Certificate certificate) {
        return IdentityCertificate.isCorrectName(certificate.getName());
    }

    public static Name certificateNameToPublicKeyName(Name certificateName) {
        int keyComponentIndex;
        String idString = "ID-CERT";
        boolean foundIdString = false;
        int idCertComponentIndex = certificateName.size() - 1;
        while (idCertComponentIndex + 1 > 0) {
            if (certificateName.get(idCertComponentIndex).toEscapedString().equals(idString)) {
                foundIdString = true;
                break;
            }
            --idCertComponentIndex;
        }
        if (!foundIdString) {
            throw new Error("Incorrect identity certificate name " + certificateName.toUri());
        }
        Name tempName = certificateName.getSubName(0, idCertComponentIndex);
        String keyString = "KEY";
        boolean foundKeyString = false;
        for (keyComponentIndex = 0; keyComponentIndex < tempName.size(); ++keyComponentIndex) {
            if (!tempName.get(keyComponentIndex).toEscapedString().equals(keyString)) continue;
            foundKeyString = true;
            break;
        }
        if (!foundKeyString) {
            throw new Error("Incorrect identity certificate name " + certificateName.toUri());
        }
        return tempName.getSubName(0, keyComponentIndex).append(tempName.getSubName(keyComponentIndex + 1, tempName.size() - keyComponentIndex - 1));
    }

    private static boolean isCorrectName(Name name) {
        int keyIdx;
        int i;
        String idString = "ID-CERT";
        for (i = name.size() - 1; i >= 0 && !name.get(i).toEscapedString().equals(idString); --i) {
        }
        if (i < 0) {
            return false;
        }
        String keyString = "KEY";
        for (keyIdx = 0; keyIdx < name.size() && !name.get(keyIdx).toEscapedString().equals(keyString); ++keyIdx) {
        }
        return keyIdx < name.size();
    }

    private void setPublicKeyName() {
        this.publicKeyName_ = IdentityCertificate.certificateNameToPublicKeyName(this.getName());
    }
}

