/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.OnVerifyFailed;
import net.named_data.jndn.security.OnVerifyInterestFailed;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.IdentityManager;
import net.named_data.jndn.security.policy.NoVerifyPolicyManager;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public class KeyChain {
    public static final RsaKeyParams DEFAULT_KEY_PARAMS = new RsaKeyParams();
    private final IdentityManager identityManager_;
    private final PolicyManager policyManager_;
    private Face face_ = null;
    private static final Logger logger_ = Logger.getLogger(KeyChain.class.getName());

    public KeyChain(IdentityManager identityManager, PolicyManager policyManager) {
        this.identityManager_ = identityManager;
        this.policyManager_ = policyManager;
    }

    public KeyChain(IdentityManager identityManager) {
        this.identityManager_ = identityManager;
        this.policyManager_ = new NoVerifyPolicyManager();
    }

    public KeyChain() throws SecurityException {
        this.identityManager_ = new IdentityManager();
        this.policyManager_ = new NoVerifyPolicyManager();
    }

    public final Name createIdentityAndCertificate(Name identityName, KeyParams params) throws SecurityException {
        return this.identityManager_.createIdentityAndCertificate(identityName, params);
    }

    public final Name createIdentityAndCertificate(Name identityName) throws SecurityException {
        return this.createIdentityAndCertificate(identityName, DEFAULT_KEY_PARAMS);
    }

    public final Name createIdentity(Name identityName, KeyParams params) throws SecurityException {
        return IdentityCertificate.certificateNameToPublicKeyName(this.createIdentityAndCertificate(identityName, params));
    }

    public final Name createIdentity(Name identityName) throws SecurityException {
        return IdentityCertificate.certificateNameToPublicKeyName(this.createIdentityAndCertificate(identityName));
    }

    public final void deleteIdentity(Name identityName) throws SecurityException {
        this.identityManager_.deleteIdentity(identityName);
    }

    public final Name getDefaultIdentity() throws SecurityException {
        return this.identityManager_.getDefaultIdentity();
    }

    public final Name getDefaultCertificateName() throws SecurityException {
        return this.identityManager_.getDefaultCertificateName();
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        return this.identityManager_.generateRSAKeyPair(identityName, isKsk, keySize);
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        return this.identityManager_.generateRSAKeyPair(identityName, isKsk);
    }

    public final Name generateRSAKeyPair(Name identityName) throws SecurityException {
        return this.identityManager_.generateRSAKeyPair(identityName);
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPair(identityName, isKsk, keySize);
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPair(identityName, isKsk);
    }

    public final Name generateEcdsaKeyPair(Name identityName) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPair(identityName);
    }

    public final void setDefaultKeyForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        this.identityManager_.setDefaultKeyForIdentity(keyName, identityNameCheck);
    }

    public final void setDefaultKeyForIdentity(Name keyName) throws SecurityException {
        this.identityManager_.setDefaultKeyForIdentity(keyName);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName, isKsk, keySize);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName, isKsk);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName) throws SecurityException {
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName, isKsk, keySize);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName, isKsk);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName) throws SecurityException {
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName);
    }

    public final Blob createSigningRequest(Name keyName) throws SecurityException {
        return this.identityManager_.getPublicKey(keyName).getKeyDer();
    }

    public final void installIdentityCertificate(IdentityCertificate certificate) throws SecurityException {
        this.identityManager_.addCertificate(certificate);
    }

    public final void setDefaultCertificateForKey(IdentityCertificate certificate) throws SecurityException {
        this.identityManager_.setDefaultCertificateForKey(certificate);
    }

    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException, DerDecodingException {
        return this.identityManager_.getCertificate(certificateName);
    }

    public final IdentityCertificate getIdentityCertificate(Name certificateName) throws SecurityException, DerDecodingException {
        return this.identityManager_.getCertificate(certificateName);
    }

    public final void revokeKey(Name keyName) {
    }

    public final void revokeCertificate(Name certificateName) {
    }

    public final IdentityManager getIdentityManager() {
        return this.identityManager_;
    }

    public final void sign(Data data, Name certificateName, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signByCertificate(data, certificateName, wireFormat);
    }

    public final void sign(Data data, Name certificateName) throws SecurityException {
        this.sign(data, certificateName, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Data data, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signByCertificate(data, this.prepareDefaultCertificateName(), wireFormat);
    }

    public final void sign(Data data) throws SecurityException {
        this.sign(data, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Interest interest, Name certificateName, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signInterestByCertificate(interest, certificateName, wireFormat);
    }

    public final void sign(Interest interest, Name certificateName) throws SecurityException {
        this.sign(interest, certificateName, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Interest interest, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signInterestByCertificate(interest, this.prepareDefaultCertificateName(), wireFormat);
    }

    public final void sign(Interest interest) throws SecurityException {
        this.sign(interest, WireFormat.getDefaultWireFormat());
    }

    public Signature sign(ByteBuffer buffer, Name certificateName) throws SecurityException {
        return this.identityManager_.signByCertificate(buffer, certificateName);
    }

    public final void signByIdentity(Data data, Name identityName, WireFormat wireFormat) throws SecurityException {
        Name inferredIdentity;
        Name signingCertificateName = identityName.size() == 0 ? ((inferredIdentity = this.policyManager_.inferSigningIdentity(data.getName())).size() == 0 ? this.identityManager_.getDefaultCertificateName() : this.identityManager_.getDefaultCertificateNameForIdentity(inferredIdentity)) : this.identityManager_.getDefaultCertificateNameForIdentity(identityName);
        if (signingCertificateName.size() == 0) {
            throw new SecurityException("No qualified certificate name found!");
        }
        if (!this.policyManager_.checkSigningPolicy(data.getName(), signingCertificateName)) {
            throw new SecurityException("Signing Cert name does not comply with signing policy");
        }
        this.identityManager_.signByCertificate(data, signingCertificateName, wireFormat);
    }

    public final void signByIdentity(Data data, Name identityName) throws SecurityException {
        this.signByIdentity(data, identityName, WireFormat.getDefaultWireFormat());
    }

    public final void signByIdentity(Data data) throws SecurityException {
        this.signByIdentity(data, new Name(), WireFormat.getDefaultWireFormat());
    }

    public Signature signByIdentity(ByteBuffer buffer, Name identityName) throws SecurityException {
        Name signingCertificateName = this.identityManager_.getDefaultCertificateNameForIdentity(identityName);
        if (signingCertificateName.size() == 0) {
            throw new SecurityException("No qualified certificate name found!");
        }
        return this.identityManager_.signByCertificate(buffer, signingCertificateName);
    }

    public final void signWithSha256(Data data, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signWithSha256(data, wireFormat);
    }

    public final void signWithSha256(Data data) throws SecurityException {
        this.signWithSha256(data, WireFormat.getDefaultWireFormat());
    }

    public final void signWithSha256(Interest interest, WireFormat wireFormat) throws SecurityException {
        this.identityManager_.signInterestWithSha256(interest, wireFormat);
    }

    public final void signWithSha256(Interest interest) throws SecurityException {
        this.signWithSha256(interest, WireFormat.getDefaultWireFormat());
    }

    public final void verifyData(Data data, OnVerified onVerified, OnVerifyFailed onVerifyFailed, int stepCount) throws SecurityException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Enter Verify");
        if (this.policyManager_.requireVerify(data)) {
            ValidationRequest nextStep = this.policyManager_.checkVerificationPolicy(data, stepCount, onVerified, onVerifyFailed);
            if (nextStep != null) {
                VerifyCallbacks callbacks = new VerifyCallbacks(nextStep, nextStep.retry_, onVerifyFailed, data);
                try {
                    this.face_.expressInterest(nextStep.interest_, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        onVerifyFailed.onVerifyFailed(data);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onVerifyFailed", exception);
                    }
                }
            }
        } else if (this.policyManager_.skipVerifyAndTrust(data)) {
            try {
                onVerified.onVerified(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerified", ex);
            }
        } else {
            try {
                onVerifyFailed.onVerifyFailed(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifyFailed", ex);
            }
        }
    }

    public final void verifyData(Data data, OnVerified onVerified, OnVerifyFailed onVerifyFailed) throws SecurityException {
        this.verifyData(data, onVerified, onVerifyFailed, 0);
    }

    public final void verifyInterest(Interest interest, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed, int stepCount) throws SecurityException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Enter Verify");
        if (this.policyManager_.requireVerify(interest)) {
            ValidationRequest nextStep = this.policyManager_.checkVerificationPolicy(interest, stepCount, onVerified, onVerifyFailed);
            if (nextStep != null) {
                VerifyCallbacksForVerifyInterest callbacks = new VerifyCallbacksForVerifyInterest(nextStep, nextStep.retry_, onVerifyFailed, interest);
                try {
                    this.face_.expressInterest(nextStep.interest_, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        onVerifyFailed.onVerifyInterestFailed(interest);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", exception);
                    }
                }
            }
        } else if (this.policyManager_.skipVerifyAndTrust(interest)) {
            try {
                onVerified.onVerifiedInterest(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifiedInterest", ex);
            }
        } else {
            try {
                onVerifyFailed.onVerifyInterestFailed(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", ex);
            }
        }
    }

    public final void verifyInterest(Interest interest, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed) throws SecurityException {
        this.verifyInterest(interest, onVerified, onVerifyFailed, 0);
    }

    public final void setFace(Face face) {
        this.face_ = face;
    }

    public static void signWithHmacWithSha256(Data data, Blob key, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        byte[] signatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        data.getSignature().setSignature(new Blob(signatureBytes, false));
    }

    public static void signWithHmacWithSha256(Data data, Blob key) {
        KeyChain.signWithHmacWithSha256(data, key, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataWithHmacWithSha256(Data data, Blob key, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        byte[] newSignatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        return ByteBuffer.wrap(newSignatureBytes).equals(data.getSignature().getSignature().buf());
    }

    public static boolean verifyDataWithHmacWithSha256(Data data, Blob key) {
        return KeyChain.verifyDataWithHmacWithSha256(data, key, WireFormat.getDefaultWireFormat());
    }

    private Name prepareDefaultCertificateName() throws SecurityException {
        IdentityCertificate signingCertificate = this.identityManager_.getDefaultCertificate();
        if (signingCertificate == null) {
            this.setDefaultCertificate();
            signingCertificate = this.identityManager_.getDefaultCertificate();
        }
        return signingCertificate.getName();
    }

    private void setDefaultCertificate() throws SecurityException {
        if (this.identityManager_.getDefaultCertificate() == null) {
            Name defaultIdentity;
            try {
                defaultIdentity = this.identityManager_.getDefaultIdentity();
            }
            catch (SecurityException e) {
                ByteBuffer randomComponent = ByteBuffer.allocate(4);
                Common.getRandom().nextBytes(randomComponent.array());
                defaultIdentity = new Name().append("tmp-identity").append(new Blob(randomComponent, false));
            }
            this.createIdentityAndCertificate(defaultIdentity);
            this.identityManager_.setDefaultIdentity(defaultIdentity);
        }
    }

    private class VerifyCallbacksForVerifyInterest
    implements OnData,
    OnTimeout {
        private final ValidationRequest nextStep_;
        private final int retry_;
        private final OnVerifyInterestFailed onVerifyFailed_;
        private final Interest originalInterest_;

        public VerifyCallbacksForVerifyInterest(ValidationRequest nextStep, int retry, OnVerifyInterestFailed onVerifyFailed, Interest originalInterest) {
            this.nextStep_ = nextStep;
            this.retry_ = retry;
            this.onVerifyFailed_ = onVerifyFailed;
            this.originalInterest_ = originalInterest;
        }

        @Override
        public final void onData(Interest interest, Data data) {
            try {
                KeyChain.this.verifyData(data, this.nextStep_.onVerified_, this.nextStep_.onVerifyFailed_, this.nextStep_.stepCount_);
            }
            catch (SecurityException ex) {
                Logger.getLogger(KeyChain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (this.retry_ > 0) {
                VerifyCallbacksForVerifyInterest callbacks = new VerifyCallbacksForVerifyInterest(this.nextStep_, this.retry_ - 1, this.onVerifyFailed_, this.originalInterest_);
                try {
                    KeyChain.this.face_.expressInterest(interest, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        this.onVerifyFailed_.onVerifyInterestFailed(this.originalInterest_);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", exception);
                    }
                }
            } else {
                try {
                    this.onVerifyFailed_.onVerifyInterestFailed(this.originalInterest_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onVerifyInterestFailed", ex);
                }
            }
        }
    }

    private class VerifyCallbacks
    implements OnData,
    OnTimeout {
        private final ValidationRequest nextStep_;
        private final int retry_;
        private final OnVerifyFailed onVerifyFailed_;
        private final Data originalData_;

        public VerifyCallbacks(ValidationRequest nextStep, int retry, OnVerifyFailed onVerifyFailed, Data originalData) {
            this.nextStep_ = nextStep;
            this.retry_ = retry;
            this.onVerifyFailed_ = onVerifyFailed;
            this.originalData_ = originalData;
        }

        @Override
        public final void onData(Interest interest, Data data) {
            try {
                KeyChain.this.verifyData(data, this.nextStep_.onVerified_, this.nextStep_.onVerifyFailed_, this.nextStep_.stepCount_);
            }
            catch (SecurityException ex) {
                Logger.getLogger(KeyChain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (this.retry_ > 0) {
                VerifyCallbacks callbacks = new VerifyCallbacks(this.nextStep_, this.retry_ - 1, this.onVerifyFailed_, this.originalData_);
                try {
                    KeyChain.this.face_.expressInterest(interest, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        this.onVerifyFailed_.onVerifyFailed(this.originalData_);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onVerifyFailed", exception);
                    }
                }
            } else {
                try {
                    this.onVerifyFailed_.onVerifyFailed(this.originalData_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onVerifyFailed", ex);
                }
            }
        }
    }
}

