/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.Data;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.algo.AesAlgorithm;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.encrypt.algo.RsaAlgorithm;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class Encryptor {
    public static final Name.Component NAME_COMPONENT_FOR = new Name.Component("FOR");
    public static final Name.Component NAME_COMPONENT_READ = new Name.Component("READ");
    public static final Name.Component NAME_COMPONENT_SAMPLE = new Name.Component("SAMPLE");
    public static final Name.Component NAME_COMPONENT_ACCESS = new Name.Component("ACCESS");
    public static final Name.Component NAME_COMPONENT_E_KEY = new Name.Component("E-KEY");
    public static final Name.Component NAME_COMPONENT_D_KEY = new Name.Component("D-KEY");
    public static final Name.Component NAME_COMPONENT_C_KEY = new Name.Component("C-KEY");

    public static void encryptData(Data data, Blob payload, Name keyName, Blob key, EncryptParams params) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        data.getName().append(NAME_COMPONENT_FOR).append(keyName);
        EncryptAlgorithmType algorithmType = params.getAlgorithmType();
        if (algorithmType == EncryptAlgorithmType.AesCbc || algorithmType == EncryptAlgorithmType.AesEcb) {
            EncryptedContent content = Encryptor.encryptSymmetric(payload, key, keyName, params);
            data.setContent(content.wireEncode(TlvWireFormat.get()));
        } else if (algorithmType == EncryptAlgorithmType.RsaPkcs || algorithmType == EncryptAlgorithmType.RsaOaep) {
            try {
                EncryptedContent content = Encryptor.encryptAsymmetric(payload, key, keyName, params);
                data.setContent(content.wireEncode(TlvWireFormat.get()));
                return;
            }
            catch (IllegalBlockSizeException ex) {
                ByteBuffer nonceKeyBuffer = ByteBuffer.allocate(16);
                Common.getRandom().nextBytes(nonceKeyBuffer.array());
                Blob nonceKey = new Blob(nonceKeyBuffer, false);
                Name nonceKeyName = new Name(keyName);
                nonceKeyName.append("nonce");
                EncryptParams symmetricParams = new EncryptParams(EncryptAlgorithmType.AesCbc, 16);
                EncryptedContent nonceContent = Encryptor.encryptSymmetric(payload, nonceKey, nonceKeyName, symmetricParams);
                EncryptedContent payloadContent = Encryptor.encryptAsymmetric(nonceKey, key, keyName, params);
                Blob nonceContentEncoding = nonceContent.wireEncode();
                Blob payloadContentEncoding = payloadContent.wireEncode();
                ByteBuffer content = ByteBuffer.allocate(nonceContentEncoding.size() + payloadContentEncoding.size());
                content.put(payloadContentEncoding.buf());
                content.put(nonceContentEncoding.buf());
                content.flip();
                data.setContent(new Blob(content, false));
            }
        } else {
            throw new Error("Unsupported encryption method");
        }
    }

    private static EncryptedContent encryptSymmetric(Blob payload, Blob key, Name keyName, EncryptParams params) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        EncryptAlgorithmType algorithmType = params.getAlgorithmType();
        Blob initialVector = params.getInitialVector();
        KeyLocator keyLocator = new KeyLocator();
        keyLocator.setType(KeyLocatorType.KEYNAME);
        keyLocator.setKeyName(keyName);
        if (algorithmType == EncryptAlgorithmType.AesCbc || algorithmType == EncryptAlgorithmType.AesEcb) {
            if (algorithmType == EncryptAlgorithmType.AesCbc && initialVector.size() != 16) {
                throw new Error("incorrect initial vector size");
            }
            Blob encryptedPayload = AesAlgorithm.encrypt(key, payload, params);
            EncryptedContent result = new EncryptedContent();
            result.setAlgorithmType(algorithmType);
            result.setKeyLocator(keyLocator);
            result.setPayload(encryptedPayload);
            result.setInitialVector(initialVector);
            return result;
        }
        throw new Error("Unsupported encryption method");
    }

    private static EncryptedContent encryptAsymmetric(Blob payload, Blob key, Name keyName, EncryptParams params) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        EncryptAlgorithmType algorithmType = params.getAlgorithmType();
        KeyLocator keyLocator = new KeyLocator();
        keyLocator.setType(KeyLocatorType.KEYNAME);
        keyLocator.setKeyName(keyName);
        if (algorithmType == EncryptAlgorithmType.RsaPkcs || algorithmType == EncryptAlgorithmType.RsaOaep) {
            Blob encryptedPayload = RsaAlgorithm.encrypt(key, payload, params);
            EncryptedContent result = new EncryptedContent();
            result.setAlgorithmType(algorithmType);
            result.setKeyLocator(keyLocator);
            result.setPayload(encryptedPayload);
            return result;
        }
        throw new Error("Unsupported encryption method");
    }
}

