/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.util.Calendar;
import java.util.TimeZone;
import net.named_data.jndn.encrypt.Interval;

public class RepetitiveInterval
implements Comparable {
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private final double startDate_;
    private final double endDate_;
    private final int intervalStartHour_;
    private final int intervalEndHour_;
    private final int nRepeats_;
    private final RepeatUnit repeatUnit_;

    public RepetitiveInterval() {
        this.startDate_ = -1.7976931348623157E308;
        this.endDate_ = -1.7976931348623157E308;
        this.intervalStartHour_ = 0;
        this.intervalEndHour_ = 24;
        this.nRepeats_ = 0;
        this.repeatUnit_ = RepeatUnit.NONE;
    }

    public RepetitiveInterval(double startDate, double endDate, int intervalStartHour, int intervalEndHour, int nRepeats, RepeatUnit repeatUnit) {
        this.startDate_ = RepetitiveInterval.toDateOnlyMilliseconds(startDate);
        this.endDate_ = RepetitiveInterval.toDateOnlyMilliseconds(endDate);
        this.intervalStartHour_ = intervalStartHour;
        this.intervalEndHour_ = intervalEndHour;
        this.nRepeats_ = nRepeats;
        this.repeatUnit_ = repeatUnit;
        this.validate();
    }

    public RepetitiveInterval(double startDate, double endDate, int intervalStartHour, int intervalEndHour) {
        this.startDate_ = RepetitiveInterval.toDateOnlyMilliseconds(startDate);
        this.endDate_ = RepetitiveInterval.toDateOnlyMilliseconds(endDate);
        this.intervalStartHour_ = intervalStartHour;
        this.intervalEndHour_ = intervalEndHour;
        this.nRepeats_ = 0;
        this.repeatUnit_ = RepeatUnit.NONE;
        this.validate();
    }

    public RepetitiveInterval(RepetitiveInterval repetitiveInterval) {
        this.startDate_ = repetitiveInterval.startDate_;
        this.endDate_ = repetitiveInterval.endDate_;
        this.intervalStartHour_ = repetitiveInterval.intervalStartHour_;
        this.intervalEndHour_ = repetitiveInterval.intervalEndHour_;
        this.nRepeats_ = repetitiveInterval.nRepeats_;
        this.repeatUnit_ = repetitiveInterval.repeatUnit_;
    }

    private void validate() {
        if (this.intervalStartHour_ >= this.intervalEndHour_) {
            throw new Error("ReptitiveInterval: startHour must be less than endHour");
        }
        if (!(this.startDate_ <= this.endDate_)) {
            throw new Error("ReptitiveInterval: startDate must be earlier than or same as endDate");
        }
        if (this.intervalStartHour_ < 0) {
            throw new Error("ReptitiveInterval: intervalStartHour must be non-negative");
        }
        if (this.intervalEndHour_ < 1 || this.intervalEndHour_ > 24) {
            throw new Error("ReptitiveInterval: intervalEndHour must be from 1 to 24");
        }
        if (this.repeatUnit_ == RepeatUnit.NONE && this.startDate_ != this.endDate_) {
            throw new Error("ReptitiveInterval: With RepeatUnit.NONE, startDate must equal endDate");
        }
    }

    public final Result getInterval(double timePoint) {
        boolean isPositive;
        double endTime;
        double startTime;
        if (!this.hasIntervalOnDate(timePoint)) {
            startTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint);
            endTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint) + 8.64E7;
            isPositive = false;
        } else {
            startTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint) + (double)((long)this.intervalStartHour_ * 3600000L);
            endTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint) + (double)((long)this.intervalEndHour_ * 3600000L);
            if (timePoint < startTime) {
                endTime = startTime;
                startTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint);
                isPositive = false;
            } else if (timePoint > endTime) {
                startTime = endTime;
                endTime = RepetitiveInterval.toDateOnlyMilliseconds(timePoint) + 8.64E7;
                isPositive = false;
            } else {
                isPositive = true;
            }
        }
        return new Result(isPositive, new Interval(startTime, endTime));
    }

    public final int compare(RepetitiveInterval other) {
        if (this.startDate_ < other.startDate_) {
            return -1;
        }
        if (this.startDate_ > other.startDate_) {
            return 1;
        }
        if (this.endDate_ < other.endDate_) {
            return -1;
        }
        if (this.endDate_ > other.endDate_) {
            return 1;
        }
        if (this.intervalStartHour_ < other.intervalStartHour_) {
            return -1;
        }
        if (this.intervalStartHour_ > other.intervalStartHour_) {
            return 1;
        }
        if (this.intervalEndHour_ < other.intervalEndHour_) {
            return -1;
        }
        if (this.intervalEndHour_ > other.intervalEndHour_) {
            return 1;
        }
        if (this.nRepeats_ < other.nRepeats_) {
            return -1;
        }
        if (this.nRepeats_ > other.nRepeats_) {
            return 1;
        }
        return this.repeatUnit_.compare(other.repeatUnit_);
    }

    public int compareTo(Object other) {
        return this.compare((RepetitiveInterval)other);
    }

    public int CompareTo(Object other) {
        return this.compare((RepetitiveInterval)other);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RepetitiveInterval)) {
            return false;
        }
        return this.compare((RepetitiveInterval)other) == 0;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (int)(Double.doubleToLongBits(this.startDate_) ^ Double.doubleToLongBits(this.startDate_) >>> 32);
        hash = 73 * hash + (int)(Double.doubleToLongBits(this.endDate_) ^ Double.doubleToLongBits(this.endDate_) >>> 32);
        hash = 73 * hash + this.intervalStartHour_;
        hash = 73 * hash + this.intervalEndHour_;
        hash = 73 * hash + this.nRepeats_;
        hash = 73 * hash + this.repeatUnit_.getNumericType();
        return hash;
    }

    public final double getStartDate() {
        return this.startDate_;
    }

    public final double getEndDate() {
        return this.endDate_;
    }

    public final int getIntervalStartHour() {
        return this.intervalStartHour_;
    }

    public final int getIntervalEndHour() {
        return this.intervalEndHour_;
    }

    public final int getNRepeats() {
        return this.nRepeats_;
    }

    public final RepeatUnit getRepeatUnit() {
        return this.repeatUnit_;
    }

    private boolean hasIntervalOnDate(double timePoint) {
        double timePointDateMilliseconds = RepetitiveInterval.toDateOnlyMilliseconds(timePoint);
        if (timePointDateMilliseconds < this.startDate_ || timePointDateMilliseconds > this.endDate_) {
            return false;
        }
        if (this.repeatUnit_ == RepeatUnit.NONE) {
            return true;
        }
        if (this.repeatUnit_ == RepeatUnit.DAY) {
            long durationDays = (long)(timePointDateMilliseconds - this.startDate_) / 86400000L;
            if (durationDays % (long)this.nRepeats_ == 0L) {
                return true;
            }
        } else {
            int difference;
            int yearDifference;
            int monthDifference;
            Calendar timePointDate = RepetitiveInterval.toCalendar(timePointDateMilliseconds);
            Calendar startDate = RepetitiveInterval.toCalendar(this.startDate_);
            if (this.repeatUnit_ == RepeatUnit.MONTH && timePointDate.get(5) == startDate.get(5) ? (monthDifference = 12 * (yearDifference = timePointDate.get(1) - startDate.get(1)) + timePointDate.get(2) - startDate.get(2)) % this.nRepeats_ == 0 : this.repeatUnit_ == RepeatUnit.YEAR && timePointDate.get(5) == startDate.get(5) && timePointDate.get(2) == startDate.get(2) && (difference = timePointDate.get(1) - startDate.get(1)) % this.nRepeats_ == 0) {
                return true;
            }
        }
        return false;
    }

    public static double toDateOnlyMilliseconds(double timePoint) {
        long result = Math.round(timePoint);
        result -= result % 86400000L;
        return result;
    }

    private static Calendar toCalendar(double timePoint) {
        Calendar result = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        result.setTimeInMillis((long)timePoint);
        return result;
    }

    public static class Result {
        public boolean isPositive;
        public Interval interval;

        public Result(boolean isPositive, Interval interval) {
            this.isPositive = isPositive;
            this.interval = interval;
        }
    }

    public static enum RepeatUnit {
        NONE(0),
        DAY(1),
        MONTH(2),
        YEAR(3);

        private final int type_;

        private RepeatUnit(int type) {
            this.type_ = type;
        }

        public final int getNumericType() {
            return this.type_;
        }

        public final int compare(RepeatUnit other) {
            if (this.getNumericType() < other.getNumericType()) {
                return -1;
            }
            if (this.getNumericType() == other.getNumericType()) {
                return 0;
            }
            return 1;
        }
    }
}

