/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnRegisterSuccess;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.transport.Transport;

public class ThreadPoolFace
extends Face {
    private final ScheduledExecutorService threadPool_;
    private static final Logger logger_ = Logger.getLogger(ThreadPoolFace.class.getName());

    public ThreadPoolFace(ScheduledExecutorService threadPool, Transport transport, Transport.ConnectionInfo connectionInfo) {
        super(transport, connectionInfo);
        this.threadPool_ = threadPool;
    }

    @Override
    public long expressInterest(Interest interest, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack, final WireFormat wireFormat) throws IOException {
        final long pendingInterestId = this.node_.getNextEntryId();
        final OnData finalOnData = onData;
        final OnData onDataSubmit = new OnData(){

            @Override
            public void onData(final Interest localInterest, final Data data) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnData.onData(localInterest, data);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onData", ex);
                        }
                    }
                });
            }
        };
        final OnTimeout finalOnTimeout = onTimeout;
        final OnTimeout onTimeoutSubmit = onTimeout == null ? null : new OnTimeout(){

            @Override
            public void onTimeout(final Interest localInterest) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnTimeout.onTimeout(localInterest);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                        }
                    }
                });
            }
        };
        final OnNetworkNack finalOnNetworkNack = onNetworkNack;
        final OnNetworkNack onNetworkNackSubmit = onNetworkNack == null ? null : new OnNetworkNack(){

            @Override
            public void onNetworkNack(final Interest localInterest, final NetworkNack networkNack) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnNetworkNack.onNetworkNack(localInterest, networkNack);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onNetworkNack", ex);
                        }
                    }
                });
            }
        };
        final Interest interestCopy = new Interest(interest);
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.expressInterest(pendingInterestId, interestCopy, onDataSubmit, onTimeoutSubmit, onNetworkNackSubmit, wireFormat, ThreadPoolFace.this);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        });
        return pendingInterestId;
    }

    @Override
    public long expressInterest(Name name, Interest interestTemplate, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack, final WireFormat wireFormat) throws IOException {
        final long pendingInterestId = this.node_.getNextEntryId();
        final OnData finalOnData = onData;
        final OnData onDataSubmit = new OnData(){

            @Override
            public void onData(final Interest localInterest, final Data data) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnData.onData(localInterest, data);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onData", ex);
                        }
                    }
                });
            }
        };
        final OnTimeout finalOnTimeout = onTimeout;
        final OnTimeout onTimeoutSubmit = onTimeout == null ? null : new OnTimeout(){

            @Override
            public void onTimeout(final Interest localInterest) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnTimeout.onTimeout(localInterest);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                        }
                    }
                });
            }
        };
        final OnNetworkNack finalOnNetworkNack = onNetworkNack;
        final OnNetworkNack onNetworkNackSubmit = onNetworkNack == null ? null : new OnNetworkNack(){

            @Override
            public void onNetworkNack(final Interest localInterest, final NetworkNack networkNack) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnNetworkNack.onNetworkNack(localInterest, networkNack);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onNetworkNack", ex);
                        }
                    }
                });
            }
        };
        final Interest interestCopy = ThreadPoolFace.getInterestCopy(name, interestTemplate);
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.expressInterest(pendingInterestId, interestCopy, onDataSubmit, onTimeoutSubmit, onNetworkNackSubmit, wireFormat, ThreadPoolFace.this);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        });
        return pendingInterestId;
    }

    @Override
    public long registerPrefix(final Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, final ForwardingFlags flags, final WireFormat wireFormat) throws IOException, SecurityException {
        final long registeredPrefixId = this.node_.getNextEntryId();
        final OnInterestCallback finalOnInterest = onInterest;
        final OnInterestCallback onInterestSubmit = onInterest == null ? null : new OnInterestCallback(){

            @Override
            public void onInterest(final Name localPrefix, final Interest interest, final Face face, final long interestFilterId, final InterestFilter filter) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnInterest.onInterest(localPrefix, interest, face, interestFilterId, filter);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onInterest", ex);
                        }
                    }
                });
            }
        };
        final OnRegisterFailed finalOnRegisterFailed = onRegisterFailed;
        final OnRegisterFailed onRegisterFailedSubmit = new OnRegisterFailed(){

            @Override
            public void onRegisterFailed(final Name localPrefix) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnRegisterFailed.onRegisterFailed(localPrefix);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onRegisterFailed", ex);
                        }
                    }
                });
            }
        };
        final OnRegisterSuccess finalOnRegisterSuccess = onRegisterSuccess;
        final OnRegisterSuccess onRegisterSuccessSubmit = onRegisterSuccess == null ? null : new OnRegisterSuccess(){

            @Override
            public void onRegisterSuccess(final Name localPrefix, final long localRegisteredPrefixId) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnRegisterSuccess.onRegisterSuccess(localPrefix, localRegisteredPrefixId);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onRegisterSuccess", ex);
                        }
                    }
                });
            }
        };
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.registerPrefix(registeredPrefixId, prefix, onInterestSubmit, onRegisterFailedSubmit, onRegisterSuccessSubmit, flags, wireFormat, ThreadPoolFace.this.commandKeyChain_, ThreadPoolFace.this.commandCertificateName_, ThreadPoolFace.this);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        });
        return registeredPrefixId;
    }

    @Override
    public long setInterestFilter(final InterestFilter filter, OnInterestCallback onInterest) {
        final long interestFilterId = this.node_.getNextEntryId();
        final OnInterestCallback finalOnInterest = onInterest;
        final OnInterestCallback onInterestSubmit = new OnInterestCallback(){

            @Override
            public void onInterest(final Name prefix, final Interest interest, final Face face, final long interestFilterId, final InterestFilter filter) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnInterest.onInterest(prefix, interest, face, interestFilterId, filter);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onInterest", ex);
                        }
                    }
                });
            }
        };
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.setInterestFilter(interestFilterId, filter, onInterestSubmit, ThreadPoolFace.this);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        });
        return interestFilterId;
    }

    @Override
    public void callLater(double delayMilliseconds, final Runnable callback) {
        this.threadPool_.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.run();
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }
}

