/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.ChangeCountable;

public class Exclude
implements ChangeCountable {
    private final ArrayList<Entry> entries_;
    private long changeCount_ = 0L;

    public Exclude() {
        this.entries_ = new ArrayList();
    }

    public Exclude(Exclude exclude) {
        this.entries_ = new ArrayList<Entry>(exclude.entries_);
    }

    public final int size() {
        return this.entries_.size();
    }

    public final Entry get(int i) {
        return this.entries_.get(i);
    }

    public final Exclude appendAny() {
        this.entries_.add(new Entry());
        ++this.changeCount_;
        return this;
    }

    public final Exclude appendComponent(Name.Component component) {
        this.entries_.add(new Entry(component));
        ++this.changeCount_;
        return this;
    }

    public final void clear() {
        this.entries_.clear();
        ++this.changeCount_;
    }

    public boolean matches(Name.Component component) {
        for (int i = 0; i < this.entries_.size(); ++i) {
            if (this.get(i).getType() == Type.ANY) {
                int iUpperBound;
                Entry lowerBound = null;
                if (i > 0) {
                    lowerBound = this.get(i - 1);
                }
                Entry upperBound = null;
                for (iUpperBound = i + 1; iUpperBound < this.entries_.size(); ++iUpperBound) {
                    if (this.get(iUpperBound).getType() != Type.COMPONENT) continue;
                    upperBound = this.get(iUpperBound);
                    break;
                }
                if (upperBound != null) {
                    if (lowerBound != null ? component.compare(lowerBound.getComponent()) > 0 && component.compare(upperBound.getComponent()) < 0 : component.compare(upperBound.getComponent()) < 0) {
                        return true;
                    }
                    i = iUpperBound - 1;
                    continue;
                }
                if (lowerBound != null) {
                    if (component.compare(lowerBound.getComponent()) <= 0) continue;
                    return true;
                }
                return true;
            }
            if (!component.equals(this.get(i).getComponent())) continue;
            return true;
        }
        return false;
    }

    public final String toUri() {
        if (this.entries_.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.entries_.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            if (this.get(i).getType() == Type.ANY) {
                result.append("*");
                continue;
            }
            Name.toEscapedString(this.get(i).getComponent().getValue().buf(), result);
        }
        return result.toString();
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }

    public static class Entry {
        private final Type type_;
        private final Name.Component component_;

        public Entry() {
            this.type_ = Type.ANY;
            this.component_ = null;
        }

        public Entry(Name.Component component) {
            this.type_ = Type.COMPONENT;
            this.component_ = component;
        }

        public final Type getType() {
            return this.type_;
        }

        public final Name.Component getComponent() {
            return this.component_;
        }
    }

    public static enum Type {
        COMPONENT,
        ANY;

    }
}

