/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.util.Blob;

public class SegmentFetcher
implements OnData,
OnTimeout {
    public static final VerifySegment DontVerifySegment = new VerifySegment(){

        @Override
        public boolean verifySegment(Data data) {
            return true;
        }
    };
    private final ArrayList contentParts_ = new ArrayList();
    private final Face face_;
    private final VerifySegment verifySegment_;
    private final OnComplete onComplete_;
    private final OnError onError_;
    private static final Logger logger_ = Logger.getLogger(SegmentFetcher.class.getName());

    public static void fetch(Face face, Interest baseInterest, VerifySegment verifySegment, OnComplete onComplete, OnError onError) {
        new SegmentFetcher(face, verifySegment, onComplete, onError).fetchFirstSegment(baseInterest);
    }

    private SegmentFetcher(Face face, VerifySegment verifySegment, OnComplete onComplete, OnError onError) {
        this.face_ = face;
        this.verifySegment_ = verifySegment;
        this.onComplete_ = onComplete;
        this.onError_ = onError;
    }

    private void fetchFirstSegment(Interest baseInterest) {
        Interest interest = new Interest(baseInterest);
        interest.setChildSelector(1);
        interest.setMustBeFresh(true);
        try {
            this.face_.expressInterest(interest, (OnData)this, (OnTimeout)this);
        }
        catch (IOException ex) {
            try {
                this.onError_.onError(ErrorCode.IO_ERROR, "I/O error fetching the first segment " + ex);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
        }
    }

    private void fetchNextSegment(Interest originalInterest, Name dataName, long segment) {
        Interest interest = new Interest(originalInterest);
        interest.setMustBeFresh(false);
        interest.setName(dataName.getPrefix(-1).appendSegment(segment));
        try {
            this.face_.expressInterest(interest, (OnData)this, (OnTimeout)this);
        }
        catch (IOException ex) {
            try {
                this.onError_.onError(ErrorCode.IO_ERROR, "I/O error fetching the next segment " + ex);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
        }
    }

    @Override
    public void onData(Interest originalInterest, Data data) {
        boolean verified = false;
        try {
            verified = this.verifySegment_.verifySegment(data);
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in verifySegment", ex);
        }
        if (!verified) {
            try {
                this.onError_.onError(ErrorCode.SEGMENT_VERIFICATION_FAILED, "Segment verification failed");
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
            return;
        }
        if (!SegmentFetcher.endsWithSegmentNumber(data.getName())) {
            try {
                this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Got an unexpected packet without a segment number: " + data.getName().toUri());
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
        } else {
            long currentSegment;
            try {
                currentSegment = data.getName().get(-1).toSegment();
            }
            catch (EncodingException ex) {
                try {
                    this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Error decoding the name segment number " + data.getName().get(-1).toEscapedString() + ": " + ex);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
                return;
            }
            long expectedSegmentNumber = this.contentParts_.size();
            if (currentSegment != expectedSegmentNumber) {
                this.fetchNextSegment(originalInterest, data.getName(), expectedSegmentNumber);
            } else {
                this.contentParts_.add(data.getContent());
                if (data.getMetaInfo().getFinalBlockId().getValue().size() > 0) {
                    long finalSegmentNumber;
                    try {
                        finalSegmentNumber = data.getMetaInfo().getFinalBlockId().toSegment();
                    }
                    catch (EncodingException ex) {
                        try {
                            this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Error decoding the FinalBlockId segment number " + data.getMetaInfo().getFinalBlockId().toEscapedString() + ": " + ex);
                        }
                        catch (Throwable exception) {
                            logger_.log(Level.SEVERE, "Error in onError", exception);
                        }
                        return;
                    }
                    if (currentSegment == finalSegmentNumber) {
                        int totalSize = 0;
                        for (int i = 0; i < this.contentParts_.size(); ++i) {
                            totalSize += ((Blob)this.contentParts_.get(i)).size();
                        }
                        ByteBuffer content = ByteBuffer.allocate(totalSize);
                        for (int i = 0; i < this.contentParts_.size(); ++i) {
                            content.put(((Blob)this.contentParts_.get(i)).buf());
                        }
                        content.flip();
                        try {
                            this.onComplete_.onComplete(new Blob(content, false));
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onComplete", ex);
                        }
                        return;
                    }
                }
                this.fetchNextSegment(originalInterest, data.getName(), expectedSegmentNumber + 1L);
            }
        }
    }

    @Override
    public void onTimeout(Interest interest) {
        try {
            this.onError_.onError(ErrorCode.INTEREST_TIMEOUT, "Time out for interest " + interest.getName().toUri());
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in onError", ex);
        }
    }

    private static boolean endsWithSegmentNumber(Name name) {
        return name.size() >= 1 && name.get(-1).getValue().size() >= 1 && name.get(-1).getValue().buf().get(0) == 0;
    }

    public static interface OnError {
        public void onError(ErrorCode var1, String var2);
    }

    public static interface VerifySegment {
        public boolean verifySegment(Data var1);
    }

    public static interface OnComplete {
        public void onComplete(Blob var1);
    }

    public static enum ErrorCode {
        INTEREST_TIMEOUT,
        DATA_HAS_NO_SEGMENT,
        SEGMENT_VERIFICATION_FAILED,
        IO_ERROR;

    }
}

