/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import net.named_data.jndn.util.BoostInfoTree;

public class BoostInfoParser {
    private BoostInfoTree root_ = new BoostInfoTree();

    public BoostInfoTree read(String fileName) throws IOException {
        try (BufferedReader stream = new BufferedReader(new FileReader(fileName));){
            this.read(stream, this.root_);
        }
        return this.root_;
    }

    public BoostInfoTree read(String input, String inputName) throws IOException {
        BufferedReader stream = new BufferedReader(new StringReader(input));
        this.read(stream, this.root_);
        return this.root_;
    }

    public final void write(String fileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write(this.root_.toString());
            writer.flush();
        }
    }

    public final BoostInfoTree getRoot() {
        return this.root_;
    }

    private static void shlex_split(String s, ArrayList result) {
        if (s.length() == 0) {
            return;
        }
        String whiteSpace = " \t\n\r";
        int iStart = 0;
        while (true) {
            if (whiteSpace.indexOf(s.charAt(iStart)) >= 0) {
                if (++iStart < s.length()) continue;
                return;
            }
            int iEnd = iStart;
            boolean inQuotation = false;
            String token = "";
            do {
                if (s.charAt(iEnd) == '\\') {
                    token = token + s.substring(iStart, iEnd);
                    iStart = iEnd + 1;
                    if ((iEnd = iStart) < s.length()) continue;
                    break;
                }
                if (inQuotation) {
                    if (s.charAt(iEnd) != '\"') continue;
                    token = token + s.substring(iStart, iEnd);
                    iStart = iEnd + 1;
                    inQuotation = false;
                    continue;
                }
                if (s.charAt(iEnd) == '\"') {
                    token = token + s.substring(iStart, iEnd);
                    iStart = iEnd + 1;
                    inQuotation = true;
                    continue;
                }
                if (whiteSpace.indexOf(s.charAt(iEnd)) >= 0) break;
            } while (++iEnd < s.length());
            token = token + s.substring(iStart, iEnd);
            result.add(token);
            if (iEnd >= s.length()) {
                return;
            }
            iStart = iEnd;
        }
    }

    private BoostInfoTree read(BufferedReader stream, BoostInfoTree ctx) throws IOException {
        String line = null;
        while ((line = stream.readLine()) != null) {
            ctx = this.parseLine(line.trim(), ctx);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoostInfoTree parseLine(String line, BoostInfoTree context) throws IOException {
        int commentStart = line.indexOf(59);
        if (commentStart >= 0) {
            line = line.substring(0, commentStart).trim();
        }
        if (line.length() == 0) {
            return context;
        }
        ArrayList strings = new ArrayList();
        BoostInfoParser.shlex_split(line, strings);
        boolean isSectionStart = false;
        boolean isSectionEnd = false;
        for (int i = 0; i < strings.size(); ++i) {
            isSectionStart = isSectionStart || "{".equals(strings.get(i));
            isSectionEnd = isSectionEnd || "}".equals(strings.get(i));
        }
        if (!isSectionStart && !isSectionEnd) {
            String key = (String)strings.get(0);
            String val = "";
            if (strings.size() > 1) {
                val = (String)strings.get(1);
            }
            if ("#include".equals(key)) {
                try (BufferedReader stream = new BufferedReader(new FileReader(val));){
                    context = this.read(stream, context);
                }
            } else {
                context.createSubtree(key, val);
            }
            return context;
        }
        int sectionStart = line.indexOf(123);
        if (sectionStart > 0) {
            String firstPart = line.substring(0, sectionStart);
            String secondPart = line.substring(sectionStart);
            BoostInfoTree ctx = this.parseLine(firstPart, context);
            return this.parseLine(secondPart, ctx);
        }
        if (line.charAt(0) == '{') {
            context = context.getLastChild();
            return context;
        }
        if (line.charAt(0) == '}') {
            context = context.getParent();
            return context;
        }
        throw new Error("BoostInfoParser: input line is malformed");
    }
}

