/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.encoding.ElementListener;
import net.named_data.jndn.encoding.ElementReader;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.transport.TcpTransport;
import net.named_data.jndn.transport.Transport;

public class AsyncTcpTransport
extends Transport {
    private AsynchronousSocketChannel channel_;
    private final CompletionHandler<Integer, Void> readCompletionHandler_;
    private final CompletionHandler<Integer, ByteBuffer> writeCompletionHandler_;
    private final ScheduledExecutorService threadPool_;
    private ByteBuffer inputBuffer_ = ByteBuffer.allocate(8800);
    private ElementReader elementReader_;
    private ConnectionInfo connectionInfo_;
    private boolean isLocal_;
    private final Object isLocalLock_ = new Object();
    private final Semaphore writeLock_ = new Semaphore(1);
    private static final Logger logger_ = Logger.getLogger(AsyncTcpTransport.class.getName());
    public static final int DEFAULT_LOCK_TIMEOUT_MS = 10000;

    public AsyncTcpTransport(ScheduledExecutorService threadPool) {
        this.threadPool_ = threadPool;
        this.readCompletionHandler_ = new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer bytesRead, Void attachment) {
                try {
                    if (bytesRead > 0) {
                        AsyncTcpTransport.this.inputBuffer_.flip();
                        AsyncTcpTransport.this.elementReader_.onReceivedData(AsyncTcpTransport.this.inputBuffer_);
                    }
                    AsyncTcpTransport.this.asyncRead();
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void failed(Throwable ex, Void attachment) {
                logger_.log(Level.SEVERE, null, ex);
            }
        };
        this.writeCompletionHandler_ = new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer bytesRead, ByteBuffer data) {
                try {
                    if (data.hasRemaining()) {
                        AsyncTcpTransport.this.channel_.write(data, data, AsyncTcpTransport.this.writeCompletionHandler_);
                    } else {
                        AsyncTcpTransport.this.writeLock_.release();
                    }
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void failed(Throwable ex, ByteBuffer data) {
                AsyncTcpTransport.this.writeLock_.release();
                logger_.log(Level.SEVERE, null, ex);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocal(Transport.ConnectionInfo connectionInfo) throws IOException {
        Object object = this.isLocalLock_;
        synchronized (object) {
            if (this.connectionInfo_ == null || !((ConnectionInfo)connectionInfo).getHost().equals(this.connectionInfo_.getHost())) {
                this.isLocal_ = TcpTransport.getIsLocal(((ConnectionInfo)connectionInfo).getHost());
                this.connectionInfo_ = (ConnectionInfo)connectionInfo;
            }
            return this.isLocal_;
        }
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void connect(Transport.ConnectionInfo connectionInfo, ElementListener elementListener, final Runnable onConnected) throws IOException {
        this.channel_ = AsynchronousSocketChannel.open(AsynchronousChannelGroup.withThreadPool(this.threadPool_));
        this.channel_.connect(new InetSocketAddress(((ConnectionInfo)connectionInfo).getHost(), ((ConnectionInfo)connectionInfo).getPort()), null, new CompletionHandler<Void, Void>(){

            @Override
            public void completed(Void dummy, Void attachment) {
                try {
                    if (onConnected != null) {
                        onConnected.run();
                    }
                    AsyncTcpTransport.this.asyncRead();
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void failed(Throwable ex, Void attachment) {
                logger_.log(Level.SEVERE, null, ex);
            }
        });
        this.elementReader_ = new ElementReader(elementListener);
    }

    private void asyncRead() {
        this.inputBuffer_.limit(this.inputBuffer_.capacity());
        this.inputBuffer_.position(0);
        this.channel_.read(this.inputBuffer_, null, this.readCompletionHandler_);
    }

    @Override
    public void send(ByteBuffer data) throws IOException {
        if (!this.getIsConnected()) {
            throw new IOException("Cannot send because the socket is not open.  Use connect.");
        }
        data = data.duplicate();
        try {
            this.sendDataSequentially(data);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void sendDataSequentially(ByteBuffer data) throws InterruptedException, IOException {
        if (!this.writeLock_.tryAcquire(10000L, TimeUnit.MILLISECONDS)) {
            throw new IOException("Failed to acquire lock on channel to write buffer");
        }
        this.channel_.write(data, data, this.writeCompletionHandler_);
    }

    @Override
    public void processEvents() throws IOException, EncodingException {
    }

    @Override
    public boolean getIsConnected() throws IOException {
        if (this.channel_ == null) {
            return false;
        }
        return this.channel_.getRemoteAddress() != null;
    }

    public static class ConnectionInfo
    extends Transport.ConnectionInfo {
        private final String host_;
        private final int port_;

        public ConnectionInfo(String host, int port) {
            this.host_ = host;
            this.port_ = port;
        }

        public ConnectionInfo(String host) {
            this.host_ = host;
            this.port_ = 6363;
        }

        public final String getHost() {
            return this.host_;
        }

        public final int getPort() {
            return this.port_;
        }
    }
}

