/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.util.ArrayList;
import java.util.HashMap;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.IdentityStorage;
import net.named_data.jndn.util.Blob;

public class MemoryIdentityStorage
extends IdentityStorage {
    private final HashMap identityStore_ = new HashMap();
    private String defaultIdentity_ = "";
    private final HashMap keyStore_ = new HashMap();
    private final HashMap certificateStore_ = new HashMap();

    @Override
    public boolean doesIdentityExist(Name identityName) {
        return this.identityStore_.containsKey(identityName.toUri());
    }

    @Override
    public void addIdentity(Name identityName) throws SecurityException {
        String identityUri = identityName.toUri();
        if (this.identityStore_.containsKey(identityUri)) {
            return;
        }
        this.identityStore_.put(identityUri, new IdentityRecord());
    }

    @Override
    public boolean revokeIdentity() {
        throw new UnsupportedOperationException("MemoryIdentityStorage.revokeIdentity not implemented");
    }

    @Override
    public boolean doesKeyExist(Name keyName) throws SecurityException {
        return this.keyStore_.containsKey(keyName.toUri());
    }

    @Override
    public void addKey(Name keyName, KeyType keyType, Blob publicKeyDer) throws SecurityException {
        Name identityName = keyName.getSubName(0, keyName.size() - 1);
        this.addIdentity(identityName);
        if (this.doesKeyExist(keyName)) {
            throw new SecurityException("a key with the same name already exists!");
        }
        this.keyStore_.put(keyName.toUri(), new KeyRecord(keyType, publicKeyDer));
    }

    @Override
    public Blob getKey(Name keyName) {
        KeyRecord keyRecord = (KeyRecord)this.keyStore_.get(keyName.toUri());
        if (keyRecord == null) {
            return new Blob();
        }
        return keyRecord.getKeyDer();
    }

    @Override
    public void activateKey(Name keyName) {
        throw new UnsupportedOperationException("MemoryIdentityStorage.activateKey not implemented");
    }

    @Override
    public void deactivateKey(Name keyName) {
        throw new UnsupportedOperationException("MemoryIdentityStorage.deactivateKey not implemented");
    }

    @Override
    public boolean doesCertificateExist(Name certificateName) {
        return this.certificateStore_.containsKey(certificateName.toUri());
    }

    @Override
    public void addCertificate(IdentityCertificate certificate) throws SecurityException {
        Name certificateName = certificate.getName();
        Name keyName = certificate.getPublicKeyName();
        if (!this.doesKeyExist(keyName)) {
            throw new SecurityException("No corresponding Key record for certificate! " + keyName.toUri() + " " + certificateName.toUri());
        }
        if (this.doesCertificateExist(certificateName)) {
            throw new SecurityException("Certificate has already been installed!");
        }
        Blob keyBlob = this.getKey(keyName);
        if (keyBlob.isNull() || !keyBlob.equals(certificate.getPublicKeyInfo().getKeyDer())) {
            throw new SecurityException("Certificate does not match the public key!");
        }
        this.certificateStore_.put(certificateName.toUri(), certificate.wireEncode());
    }

    @Override
    public IdentityCertificate getCertificate(Name certificateName, boolean allowAny) {
        if (!allowAny) {
            throw new UnsupportedOperationException("MemoryIdentityStorage.getCertificate for !allowAny is not implemented");
        }
        Blob certificateDer = (Blob)this.certificateStore_.get(certificateName.toUri());
        if (certificateDer == null) {
            return new IdentityCertificate();
        }
        IdentityCertificate certificate = new IdentityCertificate();
        try {
            certificate.wireDecode(certificateDer);
        }
        catch (EncodingException ex) {
            return new IdentityCertificate();
        }
        return certificate;
    }

    @Override
    public Name getDefaultIdentity() throws SecurityException {
        if (this.defaultIdentity_.length() == 0) {
            throw new SecurityException("MemoryIdentityStorage.getDefaultIdentity: The default identity is not defined");
        }
        return new Name(this.defaultIdentity_);
    }

    @Override
    public Name getDefaultKeyNameForIdentity(Name identityName) throws SecurityException {
        String identity = identityName.toUri();
        if (this.identityStore_.containsKey(identity)) {
            if (((IdentityRecord)this.identityStore_.get(identity)).hasDefaultKey()) {
                return ((IdentityRecord)this.identityStore_.get(identity)).getDefaultKey();
            }
            throw new SecurityException("No default key set.");
        }
        throw new SecurityException("Identity not found.");
    }

    @Override
    public Name getDefaultCertificateNameForKey(Name keyName) throws SecurityException {
        String key = keyName.toUri();
        if (this.keyStore_.containsKey(key)) {
            if (((KeyRecord)this.keyStore_.get(key)).hasDefaultCertificate()) {
                return ((KeyRecord)this.keyStore_.get(key)).getDefaultCertificate();
            }
            throw new SecurityException("No default certificate set.");
        }
        throw new SecurityException("Key not found.");
    }

    @Override
    public void getAllKeyNamesOfIdentity(Name identityName, ArrayList nameList, boolean isDefault) {
        throw new UnsupportedOperationException("MemoryIdentityStorage.getAllKeyNamesOfIdentity not implemented");
    }

    @Override
    public void setDefaultIdentity(Name identityName) {
        String identityUri = identityName.toUri();
        this.defaultIdentity_ = this.identityStore_.containsKey(identityUri) ? identityUri : "";
    }

    @Override
    public void setDefaultKeyNameForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        Name identityName = keyName.getPrefix(-1);
        if (identityNameCheck.size() > 0 && !identityNameCheck.equals(identityName)) {
            throw new SecurityException("The specified identity name does not match the key name");
        }
        String identity = identityName.toUri();
        if (this.identityStore_.containsKey(identity)) {
            ((IdentityRecord)this.identityStore_.get(identity)).setDefaultKey(new Name(keyName));
        }
    }

    @Override
    public void setDefaultCertificateNameForKey(Name keyName, Name certificateName) {
        String key = keyName.toUri();
        if (this.keyStore_.containsKey(key)) {
            ((KeyRecord)this.keyStore_.get(key)).setDefaultCertificate(new Name(certificateName));
        }
    }

    @Override
    public void deleteCertificateInfo(Name certificateName) throws SecurityException {
        throw new UnsupportedOperationException("MemoryIdentityStorage.deleteCertificateInfo is not implemented");
    }

    @Override
    public void deletePublicKeyInfo(Name keyName) throws SecurityException {
        throw new UnsupportedOperationException("MemoryIdentityStorage.deletePublicKeyInfo is not implemented");
    }

    @Override
    public void deleteIdentityInfo(Name identity) throws SecurityException {
        throw new UnsupportedOperationException("MemoryIdentityStorage.deleteIdentityInfo is not implemented");
    }

    private static class KeyRecord {
        private KeyType keyType_;
        private Blob keyDer_;
        private Name defaultCertificate_;

        public KeyRecord(KeyType keyType, Blob keyDer) {
            this.keyType_ = keyType;
            this.keyDer_ = keyDer;
        }

        KeyType getKeyType() {
            return this.keyType_;
        }

        Blob getKeyDer() {
            return this.keyDer_;
        }

        void setDefaultCertificate(Name certificate) {
            this.defaultCertificate_ = certificate;
        }

        boolean hasDefaultCertificate() {
            return this.defaultCertificate_ != null;
        }

        Name getDefaultCertificate() {
            return this.defaultCertificate_;
        }
    }

    private static class IdentityRecord {
        private Name defaultKey_;

        private IdentityRecord() {
        }

        void setDefaultKey(Name key) {
            this.defaultKey_ = key;
        }

        boolean hasDefaultKey() {
            return this.defaultKey_ != null;
        }

        Name getDefaultKey() {
            return this.defaultKey_;
        }
    }
}

