/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;

public class PendingInterestTable {
    private final List table_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger(PendingInterestTable.class.getName());

    public final synchronized Entry add(long pendingInterestId, Interest interestCopy, OnData onData, OnTimeout onTimeout) {
        Entry entry = new Entry(pendingInterestId, interestCopy, onData, onTimeout);
        this.table_.add(entry);
        return entry;
    }

    public final synchronized void extractEntriesForExpressedInterest(Name name, ArrayList entries) {
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            Entry pendingInterest = (Entry)this.table_.get(i);
            if (!pendingInterest.getInterest().matchesName(name)) continue;
            entries.add(this.table_.get(i));
            this.table_.remove(i);
            pendingInterest.setIsRemoved();
        }
    }

    public final synchronized void removePendingInterest(long pendingInterestId) {
        int count = 0;
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            if (((Entry)this.table_.get(i)).getPendingInterestId() != pendingInterestId) continue;
            ++count;
            ((Entry)this.table_.get(i)).setIsRemoved();
            this.table_.remove(i);
        }
        if (count == 0) {
            logger_.log(Level.WARNING, "removePendingInterest: Didn't find pendingInterestId {0}", pendingInterestId);
        }
    }

    public final synchronized boolean removeEntry(Entry pendingInterest) {
        if (pendingInterest.getIsRemoved()) {
            return false;
        }
        if (this.table_.remove(pendingInterest)) {
            pendingInterest.setIsRemoved();
            return true;
        }
        return false;
    }

    public static class Entry {
        private final Interest interest_;
        private final long pendingInterestId_;
        private final OnData onData_;
        private final OnTimeout onTimeout_;
        private boolean isRemoved_ = false;

        public Entry(long pendingInterestId, Interest interest, OnData onData, OnTimeout onTimeout) {
            this.pendingInterestId_ = pendingInterestId;
            this.interest_ = interest;
            this.onData_ = onData;
            this.onTimeout_ = onTimeout;
        }

        public final long getPendingInterestId() {
            return this.pendingInterestId_;
        }

        public final Interest getInterest() {
            return this.interest_;
        }

        public final OnData getOnData() {
            return this.onData_;
        }

        public final void setIsRemoved() {
            this.isRemoved_ = true;
        }

        public final boolean getIsRemoved() {
            return this.isRemoved_;
        }

        public final void callTimeout() {
            if (this.onTimeout_ != null) {
                try {
                    this.onTimeout_.onTimeout(this.interest_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                }
            }
        }
    }
}

