/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encrypt.GroupManagerDb;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.encrypt.Sqlite3GroupManagerDbBase;
import net.named_data.jndn.util.Blob;

public class Sqlite3GroupManagerDb
extends Sqlite3GroupManagerDbBase {
    Connection database_ = null;

    public Sqlite3GroupManagerDb(String databaseFilePath) throws GroupManagerDb.Error {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Sqlite3GroupManagerDb.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            this.database_ = DriverManager.getConnection("jdbc:sqlite:" + databaseFilePath);
            try (Statement statement = this.database_.createStatement();){
                statement.executeUpdate("PRAGMA foreign_keys = ON");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  schedules(                                       \n    schedule_id         INTEGER PRIMARY KEY,       \n    schedule_name       TEXT NOT NULL,             \n    schedule            BLOB NOT NULL              \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   scheduleNameIndex ON schedules(schedule_name);  \n");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  members(                                         \n    member_id           INTEGER PRIMARY KEY,       \n    schedule_id         INTEGER NOT NULL,          \n    member_name         BLOB NOT NULL,             \n    key_name            BLOB NOT NULL,             \n    pubkey              BLOB NOT NULL,             \n    FOREIGN KEY(schedule_id)                       \n      REFERENCES schedules(schedule_id)            \n      ON DELETE CASCADE                            \n      ON UPDATE CASCADE                            \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   memNameIndex ON members(member_name);           \n");
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSchedule(String name) throws GroupManagerDb.Error {
        try {
            statement.setString(1, name);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT schedule_id FROM schedules where schedule_name=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.hasSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listAllScheduleNames() throws GroupManagerDb.Error {
        ArrayList<String> list = new ArrayList<String>();
        try (PreparedStatement statement = this.database_.prepareStatement("SELECT schedule_name FROM schedules");){
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                list.add(result.getString(1));
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.listAllScheduleNames: SQLite error: " + exception);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schedule getSchedule(String name) throws GroupManagerDb.Error {
        try {
            Schedule schedule;
            block8: {
                PreparedStatement statement = this.database_.prepareStatement("SELECT schedule FROM schedules WHERE schedule_name=?");
                statement.setString(1, name);
                schedule = new Schedule();
                try {
                    ResultSet result = statement.executeQuery();
                    if (result.next()) {
                        try {
                            schedule.wireDecode(new Blob(result.getBytes(1), false));
                            break block8;
                        }
                        catch (EncodingException ex) {
                            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getSchedule: Error decoding schedule: " + ex);
                        }
                    }
                    throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getSchedule: Cannot get the result from the database");
                }
                finally {
                    statement.close();
                }
            }
            return schedule;
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getScheduleMembers(String name) throws GroupManagerDb.Error {
        HashMap<Name, Blob> map = new HashMap<Name, Blob>();
        try {
            statement.setString(1, name);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key_name, pubkey FROM members JOIN schedules ON members.schedule_id=schedules.schedule_id WHERE schedule_name=?");){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    Name keyName = new Name();
                    try {
                        keyName.wireDecode(new Blob(result.getBytes(1), false), (WireFormat)TlvWireFormat.get());
                    }
                    catch (EncodingException ex) {
                        throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getScheduleMembers: Error decoding name: " + ex);
                    }
                    map.put(keyName, new Blob(result.getBytes(2), false));
                }
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getScheduleMembers: SQLite error: " + exception);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchedule(String name, Schedule schedule) throws GroupManagerDb.Error {
        Sqlite3GroupManagerDb.checkAddSchedule(name);
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO schedules (schedule_name, schedule) values (?, ?)");
            statement.setString(1, name);
            statement.setBytes(2, schedule.wireEncode().getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.addSchedule: SQLite error: " + exception);
        }
    }

    @Override
    public void deleteSchedule(String name) throws GroupManagerDb.Error {
        try {
            statement.setString(1, name);
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM schedules WHERE schedule_name=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.deleteSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSchedule(String oldName, String newName) throws GroupManagerDb.Error {
        Sqlite3GroupManagerDb.checkRenameSchedule(newName);
        try {
            PreparedStatement statement = this.database_.prepareStatement("UPDATE schedules SET schedule_name=? WHERE schedule_name=?");
            statement.setString(1, newName);
            statement.setString(2, oldName);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.renameSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSchedule(String name, Schedule schedule) throws GroupManagerDb.Error {
        if (!this.hasSchedule(name)) {
            this.addSchedule(name, schedule);
            return;
        }
        try {
            PreparedStatement statement = this.database_.prepareStatement("UPDATE schedules SET schedule=? WHERE schedule_name=?");
            statement.setBytes(1, schedule.wireEncode().getImmutableArray());
            statement.setString(2, name);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.updateSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasMember(Name identity) throws GroupManagerDb.Error {
        try {
            statement.setBytes(1, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT member_id FROM members WHERE member_name=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.hasMember: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listAllMembers() throws GroupManagerDb.Error {
        ArrayList<Name> list = new ArrayList<Name>();
        try (PreparedStatement statement = this.database_.prepareStatement("SELECT member_name FROM members");){
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Name identity = new Name();
                try {
                    identity.wireDecode(new Blob(result.getBytes(1), false), (WireFormat)TlvWireFormat.get());
                }
                catch (EncodingException ex) {
                    throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.listAllMembers: Error decoding name: " + ex);
                }
                list.add(identity);
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.listAllMembers: SQLite error: " + exception);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMemberSchedule(Name identity) throws GroupManagerDb.Error {
        try {
            statement.setBytes(1, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT schedule_name FROM schedules JOIN members ON schedules.schedule_id = members.schedule_id WHERE member_name=?");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getMemberSchedule: Cannot get the result from the database");
                String string = result.getString(1);
                return string;
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getMemberSchedule: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMember(String scheduleName, Name keyName, Blob key) throws GroupManagerDb.Error {
        int scheduleId = this.getScheduleId(scheduleName);
        if (scheduleId == -1) {
            throw new GroupManagerDb.Error("The schedule does not exist");
        }
        Name memberName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO members(schedule_id, member_name, key_name, pubkey) values (?, ?, ?, ?)");
            statement.setInt(1, scheduleId);
            statement.setBytes(2, memberName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            statement.setBytes(3, keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            statement.setBytes(4, key.getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.addMember: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMemberSchedule(Name identity, String scheduleName) throws GroupManagerDb.Error {
        int scheduleId = this.getScheduleId(scheduleName);
        if (scheduleId == -1) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.updateMemberSchedule: The schedule does not exist");
        }
        try {
            PreparedStatement statement = this.database_.prepareStatement("UPDATE members SET schedule_id=? WHERE member_name=?");
            statement.setInt(1, scheduleId);
            statement.setBytes(2, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.updateMemberSchedule: SQLite error: " + exception);
        }
    }

    @Override
    public void deleteMember(Name identity) throws GroupManagerDb.Error {
        try {
            statement.setBytes(1, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM members WHERE member_name=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.deleteMember: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getScheduleId(String name) throws GroupManagerDb.Error {
        try {
            statement.setString(1, name);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT schedule_id FROM schedules WHERE schedule_name=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    int n = result.getInt(1);
                    return n;
                }
                int n = -1;
                return n;
            }
        }
        catch (SQLException exception) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.getScheduleId: SQLite error: " + exception);
        }
    }
}

