/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding.tlv;

import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.tlv.TlvDecoder;

public class TlvStructureDecoder {
    private static int READ_TYPE = 0;
    private static int READ_TYPE_BYTES = 1;
    private static int READ_LENGTH = 2;
    private static int READ_LENGTH_BYTES = 3;
    private static int READ_VALUE_BYTES = 4;
    private boolean gotElementEnd_ = false;
    private int offset_ = 0;
    private int state_ = READ_TYPE;
    private boolean useHeaderBuffer_ = false;
    private ByteBuffer headerBuffer_ = ByteBuffer.allocate(8);
    private int nBytesToRead_ = 0;
    private int firstOctet_;

    public final boolean findElementEnd(ByteBuffer input) throws EncodingException {
        int nRemainingBytes;
        if (this.gotElementEnd_) {
            return true;
        }
        TlvDecoder decoder = new TlvDecoder(input);
        while (true) {
            int firstOctet;
            if (this.offset_ >= input.limit()) {
                return false;
            }
            if (this.state_ == READ_TYPE) {
                firstOctet = input.get(this.offset_) & 0xFF;
                ++this.offset_;
                if (firstOctet < 253) {
                    this.state_ = READ_LENGTH;
                    continue;
                }
                this.nBytesToRead_ = firstOctet == 253 ? 2 : (firstOctet == 254 ? 4 : 8);
                this.state_ = READ_TYPE_BYTES;
                continue;
            }
            if (this.state_ == READ_TYPE_BYTES) {
                nRemainingBytes = input.limit() - this.offset_;
                if (nRemainingBytes < this.nBytesToRead_) {
                    this.offset_ += nRemainingBytes;
                    this.nBytesToRead_ -= nRemainingBytes;
                    return false;
                }
                this.offset_ += this.nBytesToRead_;
                this.state_ = READ_LENGTH;
                continue;
            }
            if (this.state_ == READ_LENGTH) {
                firstOctet = input.get(this.offset_) & 0xFF;
                ++this.offset_;
                if (firstOctet < 253) {
                    this.nBytesToRead_ = firstOctet;
                    if (this.nBytesToRead_ == 0) {
                        this.gotElementEnd_ = true;
                        return true;
                    }
                    this.state_ = READ_VALUE_BYTES;
                    continue;
                }
                this.nBytesToRead_ = firstOctet == 253 ? 2 : (firstOctet == 254 ? 4 : 8);
                this.firstOctet_ = firstOctet;
                this.state_ = READ_LENGTH_BYTES;
                continue;
            }
            if (this.state_ != READ_LENGTH_BYTES) break;
            nRemainingBytes = input.limit() - this.offset_;
            if (!this.useHeaderBuffer_ && nRemainingBytes >= this.nBytesToRead_) {
                decoder.seek(this.offset_);
                this.nBytesToRead_ = decoder.readExtendedVarNumber(this.firstOctet_);
                this.offset_ = decoder.getOffset();
            } else {
                this.useHeaderBuffer_ = true;
                int nNeededBytes = this.nBytesToRead_ - this.headerBuffer_.position();
                if (nNeededBytes > nRemainingBytes) {
                    if (this.headerBuffer_.position() + nRemainingBytes > this.headerBuffer_.limit()) {
                        throw new Error("Cannot store more header bytes than the size of headerBuffer");
                    }
                    ByteBuffer remainingInput = input.duplicate();
                    remainingInput.position(this.offset_);
                    this.headerBuffer_.put(remainingInput);
                    this.offset_ += nRemainingBytes;
                    return false;
                }
                if (this.headerBuffer_.position() + nNeededBytes > this.headerBuffer_.limit()) {
                    throw new Error("Cannot store more header bytes than the size of headerBuffer");
                }
                ByteBuffer remainingLengthBytes = input.duplicate();
                remainingLengthBytes.position(this.offset_);
                remainingLengthBytes.limit(this.offset_ + nNeededBytes);
                this.headerBuffer_.put(remainingLengthBytes);
                this.offset_ += nNeededBytes;
                this.headerBuffer_.flip();
                TlvDecoder bufferDecoder = new TlvDecoder(this.headerBuffer_);
                this.nBytesToRead_ = bufferDecoder.readExtendedVarNumber(this.firstOctet_);
            }
            if (this.nBytesToRead_ == 0) {
                this.gotElementEnd_ = true;
                return true;
            }
            this.state_ = READ_VALUE_BYTES;
        }
        if (this.state_ == READ_VALUE_BYTES) {
            nRemainingBytes = input.limit() - this.offset_;
            if (nRemainingBytes < this.nBytesToRead_) {
                this.offset_ += nRemainingBytes;
                this.nBytesToRead_ -= nRemainingBytes;
                return false;
            }
            this.offset_ += this.nBytesToRead_;
            this.gotElementEnd_ = true;
            return true;
        }
        throw new Error("findElementEnd: unrecognized state");
    }

    public final int getOffset() {
        return this.offset_;
    }

    public final void seek(int offset) {
        this.offset_ = offset;
    }
}

