/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.transport.Transport;

public class ThreadPoolFace
extends Face {
    private final ScheduledExecutorService threadPool_;
    private static final Logger logger_ = Logger.getLogger(ThreadPoolFace.class.getName());

    public ThreadPoolFace(ScheduledExecutorService threadPool, Transport transport, Transport.ConnectionInfo connectionInfo) {
        super(transport, connectionInfo);
        this.threadPool_ = threadPool;
    }

    @Override
    public long expressInterest(final Interest interest, OnData onData, OnTimeout onTimeout, final WireFormat wireFormat) throws IOException {
        final long pendingInterestId = this.node_.getNextEntryId();
        final OnData finalOnData = onData;
        final OnData onDataSubmit = new OnData(){

            @Override
            public void onData(final Interest localInterest, final Data data) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnData.onData(localInterest, data);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onData", ex);
                        }
                    }
                });
            }
        };
        final OnTimeout finalOnTimeout = onTimeout;
        final OnTimeout onTimeoutSubmit = onTimeout == null ? null : new OnTimeout(){

            @Override
            public void onTimeout(final Interest localInterest) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finalOnTimeout.onTimeout(localInterest);
                        }
                        catch (Throwable ex) {
                            logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                        }
                    }
                });
            }
        };
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.expressInterest(pendingInterestId, interest, onDataSubmit, onTimeoutSubmit, wireFormat, ThreadPoolFace.this);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        });
        return pendingInterestId;
    }

    @Override
    public void callLater(double delayMilliseconds, final Runnable callback) {
        this.threadPool_.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.run();
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }
}

