/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.ControlParameters;
import net.named_data.jndn.ControlResponse;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.LocalControlHeader;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnRegisterSuccess;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.ElementListener;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.impl.DelayedCallTable;
import net.named_data.jndn.impl.InterestFilterTable;
import net.named_data.jndn.impl.PendingInterestTable;
import net.named_data.jndn.impl.RegisteredPrefixTable;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.transport.Transport;
import net.named_data.jndn.util.CommandInterestGenerator;
import net.named_data.jndn.util.SignedBlob;

public class Node
implements ElementListener {
    private final Transport transport_;
    private final Transport.ConnectionInfo connectionInfo_;
    private final PendingInterestTable pendingInterestTable_ = new PendingInterestTable();
    private final InterestFilterTable interestFilterTable_ = new InterestFilterTable();
    private final RegisteredPrefixTable registeredPrefixTable_ = new RegisteredPrefixTable(this.interestFilterTable_);
    private final DelayedCallTable delayedCallTable_ = new DelayedCallTable();
    private final List onConnectedCallbacks_ = Collections.synchronizedList(new ArrayList());
    private final CommandInterestGenerator commandInterestGenerator_ = new CommandInterestGenerator();
    private final Name timeoutPrefix_ = new Name("/local/timeout");
    private long lastEntryId_;
    private final Object lastEntryIdLock_ = new Object();
    private ConnectStatus connectStatus_ = ConnectStatus.UNCONNECTED;
    private static final Logger logger_ = Logger.getLogger(Node.class.getName());

    public Node(Transport transport, Transport.ConnectionInfo connectionInfo) {
        this.transport_ = transport;
        this.connectionInfo_ = connectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expressInterest(final long pendingInterestId, Interest interest, final OnData onData, final OnTimeout onTimeout, final WireFormat wireFormat, final Face face) throws IOException {
        final Interest interestCopy = new Interest(interest);
        if (this.connectStatus_ == ConnectStatus.CONNECT_COMPLETE) {
            this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
            return;
        }
        List list = this.onConnectedCallbacks_;
        synchronized (list) {
            if (!this.transport_.isAsync()) {
                this.transport_.connect(this.connectionInfo_, this, null);
                this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                this.connectStatus_ = ConnectStatus.CONNECT_COMPLETE;
                return;
            }
            if (this.connectStatus_ == ConnectStatus.UNCONNECTED) {
                this.connectStatus_ = ConnectStatus.CONNECT_REQUESTED;
                this.onConnectedCallbacks_.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Node.this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                        }
                        catch (IOException ex) {
                            logger_.log(Level.SEVERE, null, ex);
                        }
                    }
                });
                Runnable onConnected = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = Node.this.onConnectedCallbacks_;
                        synchronized (list) {
                            for (int i = 0; i < Node.this.onConnectedCallbacks_.size(); ++i) {
                                ((Runnable)Node.this.onConnectedCallbacks_.get(i)).run();
                            }
                            Node.this.onConnectedCallbacks_.clear();
                            Node.this.connectStatus_ = ConnectStatus.CONNECT_COMPLETE;
                        }
                    }
                };
                this.transport_.connect(this.connectionInfo_, this, onConnected);
            } else if (this.connectStatus_ == ConnectStatus.CONNECT_REQUESTED) {
                this.onConnectedCallbacks_.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Node.this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                        }
                        catch (IOException ex) {
                            logger_.log(Level.SEVERE, null, ex);
                        }
                    }
                });
            } else if (this.connectStatus_ == ConnectStatus.CONNECT_COMPLETE) {
                this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
            } else {
                throw new Error("Node: Unrecognized _connectStatus " + (Object)((Object)this.connectStatus_));
            }
        }
    }

    public final void removePendingInterest(long pendingInterestId) {
        this.pendingInterestTable_.removePendingInterest(pendingInterestId);
    }

    void makeCommandInterest(Interest interest, KeyChain keyChain, Name certificateName, WireFormat wireFormat) throws SecurityException {
        this.commandInterestGenerator_.generate(interest, keyChain, certificateName, wireFormat);
    }

    public final void registerPrefix(long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, WireFormat wireFormat, KeyChain commandKeyChain, Name commandCertificateName, Face face) throws IOException, SecurityException {
        this.nfdRegisterPrefix(registeredPrefixId, new Name(prefix), onInterest, onRegisterFailed, onRegisterSuccess, flags, commandKeyChain, commandCertificateName, wireFormat, face);
    }

    public final void removeRegisteredPrefix(long registeredPrefixId) {
        this.registeredPrefixTable_.removeRegisteredPrefix(registeredPrefixId);
    }

    public final void setInterestFilter(long interestFilterId, InterestFilter filter, OnInterestCallback onInterest, Face face) {
        this.interestFilterTable_.setInterestFilter(interestFilterId, new InterestFilter(filter), onInterest, face);
    }

    public final void unsetInterestFilter(long interestFilterId) {
        this.interestFilterTable_.unsetInterestFilter(interestFilterId);
    }

    public final void putData(Data data, WireFormat wireFormat) throws IOException {
        SignedBlob encoding = data.wireEncode(wireFormat);
        if (encoding.size() > Node.getMaxNdnPacketSize()) {
            throw new Error("The encoded Data packet size exceeds the maximum limit getMaxNdnPacketSize()");
        }
        this.transport_.send(encoding.buf());
    }

    public final void send(ByteBuffer encoding) throws IOException {
        if (encoding.remaining() > Node.getMaxNdnPacketSize()) {
            throw new Error("The encoded packet size exceeds the maximum limit getMaxNdnPacketSize()");
        }
        this.transport_.send(encoding);
    }

    public final void processEvents() throws IOException, EncodingException {
        this.transport_.processEvents();
        this.delayedCallTable_.callTimedOut();
    }

    public final Transport getTransport() {
        return this.transport_;
    }

    public final Transport.ConnectionInfo getConnectionInfo() {
        return this.connectionInfo_;
    }

    @Override
    public final void onReceivedElement(ByteBuffer element) throws EncodingException {
        block14: {
            Data data;
            block13: {
                LocalControlHeader localControlHeader = null;
                if (element.get(0) == 80) {
                    localControlHeader = new LocalControlHeader();
                    localControlHeader.wireDecode(element, (WireFormat)TlvWireFormat.get());
                    element = localControlHeader.getPayloadWireEncoding().buf();
                }
                Interest interest = null;
                data = null;
                if (element.get(0) == 5 || element.get(0) == 6) {
                    TlvDecoder decoder = new TlvDecoder(element);
                    if (decoder.peekType(5, element.remaining())) {
                        interest = new Interest();
                        interest.wireDecode(element, (WireFormat)TlvWireFormat.get());
                        if (localControlHeader != null) {
                            interest.setLocalControlHeader(localControlHeader);
                        }
                    } else if (decoder.peekType(6, element.remaining())) {
                        data = new Data();
                        data.wireDecode(element, (WireFormat)TlvWireFormat.get());
                        if (localControlHeader != null) {
                            data.setLocalControlHeader(localControlHeader);
                        }
                    }
                }
                if (interest == null) break block13;
                ArrayList matchedFilters = new ArrayList();
                this.interestFilterTable_.getMatchedFilters(interest, matchedFilters);
                for (int i = 0; i < matchedFilters.size(); ++i) {
                    InterestFilterTable.Entry entry = (InterestFilterTable.Entry)matchedFilters.get(i);
                    try {
                        entry.getOnInterest().onInterest(entry.getFilter().getPrefix(), interest, entry.getFace(), entry.getInterestFilterId(), entry.getFilter());
                        continue;
                    }
                    catch (Throwable ex) {
                        logger_.log(Level.SEVERE, "Error in onInterest", ex);
                    }
                }
                break block14;
            }
            if (data == null) break block14;
            ArrayList pitEntries = new ArrayList();
            this.pendingInterestTable_.extractEntriesForExpressedInterest(data.getName(), pitEntries);
            for (int i = 0; i < pitEntries.size(); ++i) {
                PendingInterestTable.Entry pendingInterest = (PendingInterestTable.Entry)pitEntries.get(i);
                try {
                    pendingInterest.getOnData().onData(pendingInterest.getInterest(), data);
                    continue;
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onData", ex);
                }
            }
        }
    }

    public final boolean isLocal() throws IOException {
        return this.transport_.isLocal(this.connectionInfo_);
    }

    public final void shutdown() {
        try {
            this.transport_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getMaxNdnPacketSize() {
        return 8800;
    }

    public final void callLater(double delayMilliseconds, Runnable callback) {
        this.delayedCallTable_.callLater(delayMilliseconds, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextEntryId() {
        Object object = this.lastEntryIdLock_;
        synchronized (object) {
            return ++this.lastEntryId_;
        }
    }

    private void processInterestTimeout(PendingInterestTable.Entry pendingInterest) {
        if (this.pendingInterestTable_.removeEntry(pendingInterest)) {
            pendingInterest.callTimeout();
        }
    }

    private void expressInterestHelper(long pendingInterestId, Interest interestCopy, OnData onData, OnTimeout onTimeout, WireFormat wireFormat, Face face) throws IOException {
        final PendingInterestTable.Entry pendingInterest = this.pendingInterestTable_.add(pendingInterestId, interestCopy, onData, onTimeout);
        if (onTimeout != null || interestCopy.getInterestLifetimeMilliseconds() >= 0.0) {
            double delayMilliseconds = interestCopy.getInterestLifetimeMilliseconds();
            if (delayMilliseconds < 0.0) {
                delayMilliseconds = 4000.0;
            }
            face.callLater(delayMilliseconds, new Runnable(){

                @Override
                public void run() {
                    Node.this.processInterestTimeout(pendingInterest);
                }
            });
        }
        if (!this.timeoutPrefix_.match(interestCopy.getName())) {
            SignedBlob encoding = interestCopy.wireEncode(wireFormat);
            if (encoding.size() > Node.getMaxNdnPacketSize()) {
                throw new Error("The encoded interest size exceeds the maximum limit getMaxNdnPacketSize()");
            }
            this.transport_.send(encoding.buf());
        }
    }

    private void nfdRegisterPrefix(long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, KeyChain commandKeyChain, Name commandCertificateName, WireFormat wireFormat, Face face) throws SecurityException {
        boolean faceIsLocal;
        if (commandKeyChain == null) {
            throw new Error("registerPrefix: The command KeyChain has not been set. You must call setCommandSigningInfo.");
        }
        if (commandCertificateName.size() == 0) {
            throw new Error("registerPrefix: The command certificate name has not been set. You must call setCommandSigningInfo.");
        }
        ControlParameters controlParameters = new ControlParameters();
        controlParameters.setName(prefix);
        controlParameters.setForwardingFlags(flags);
        Interest commandInterest = new Interest();
        try {
            faceIsLocal = this.isLocal();
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "Register prefix failed: Error attempting to determine if the face is local: {0}", ex);
            try {
                onRegisterFailed.onRegisterFailed(prefix);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onRegisterFailed", exception);
            }
            return;
        }
        if (faceIsLocal) {
            commandInterest.setName(new Name("/localhost/nfd/rib/register"));
            commandInterest.setInterestLifetimeMilliseconds(2000.0);
        } else {
            commandInterest.setName(new Name("/localhop/nfd/rib/register"));
            commandInterest.setInterestLifetimeMilliseconds(4000.0);
        }
        commandInterest.getName().append(controlParameters.wireEncode(TlvWireFormat.get()));
        this.makeCommandInterest(commandInterest, commandKeyChain, commandCertificateName, TlvWireFormat.get());
        if (registeredPrefixId != 0L) {
            long interestFilterId = 0L;
            if (onInterest != null) {
                interestFilterId = this.getNextEntryId();
                this.setInterestFilter(interestFilterId, new InterestFilter(prefix), onInterest, face);
            }
            this.registeredPrefixTable_.add(registeredPrefixId, prefix, interestFilterId);
        }
        RegisterResponse response = new RegisterResponse(new RegisterResponse.Info(prefix, onRegisterFailed, onRegisterSuccess, registeredPrefixId));
        try {
            this.expressInterest(this.getNextEntryId(), commandInterest, response, response, wireFormat, face);
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "Register prefix failed: Error sending the register prefix interest to the forwarder: {0}", ex);
            try {
                onRegisterFailed.onRegisterFailed(prefix);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onRegisterFailed", exception);
            }
        }
    }

    private static class RegisterResponse
    implements OnData,
    OnTimeout {
        private final Info info_;

        public RegisterResponse(Info info) {
            this.info_ = info;
        }

        @Override
        public void onData(Interest interest, Data responseData) {
            ControlResponse controlResponse = new ControlResponse();
            try {
                controlResponse.wireDecode(responseData.getContent(), (WireFormat)TlvWireFormat.get());
            }
            catch (EncodingException ex) {
                logger_.log(Level.INFO, "Register prefix failed: Error decoding the NFD response: {0}", ex);
                try {
                    this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onRegisterFailed", exception);
                }
                return;
            }
            if (controlResponse.getStatusCode() != 200) {
                logger_.log(Level.INFO, "Register prefix failed: Expected NFD status code 200, got: {0}", controlResponse.getStatusCode());
                try {
                    this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onRegisterFailed", ex);
                }
                return;
            }
            logger_.log(Level.INFO, "Register prefix succeeded with the NFD forwarder for prefix {0}", this.info_.prefix_.toUri());
            if (this.info_.onRegisterSuccess_ != null) {
                try {
                    this.info_.onRegisterSuccess_.onRegisterSuccess(this.info_.prefix_, this.info_.registeredPrefixId_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onRegisterSuccess", ex);
                }
            }
        }

        @Override
        public void onTimeout(Interest timedOutInterest) {
            logger_.log(Level.INFO, "Timeout for NFD register prefix command.");
            try {
                this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onRegisterFailed", ex);
            }
        }

        public static class Info {
            public final Name prefix_;
            public final OnRegisterFailed onRegisterFailed_;
            public final OnRegisterSuccess onRegisterSuccess_;
            public final long registeredPrefixId_;

            public Info(Name prefix, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, long registeredPrefixId) {
                this.prefix_ = prefix;
                this.onRegisterFailed_ = onRegisterFailed;
                this.onRegisterSuccess_ = onRegisterSuccess;
                this.registeredPrefixId_ = registeredPrefixId;
            }
        }
    }

    private static enum ConnectStatus {
        UNCONNECTED,
        CONNECT_REQUESTED,
        CONNECT_COMPLETE;

    }
}

