/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.LocalControlHeader;
import net.named_data.jndn.MetaInfo;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.SignatureHolder;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;
import net.named_data.jndn.util.ChangeCounter;
import net.named_data.jndn.util.SignedBlob;

public class Data
implements ChangeCountable,
SignatureHolder {
    private final ChangeCounter signature_ = new ChangeCounter(new Sha256WithRsaSignature());
    private final ChangeCounter name_ = new ChangeCounter(new Name());
    private final ChangeCounter metaInfo_ = new ChangeCounter(new MetaInfo());
    private Blob content_ = new Blob();
    private LocalControlHeader localControlHeader_ = new LocalControlHeader();
    private SignedBlob defaultWireEncoding_ = new SignedBlob();
    private WireFormat defaultWireEncodingFormat_;
    private long getDefaultWireEncodingChangeCount_ = 0L;
    private long changeCount_ = 0L;

    public Data() {
    }

    public Data(Name name) {
        this.name_.set(new Name(name));
    }

    public Data(Data data) {
        try {
            this.signature_.set(data.signature_ == null ? new Sha256WithRsaSignature() : (Signature)data.getSignature().clone());
        }
        catch (CloneNotSupportedException e) {
            throw new NullPointerException("Data.setSignature: unexpected exception in clone(): " + e.getMessage());
        }
        this.name_.set(new Name(data.getName()));
        this.metaInfo_.set(new MetaInfo(data.getMetaInfo()));
        this.content_ = data.content_;
        this.setDefaultWireEncoding(data.defaultWireEncoding_, null);
    }

    public final SignedBlob wireEncode(WireFormat wireFormat) {
        if (!this.getDefaultWireEncoding().isNull() && this.getDefaultWireEncodingFormat() == wireFormat) {
            return this.getDefaultWireEncoding();
        }
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        Blob encoding = wireFormat.encodeData(this, signedPortionBeginOffset, signedPortionEndOffset);
        SignedBlob wireEncoding = new SignedBlob(encoding, signedPortionBeginOffset[0], signedPortionEndOffset[0]);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(wireEncoding, WireFormat.getDefaultWireFormat());
        }
        return wireEncoding;
    }

    public final SignedBlob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        wireFormat.decodeData(this, input.buf(), signedPortionBeginOffset, signedPortionEndOffset);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(new SignedBlob(input, signedPortionBeginOffset[0], signedPortionEndOffset[0]), WireFormat.getDefaultWireFormat());
        } else {
            this.setDefaultWireEncoding(new SignedBlob(), null);
        }
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        this.wireDecode(new Blob(input, true), wireFormat);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    @Override
    public final Signature getSignature() {
        return (Signature)this.signature_.get();
    }

    public final Name getName() {
        return (Name)this.name_.get();
    }

    public final MetaInfo getMetaInfo() {
        return (MetaInfo)this.metaInfo_.get();
    }

    public final Blob getContent() {
        return this.content_;
    }

    public final long getIncomingFaceId() {
        return this.localControlHeader_.getIncomingFaceId();
    }

    public final SignedBlob getDefaultWireEncoding() {
        if (this.getDefaultWireEncodingChangeCount_ != this.getChangeCount()) {
            this.defaultWireEncoding_ = new SignedBlob();
            this.defaultWireEncodingFormat_ = null;
            this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
        }
        return this.defaultWireEncoding_;
    }

    WireFormat getDefaultWireEncodingFormat() {
        return this.defaultWireEncodingFormat_;
    }

    @Override
    public final Data setSignature(Signature signature) {
        try {
            this.signature_.set(signature == null ? new Sha256WithRsaSignature() : (Signature)signature.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new NullPointerException("Data.setSignature: unexpected exception in clone(): " + e.getMessage());
        }
        ++this.changeCount_;
        return this;
    }

    public Data setName(Name name) {
        this.name_.set(name == null ? new Name() : new Name(name));
        ++this.changeCount_;
        return this;
    }

    public final Data setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo_.set(metaInfo == null ? new MetaInfo() : new MetaInfo(metaInfo));
        ++this.changeCount_;
        return this;
    }

    public final Data setContent(Blob content) {
        this.content_ = content == null ? new Blob() : content;
        ++this.changeCount_;
        return this;
    }

    final Data setLocalControlHeader(LocalControlHeader localControlHeader) {
        this.localControlHeader_ = localControlHeader == null ? new LocalControlHeader() : new LocalControlHeader(localControlHeader);
        return this;
    }

    @Override
    public final long getChangeCount() {
        boolean changed = this.signature_.checkChanged();
        changed = this.name_.checkChanged() || changed;
        boolean bl = changed = this.metaInfo_.checkChanged() || changed;
        if (changed) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }

    private void setDefaultWireEncoding(SignedBlob defaultWireEncoding, WireFormat defaultWireEncodingFormat) {
        this.defaultWireEncoding_ = defaultWireEncoding;
        this.defaultWireEncodingFormat_ = defaultWireEncodingFormat;
        this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
    }
}

