/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.ControlParameters;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class ControlResponse {
    private int statusCode_ = -1;
    private String statusText_ = "";
    private ControlParameters bodyAsControlParameters_ = null;

    public ControlResponse() {
    }

    public ControlResponse(ControlResponse controlResponse) {
        this.statusCode_ = controlResponse.statusCode_;
        this.statusText_ = controlResponse.statusText_;
        this.bodyAsControlParameters_ = controlResponse.bodyAsControlParameters_ == null ? null : new ControlParameters(controlResponse.bodyAsControlParameters_);
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeControlResponse(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeControlResponse(this, input);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        this.wireDecode(input.buf(), wireFormat);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }

    public final int getStatusCode() {
        return this.statusCode_;
    }

    public final String getStatusText() {
        return this.statusText_;
    }

    public final ControlParameters getBodyAsControlParameters() {
        return this.bodyAsControlParameters_;
    }

    public final ControlResponse setStatusCode(int statusCode) {
        this.statusCode_ = statusCode;
        return this;
    }

    public final ControlResponse setStatusText(String statusText) {
        this.statusText_ = statusText == null ? "" : statusText;
        return this;
    }

    public final ControlResponse setBodyAsControlParameters(ControlParameters controlParameters) {
        this.bodyAsControlParameters_ = controlParameters == null ? null : new ControlParameters(controlParameters);
        return this;
    }
}

