/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import java.util.regex.Pattern;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexBackrefMatcher;
import net.named_data.jndn.util.regex.NdnRegexComponentSetMatcher;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;

public class NdnRegexRepeatMatcher
extends NdnRegexMatcherBase {
    private final int indicator_;
    private int repeatMin_ = 0;
    private int repeatMax_ = 0;

    public NdnRegexRepeatMatcher(String expr, NdnRegexBackrefManager backrefManager, int indicator) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.REPEAT_PATTERN, backrefManager);
        this.indicator_ = indicator;
        this.compile();
    }

    @Override
    public boolean match(Name name, int offset, int len) throws NdnRegexMatcherBase.Error {
        this.matchResult_.clear();
        if (0 == this.repeatMin_ && 0 == len) {
            return true;
        }
        if (this.recursiveMatch(0, name, offset, len)) {
            for (int i = offset; i < offset + len; ++i) {
                this.matchResult_.add(name.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        NdnRegexMatcherBase matcher;
        if ('(' == this.expr_.charAt(0)) {
            matcher = new NdnRegexBackrefMatcher(this.expr_.substring(0, this.indicator_), this.backrefManager_);
            this.backrefManager_.pushRef(matcher);
            ((NdnRegexBackrefMatcher)matcher).lateCompile();
        } else {
            matcher = new NdnRegexComponentSetMatcher(this.expr_.substring(0, this.indicator_), this.backrefManager_);
        }
        this.matchers_.add(matcher);
        this.parseRepetition();
    }

    private boolean parseRepetition() throws NdnRegexMatcherBase.Error {
        int exprSize = this.expr_.length();
        int MAX_REPETITIONS = Short.MAX_VALUE;
        if (exprSize == this.indicator_) {
            this.repeatMin_ = 1;
            this.repeatMax_ = 1;
            return true;
        }
        if (exprSize == this.indicator_ + 1) {
            if ('?' == this.expr_.charAt(this.indicator_)) {
                this.repeatMin_ = 0;
                this.repeatMax_ = 1;
                return true;
            }
            if ('+' == this.expr_.charAt(this.indicator_)) {
                this.repeatMin_ = 1;
                this.repeatMax_ = Short.MAX_VALUE;
                return true;
            }
            if ('*' == this.expr_.charAt(this.indicator_)) {
                this.repeatMin_ = 0;
                this.repeatMax_ = Short.MAX_VALUE;
                return true;
            }
        } else {
            String repeatStruct = this.expr_.substring(this.indicator_, exprSize);
            int rsSize = repeatStruct.length();
            int min = 0;
            int max = 0;
            if (Pattern.matches("\\{[0-9]+,[0-9]+\\}", repeatStruct)) {
                int separator = repeatStruct.indexOf(44);
                min = Integer.parseInt(repeatStruct.substring(1, separator));
                max = Integer.parseInt(repeatStruct.substring(separator + 1, rsSize - 1));
            } else if (Pattern.matches("\\{,[0-9]+\\}", repeatStruct)) {
                int separator = repeatStruct.indexOf(44);
                min = 0;
                max = Integer.parseInt(repeatStruct.substring(separator + 1, rsSize - 1));
            } else if (Pattern.matches("\\{[0-9]+,\\}", repeatStruct)) {
                int separator = repeatStruct.indexOf(44);
                min = Integer.parseInt(repeatStruct.substring(1, separator));
                max = Short.MAX_VALUE;
            } else if (Pattern.matches("\\{[0-9]+\\}", repeatStruct)) {
                max = min = Integer.parseInt(repeatStruct.substring(1, rsSize - 1));
            } else {
                throw new NdnRegexMatcherBase.Error("Error: RegexRepeatMatcher.ParseRepetition(): Unrecognized format " + this.expr_);
            }
            if (min > Short.MAX_VALUE || max > Short.MAX_VALUE || min > max) {
                throw new NdnRegexMatcherBase.Error("Error: RegexRepeatMatcher.ParseRepetition(): Wrong number " + this.expr_);
            }
            this.repeatMin_ = min;
            this.repeatMax_ = max;
            return true;
        }
        return false;
    }

    private boolean recursiveMatch(int repeat, Name name, int offset, int len) throws NdnRegexMatcherBase.Error {
        NdnRegexMatcherBase matcher = (NdnRegexMatcherBase)this.matchers_.get(0);
        if (0 < len && repeat >= this.repeatMax_) {
            return false;
        }
        if (0 == len && repeat < this.repeatMin_) {
            return false;
        }
        if (0 == len && repeat >= this.repeatMin_) {
            return true;
        }
        for (int tried = len; tried >= 0; --tried) {
            if (!matcher.match(name, offset, tried) || !this.recursiveMatch(repeat + 1, name, offset + tried, len - tried)) continue;
            return true;
        }
        return false;
    }
}

