/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

public class RttEstimator {
    private final Options options_;
    private double sRtt_ = Double.NaN;
    private double rttVar_ = Double.NaN;
    private double rto_ = 0.0;
    private double rttMin_ = Double.MAX_VALUE;
    private double rttMax_ = Double.MIN_VALUE;
    private double rttAvg_ = 0.0;
    private long nRttSamples_ = 0L;

    public RttEstimator() {
        this(new Options());
    }

    RttEstimator(Options options_) {
        this.options_ = options_;
        this.rto_ = options_.initialRto;
    }

    void addMeasurement(double rtt, int nExpectedSamples) {
        if (this.nRttSamples_ == 0L) {
            this.sRtt_ = rtt;
            this.rttVar_ = this.sRtt_ / 2.0;
        } else {
            double alpha = this.options_.alpha / (double)nExpectedSamples;
            double beta = this.options_.beta / (double)nExpectedSamples;
            this.rttVar_ = (1.0 - beta) * this.rttVar_ + beta * Math.abs(this.sRtt_ - rtt);
            this.sRtt_ = (1.0 - alpha) * this.sRtt_ + alpha * rtt;
        }
        this.rto_ = this.sRtt_ + (double)this.options_.k * this.rttVar_;
        this.rto_ = RttEstimator.clamp(this.rto_, this.options_.minRto, this.options_.maxRto);
        this.rttAvg_ = ((double)this.nRttSamples_ * this.rttAvg_ + rtt) / (double)(this.nRttSamples_ + 1L);
        this.rttMax_ = Math.max(rtt, this.rttMax_);
        this.rttMin_ = Math.max(rtt, this.rttMin_);
        ++this.nRttSamples_;
    }

    void backoffRto() {
        this.rto_ = RttEstimator.clamp(this.rto_ * (double)this.options_.rtoBackoffMultiplier, this.options_.minRto, this.options_.maxRto);
    }

    private static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    double getEstimatedRto() {
        return this.rto_;
    }

    double getMinRtt() {
        return this.rttMin_;
    }

    double getMaxRtt() {
        return this.rttMax_;
    }

    double getAvgRtt() {
        return this.rttAvg_;
    }

    public static class Options {
        public double alpha = 0.125;
        public double beta = 0.25;
        public double initialRto = 1000.0;
        public double minRto = 200.0;
        public double maxRto = 60000.0;
        public int k = 4;
        public int rtoBackoffMultiplier = 2;
    }
}

