/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync.detail;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.in_memory_storage.InMemoryStorageRetaining;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class PSyncSegmentPublisher {
    public static final int MAX_SEGMENTS_STORED = 100;
    private final Face face_;
    private final KeyChain keyChain_;
    private final InMemoryStorageRetaining storage_;

    public PSyncSegmentPublisher(Face face, KeyChain keyChain, int inMemoryStorageLimit) {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.storage_ = new InMemoryStorageRetaining();
    }

    public PSyncSegmentPublisher(Face face, KeyChain keyChain) {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.storage_ = new InMemoryStorageRetaining();
    }

    public final void publish(Name interestName, Name dataName, Blob content, double freshnessPeriod, SigningInfo signingInfo) throws EncodingException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error, IOException {
        long interestSegment = 0L;
        if (interestName.get(-1).isSegment()) {
            interestSegment = interestName.get(-1).toSegment();
        }
        ByteBuffer rawBuffer = content.buf().slice();
        int iSegmentBegin = 0;
        int iEnd = content.size();
        int maxPacketSize = 4400;
        long totalSegments = content.size() / maxPacketSize;
        Name.Component finalBlockId = Name.Component.fromSegment(totalSegments);
        Name segmentPrefix = new Name(dataName);
        segmentPrefix.appendVersion((long)Common.getNowMilliseconds());
        long segmentNo = 0L;
        do {
            int iSegmentEnd;
            if ((iSegmentEnd = iSegmentBegin + maxPacketSize) > iEnd) {
                iSegmentEnd = iEnd;
            }
            final Name segmentName = new Name(segmentPrefix);
            segmentName.appendSegment(segmentNo);
            Data data = new Data(segmentName);
            rawBuffer.limit(iSegmentEnd);
            rawBuffer.position(iSegmentBegin);
            data.setContent(new Blob(rawBuffer, true));
            data.getMetaInfo().setFreshnessPeriod(freshnessPeriod);
            data.getMetaInfo().setFinalBlockId(finalBlockId);
            iSegmentBegin = iSegmentEnd;
            this.keyChain_.sign(data, signingInfo);
            if (interestSegment == segmentNo) {
                this.face_.putData(data);
            }
            this.storage_.insert(data);
            this.face_.callLater(freshnessPeriod, new Runnable(){

                @Override
                public void run() {
                    PSyncSegmentPublisher.this.storage_.remove(segmentName);
                }
            });
            ++segmentNo;
        } while (iSegmentBegin < iEnd);
    }

    public final void publish(Name interestName, Name dataName, Blob content, double freshnessPeriod) throws EncodingException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error, IOException {
        this.publish(interestName, dataName, content, freshnessPeriod, new SigningInfo());
    }

    public final boolean replyFromStore(Name interestName) throws IOException {
        Data data = this.storage_.find(new Interest(interestName));
        if (data != null) {
            this.face_.putData(data);
            return true;
        }
        return false;
    }
}

