/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Face;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.sync.FullPSync2017;
import net.named_data.jndn.sync.PSyncMissingDataInfo;
import net.named_data.jndn.sync.detail.PSyncUserPrefixes;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class FullPSync2017WithUsers
implements FullPSync2017.OnNamesUpdate,
FullPSync2017.CanAddToSyncData,
FullPSync2017.CanAddReceivedName {
    private final OnUpdate onUpdate_;
    private final FullPSync2017 fullPSync_;
    private final PSyncUserPrefixes prefixes_ = new PSyncUserPrefixes();
    private static final Logger logger_ = Logger.getLogger(FullPSync2017WithUsers.class.getName());

    public FullPSync2017WithUsers(int expectedNEntries, Face face, Name syncPrefix, Name userPrefix, OnUpdate onUpdate, KeyChain keyChain, double syncInterestLifetime, double syncReplyFreshnessPeriod, SigningInfo signingInfo) throws IOException, SecurityException {
        this.onUpdate_ = onUpdate;
        this.fullPSync_ = new FullPSync2017(expectedNEntries, face, syncPrefix, this, keyChain, syncInterestLifetime, syncReplyFreshnessPeriod, signingInfo, this, this);
        if (userPrefix != null && userPrefix.size() > 0) {
            this.addUserNode(userPrefix);
        }
    }

    public FullPSync2017WithUsers(int expectedNEntries, Face face, Name syncPrefix, Name userPrefix, OnUpdate onUpdate, KeyChain keyChain, double syncInterestLifetime, double syncReplyFreshnessPeriod) throws IOException, SecurityException {
        this.onUpdate_ = onUpdate;
        this.fullPSync_ = new FullPSync2017(expectedNEntries, face, syncPrefix, this, keyChain, syncInterestLifetime, syncReplyFreshnessPeriod, new SigningInfo(), this, this);
        if (userPrefix != null && userPrefix.size() > 0) {
            this.addUserNode(userPrefix);
        }
    }

    public FullPSync2017WithUsers(int expectedNEntries, Face face, Name syncPrefix, Name userPrefix, OnUpdate onUpdate, KeyChain keyChain) throws IOException, SecurityException {
        this.onUpdate_ = onUpdate;
        this.fullPSync_ = new FullPSync2017(expectedNEntries, face, syncPrefix, this, keyChain, 1000.0, 1000.0, new SigningInfo(), this, this);
        if (userPrefix != null && userPrefix.size() > 0) {
            this.addUserNode(userPrefix);
        }
    }

    public final int getSequenceNo(Name prefix) {
        return this.prefixes_.getSequenceNo(prefix);
    }

    public final boolean addUserNode(Name prefix) {
        return this.prefixes_.addUserNode(prefix);
    }

    public final void removeUserNode(Name prefix) {
        if (this.prefixes_.isUserNode(prefix)) {
            int sequenceNo = (Integer)this.prefixes_.prefixes_.get(prefix);
            this.prefixes_.removeUserNode(prefix);
            this.fullPSync_.removeName(new Name(prefix).appendNumber(sequenceNo));
        }
    }

    public final void publishName(Name prefix, int sequenceNo) {
        if (!this.prefixes_.isUserNode(prefix)) {
            logger_.log(Level.WARNING, "Prefix not added: {0}" + prefix);
            return;
        }
        int newSequenceNo = sequenceNo >= 0 ? sequenceNo : this.prefixes_.getSequenceNoOrZero(prefix) + 1;
        logger_.log(Level.INFO, "Publish: " + prefix.toUri() + "/" + newSequenceNo);
        if (this.updateSequenceNo(prefix, newSequenceNo)) {
            this.fullPSync_.publishName(new Name(prefix).appendNumber(newSequenceNo));
        }
    }

    public final void publishName(Name prefix) {
        this.publishName(prefix, -1);
    }

    @Override
    public final boolean canAddReceivedName(Name name) {
        Name prefix = name.getPrefix(-1);
        long sequenceNo = name.get(-1).toNumber();
        boolean havePrefix = this.prefixes_.isUserNode(prefix);
        if (!havePrefix || (long)((Integer)this.prefixes_.prefixes_.get(prefix)).intValue() < sequenceNo) {
            int oldSequenceNo;
            if (havePrefix && (oldSequenceNo = this.prefixes_.getSequenceNoOrZero(prefix)) != 0) {
                this.fullPSync_.removeName(new Name(prefix).appendNumber(oldSequenceNo));
            }
            return true;
        }
        return false;
    }

    @Override
    public final void onNamesUpdate(ArrayList<Name> names) {
        ArrayList<PSyncMissingDataInfo> updates = new ArrayList<PSyncMissingDataInfo>();
        for (Name name : names) {
            Name prefix = name.getPrefix(-1);
            long sequenceNo = name.get(-1).toNumber();
            updates.add(new PSyncMissingDataInfo(prefix, this.prefixes_.getSequenceNoOrZero(prefix) + 1, (int)sequenceNo));
            this.prefixes_.prefixes_.put(prefix, (int)sequenceNo);
        }
        try {
            this.onUpdate_.onUpdate(updates);
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in onUpdate", ex);
        }
    }

    @Override
    public final boolean canAddToSyncData(Name name, HashSet<Long> negative) {
        Name prefix = name.getPrefix(-1);
        String uri = new Name(prefix).appendNumber(this.prefixes_.getSequenceNoOrZero(prefix) + 1).toUri();
        long nextHash = Common.murmurHash3(11, new Blob(uri).getImmutableArray());
        for (Long negativeHash : negative) {
            if (negativeHash != nextHash) continue;
            return false;
        }
        return true;
    }

    private boolean updateSequenceNo(Name prefix, int sequenceNo) {
        int[] oldSequenceNo = new int[1];
        if (!this.prefixes_.updateSequenceNo(prefix, sequenceNo, oldSequenceNo)) {
            return false;
        }
        if (oldSequenceNo[0] != 0) {
            this.fullPSync_.removeName(new Name(prefix).appendNumber(oldSequenceNo[0]));
        }
        return true;
    }

    public static interface OnUpdate {
        public void onUpdate(ArrayList<PSyncMissingDataInfo> var1);
    }
}

