/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.sync.PSyncProducerBase;
import net.named_data.jndn.sync.detail.InvertibleBloomLookupTable;
import net.named_data.jndn.sync.detail.PSyncSegmentPublisher;
import net.named_data.jndn.sync.detail.PSyncState;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.SegmentFetcher;

public class FullPSync2017
extends PSyncProducerBase
implements SegmentFetcher.OnError {
    public static final double DEFAULT_SYNC_INTEREST_LIFETIME = 1000.0;
    public static final double DEFAULT_SYNC_REPLY_FRESHNESS_PERIOD = 1000.0;
    private Face face_;
    private KeyChain keyChain_;
    private SigningInfo signingInfo_;
    private PSyncSegmentPublisher segmentPublisher_;
    private final HashMap<Name, PendingEntryInfoFull> pendingEntries_ = new HashMap();
    private double syncInterestLifetime_;
    private OnNamesUpdate onNamesUpdate_;
    private CanAddToSyncData canAddToSyncData_;
    private CanAddReceivedName canAddReceivedName_;
    private Name outstandingInterestName_ = new Name();
    private long registeredPrefix_;
    private static final Random random_ = new Random();
    private static final Logger logger_ = Logger.getLogger(FullPSync2017.class.getName());

    public FullPSync2017(int expectedNEntries, Face face, Name syncPrefix, OnNamesUpdate onNamesUpdate, KeyChain keyChain, double syncInterestLifetime, double syncReplyFreshnessPeriod, SigningInfo signingInfo, CanAddToSyncData canAddToSyncData, CanAddReceivedName canAddReceivedName) throws IOException, SecurityException {
        super(expectedNEntries, syncPrefix, syncReplyFreshnessPeriod);
        this.construct(face, onNamesUpdate, keyChain, syncInterestLifetime, signingInfo, canAddToSyncData, canAddReceivedName);
    }

    public FullPSync2017(int expectedNEntries, Face face, Name syncPrefix, OnNamesUpdate onNamesUpdate, KeyChain keyChain, double syncInterestLifetime, double syncReplyFreshnessPeriod, SigningInfo signingInfo) throws IOException, SecurityException {
        super(expectedNEntries, syncPrefix, syncReplyFreshnessPeriod);
        this.construct(face, onNamesUpdate, keyChain, syncInterestLifetime, signingInfo, null, null);
    }

    public FullPSync2017(int expectedNEntries, Face face, Name syncPrefix, OnNamesUpdate onNamesUpdate, KeyChain keyChain, double syncInterestLifetime, double syncReplyFreshnessPeriod) throws IOException, SecurityException {
        super(expectedNEntries, syncPrefix, syncReplyFreshnessPeriod);
        this.construct(face, onNamesUpdate, keyChain, syncInterestLifetime, new SigningInfo(), null, null);
    }

    public FullPSync2017(int expectedNEntries, Face face, Name syncPrefix, OnNamesUpdate onNamesUpdate, KeyChain keyChain) throws IOException, SecurityException {
        super(expectedNEntries, syncPrefix, 1000.0);
        this.construct(face, onNamesUpdate, keyChain, 1000.0, new SigningInfo(), null, null);
    }

    private void construct(Face face, OnNamesUpdate onNamesUpdate, KeyChain keyChain, double syncInterestLifetime, SigningInfo signingInfo, CanAddToSyncData canAddToSyncData, CanAddReceivedName canAddReceivedName) throws IOException, SecurityException {
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.syncInterestLifetime_ = syncInterestLifetime;
        this.signingInfo_ = new SigningInfo(signingInfo);
        this.onNamesUpdate_ = onNamesUpdate;
        this.canAddToSyncData_ = canAddToSyncData;
        this.canAddReceivedName_ = canAddReceivedName;
        this.segmentPublisher_ = new PSyncSegmentPublisher(this.face_, this.keyChain_);
        this.registeredPrefix_ = this.face_.registerPrefix(this.syncPrefix_, new OnInterestCallback(){

            @Override
            public void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
                FullPSync2017.this.onSyncInterest(prefix, interest, face, interestFilterId, filter);
            }
        }, new OnRegisterFailed(){

            @Override
            public void onRegisterFailed(Name prefix) {
                PSyncProducerBase.onRegisterFailed(prefix);
            }
        });
        this.sendSyncInterest();
    }

    public final void publishName(Name name) {
        if (this.nameToHash_.containsKey(name)) {
            logger_.log(Level.FINE, "Already published, ignoring: {0}", name);
            return;
        }
        logger_.log(Level.INFO, "Publish: {0}", name);
        this.insertIntoIblt(name);
        this.satisfyPendingInterests();
    }

    void removeName(Name name) {
        this.removeFromIblt(name);
    }

    private void sendSyncInterest() {
        Blob encodedIblt;
        Name syncInterestName = new Name(this.syncPrefix_);
        try {
            encodedIblt = this.iblt_.encode();
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "sendSyncInterest: Error in IBLT encode", ex);
            return;
        }
        syncInterestName.append(encodedIblt);
        this.outstandingInterestName_ = syncInterestName;
        double random1 = random_.nextDouble();
        double jitter = (random1 - 0.5) * (this.syncInterestLifetime_ * 0.2);
        this.face_.callLater(this.syncInterestLifetime_ / 2.0 + jitter, new Runnable(){

            @Override
            public void run() {
                FullPSync2017.this.sendSyncInterest();
            }
        });
        final Interest syncInterest = new Interest(syncInterestName);
        syncInterest.setInterestLifetimeMilliseconds(this.syncInterestLifetime_);
        syncInterest.setNonce(new Blob(new byte[4], false));
        syncInterest.refreshNonce();
        SegmentFetcher.fetch(this.face_, syncInterest, SegmentFetcher.DontVerifySegment, new SegmentFetcher.OnComplete(){

            @Override
            public void onComplete(Blob content) {
                FullPSync2017.this.onSyncData(content, syncInterest);
            }
        }, (SegmentFetcher.OnError)this);
        logger_.log(Level.FINE, "sendFullSyncInterest, nonce: " + syncInterest.getNonce().toHex() + ", hash: " + syncInterestName.hashCode());
    }

    private void onSyncInterest(Name prefixName, final Interest interest, Face face, long interestFilterId, InterestFilter filter) {
        Name interestName;
        try {
            if (this.segmentPublisher_.replyFromStore(interest.getName())) {
                return;
            }
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "onSyncInterest: Error in replyFromStore", ex);
            return;
        }
        Name nameWithoutSyncPrefix = interest.getName().getSubName(prefixName.size());
        if (nameWithoutSyncPrefix.size() == 1) {
            interestName = interest.getName();
        } else if (nameWithoutSyncPrefix.size() == 3) {
            interestName = interest.getName().getPrefix(-2);
        } else {
            return;
        }
        Name.Component ibltName = interestName.get(-1);
        logger_.log(Level.FINE, "Full Sync Interest received, nonce: " + interest.getNonce().toHex() + ", hash:" + interestName.hashCode());
        InvertibleBloomLookupTable iblt = new InvertibleBloomLookupTable(new InvertibleBloomLookupTable(this.expectedNEntries_));
        try {
            iblt.initialize(ibltName.getValue());
        }
        catch (Exception ex) {
            logger_.log(Level.INFO, "onSyncInterest: Error in IBLT decode", ex);
            return;
        }
        InvertibleBloomLookupTable difference = this.iblt_.difference(iblt);
        HashSet<Long> positive = new HashSet<Long>();
        HashSet<Long> negative = new HashSet<Long>();
        if (!difference.listEntries(positive, negative)) {
            logger_.log(Level.INFO, "Cannot decode differences, positive: " + positive.size() + " negative: " + negative.size() + " threshold: " + this.threshold_);
            if (positive.size() + negative.size() >= this.threshold_ || positive.size() == 0 && negative.size() == 0) {
                PSyncState state1 = new PSyncState();
                for (Name name : this.nameToHash_.keySet()) {
                    state1.addContent(name);
                }
                if (state1.getContent().size() > 0) {
                    try {
                        this.segmentPublisher_.publish(interest.getName(), interest.getName(), state1.wireEncode(), this.syncReplyFreshnessPeriod_, this.signingInfo_);
                    }
                    catch (Exception ex) {
                        logger_.log(Level.INFO, "onSyncInterest: Error in publish", ex);
                        return;
                    }
                }
                return;
            }
        }
        PSyncState state = new PSyncState();
        for (Long hash : positive) {
            Name name = (Name)this.hashToName_.get(hash);
            if (!this.nameToHash_.containsKey(name) || this.canAddToSyncData_ != null && !this.canAddToSyncData_.canAddToSyncData(name, negative)) continue;
            state.addContent(name);
        }
        if (state.getContent().size() > 0) {
            logger_.log(Level.FINE, "Sending sync content: " + state);
            try {
                this.sendSyncData(interestName, state.wireEncode());
            }
            catch (Exception ex) {
                logger_.log(Level.INFO, "onSyncInterest: Error in sendSyncData", ex);
            }
            return;
        }
        final PendingEntryInfoFull entry = new PendingEntryInfoFull(iblt);
        this.pendingEntries_.put(interestName, entry);
        this.face_.callLater(interest.getInterestLifetimeMilliseconds(), new Runnable(){

            @Override
            public void run() {
                FullPSync2017.this.delayedRemovePendingEntry(interest.getName(), entry, interest.getNonce());
            }
        });
    }

    @Override
    public final void onError(SegmentFetcher.ErrorCode errorCode, String message) {
        logger_.log(Level.INFO, "Cannot fetch sync data, error: " + (Object)((Object)errorCode) + " message: " + message);
    }

    private void sendSyncData(Name name, Blob content) throws IOException, EncodingException, TpmBackEnd.Error, PibImpl.Error, KeyChain.Error {
        logger_.log(Level.FINE, "Checking if the Data will satisfy our own pending interest");
        Name nameWithIblt = new Name();
        nameWithIblt.append(this.iblt_.encode());
        Name dataName = new Name(name).appendNumber(nameWithIblt.hashCode());
        if (this.outstandingInterestName_.equals(name)) {
            logger_.log(Level.FINE, "Satisfies our own pending Interest");
            this.outstandingInterestName_ = new Name();
            logger_.log(Level.FINE, "Sending sync Data");
            this.segmentPublisher_.publish(name, dataName, content, this.syncReplyFreshnessPeriod_, this.signingInfo_);
            logger_.log(Level.FINE, "sendSyncData: Renewing sync interest");
            this.sendSyncInterest();
        } else {
            logger_.log(Level.FINE, "Sending Sync Data for not our own Interest");
            this.segmentPublisher_.publish(name, dataName, content, this.syncReplyFreshnessPeriod_, this.signingInfo_);
        }
    }

    private void onSyncData(Blob encodedContent, Interest interest) {
        PSyncState state;
        this.deletePendingInterests(interest.getName());
        try {
            state = new PSyncState(encodedContent);
        }
        catch (EncodingException ex) {
            logger_.log(Level.INFO, "onSyncData: Error in PSyncState decode", ex);
            return;
        }
        ArrayList<Name> names = new ArrayList<Name>();
        logger_.log(Level.INFO, "Sync Data Received: {0}", state);
        ArrayList<Name> content = state.getContent();
        for (Name contentName : content) {
            if (this.nameToHash_.containsKey(contentName)) continue;
            logger_.log(Level.FINE, "Checking whether to add {0}", contentName);
            if (this.canAddReceivedName_ != null && !this.canAddReceivedName_.canAddReceivedName(contentName)) continue;
            logger_.log(Level.FINE, "Adding name {0}", contentName);
            names.add(contentName);
            this.insertIntoIblt(contentName);
        }
        if (names.size() > 0) {
            try {
                this.onNamesUpdate_.onNamesUpdate(names);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onNamesUpdate", ex);
            }
            logger_.log(Level.FINE, "onSyncData: Renewing sync interest");
            this.sendSyncInterest();
        } else {
            logger_.log(Level.FINE, "No new update, interest nonce: " + interest.getNonce().toHex() + " , hash: " + interest.getName().hashCode());
        }
    }

    private void satisfyPendingInterests() {
        logger_.log(Level.FINE, "Satisfying full sync Interest: " + this.pendingEntries_.size());
        HashSet<Name> keys = new HashSet<Name>();
        for (Name key : this.pendingEntries_.keySet()) {
            keys.add(key);
        }
        for (Name keyName : keys) {
            HashSet<Long> negative;
            HashSet<Long> positive;
            PendingEntryInfoFull pendingEntry = this.pendingEntries_.get(keyName);
            InvertibleBloomLookupTable entryIblt = pendingEntry.iblt_;
            InvertibleBloomLookupTable difference = this.iblt_.difference(entryIblt);
            if (!difference.listEntries(positive = new HashSet<Long>(), negative = new HashSet<Long>())) {
                logger_.log(Level.INFO, "Decode failed for pending interest");
                if (positive.size() + negative.size() >= this.threshold_ || positive.size() == 0 && negative.size() == 0) {
                    logger_.log(Level.INFO, "positive + negative > threshold or no difference can be found. Erase pending interest.");
                    pendingEntry.isRemoved_ = true;
                    this.pendingEntries_.remove(keyName);
                    continue;
                }
            }
            PSyncState state = new PSyncState();
            for (Long hash : positive) {
                Name name = (Name)this.hashToName_.get(hash);
                if (!this.nameToHash_.containsKey(name)) continue;
                state.addContent(name);
            }
            if (state.getContent().size() <= 0) continue;
            logger_.log(Level.FINE, "Satisfying sync content: {0}", state);
            try {
                this.sendSyncData(keyName, state.wireEncode());
            }
            catch (Exception ex) {
                logger_.log(Level.INFO, "satisfyPendingInterests: Error in sendSyncData", ex);
            }
            pendingEntry.isRemoved_ = true;
            this.pendingEntries_.remove(keyName);
        }
    }

    private void deletePendingInterests(Name interestName) {
        PendingEntryInfoFull entry = this.pendingEntries_.get(interestName);
        if (entry == null) {
            return;
        }
        logger_.log(Level.INFO, "Delete pending interest: {0}", interestName);
        entry.isRemoved_ = true;
        this.pendingEntries_.remove(interestName);
    }

    private void delayedRemovePendingEntry(Name name, PendingEntryInfoFull entry, Blob nonce) {
        if (entry.isRemoved_) {
            return;
        }
        logger_.log(Level.FINE, "Remove Pending Interest {0}", nonce.toHex());
        entry.isRemoved_ = true;
        this.pendingEntries_.remove(name);
    }

    public class PendingEntryInfoFull {
        public final InvertibleBloomLookupTable iblt_;
        public boolean isRemoved_ = false;

        public PendingEntryInfoFull(InvertibleBloomLookupTable iblt) {
            this.iblt_ = iblt;
        }
    }

    public static interface CanAddReceivedName {
        public boolean canAddReceivedName(Name var1);
    }

    public static interface CanAddToSyncData {
        public boolean canAddToSyncData(Name var1, HashSet<Long> var2);
    }

    public static interface OnNamesUpdate {
        public void onNamesUpdate(ArrayList<Name> var1);
    }
}

