/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.HashMap;
import java.util.TreeMap;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.v2.CertificateContainerInterface;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.DynamicTrustAnchorGroup;
import net.named_data.jndn.security.v2.StaticTrustAnchorGroup;
import net.named_data.jndn.security.v2.TrustAnchorGroup;
import net.named_data.jndn.util.Common;

public class TrustAnchorContainer {
    private final HashMap<String, TrustAnchorGroup> groups_ = new HashMap();
    private final AnchorContainer anchors_ = new AnchorContainer();
    private static Common dummyCommon_ = new Common();

    public final void insert(String groupId, CertificateV2 certificate) throws Error {
        TrustAnchorGroup group = this.groups_.get(groupId);
        if (group == null) {
            group = new StaticTrustAnchorGroup(this.anchors_, groupId);
            this.groups_.put(groupId, group);
        }
        if (!(group instanceof StaticTrustAnchorGroup)) {
            throw new Error("Cannot add a static anchor to the non-static anchor group " + groupId);
        }
        ((StaticTrustAnchorGroup)group).add(certificate);
    }

    public final void insert(String groupId, String path, double refreshPeriod, boolean isDirectory) throws Error {
        if (this.groups_.containsKey(groupId)) {
            throw new Error("Cannot create the dynamic group, because group " + groupId + " already exists");
        }
        this.groups_.put(groupId, new DynamicTrustAnchorGroup(this.anchors_, groupId, path, refreshPeriod, isDirectory));
    }

    public final void insert(String groupId, String path, double refreshPeriod) throws Error {
        this.insert(groupId, path, refreshPeriod, false);
    }

    public final void clear() {
        this.groups_.clear();
        this.anchors_.clear();
    }

    public final CertificateV2 find(Name keyName) {
        this.refresh();
        Name nameKey = this.anchors_.anchorsByName_.ceilingKey(keyName);
        if (nameKey == null) {
            return null;
        }
        CertificateV2 certificate = (CertificateV2)this.anchors_.anchorsByName_.get(nameKey);
        if (!keyName.isPrefixOf(certificate.getName())) {
            return null;
        }
        return certificate;
    }

    public final CertificateV2 find(Interest interest) {
        this.refresh();
        Name firstKey = this.anchors_.anchorsByName_.ceilingKey(interest.getName());
        if (firstKey == null) {
            return null;
        }
        for (Object e : this.anchors_.anchorsByName_.navigableKeySet().tailSet(firstKey)) {
            CertificateV2 certificate = (CertificateV2)this.anchors_.anchorsByName_.get((Name)e);
            if (!interest.getName().isPrefixOf(certificate.getName())) break;
            if (!interest.matchesData(certificate)) continue;
            return certificate;
        }
        return null;
    }

    public final TrustAnchorGroup getGroup(String groupId) throws Error {
        TrustAnchorGroup group = this.groups_.get(groupId);
        if (group == null) {
            throw new Error("Trust anchor group " + groupId + " does not exist");
        }
        return group;
    }

    public final int size() {
        return this.anchors_.size();
    }

    private void refresh() {
        for (TrustAnchorGroup group : this.groups_.values()) {
            group.refresh();
        }
    }

    private static class AnchorContainer
    extends CertificateContainerInterface {
        public final TreeMap anchorsByName_ = new TreeMap();

        private AnchorContainer() {
        }

        @Override
        public void add(CertificateV2 certificate) {
            CertificateV2 certificateCopy;
            try {
                certificateCopy = new CertificateV2(certificate);
            }
            catch (CertificateV2.Error ex) {
                throw new java.lang.Error("Error in CertificateV2 copy constructor: " + ex);
            }
            this.anchorsByName_.put(certificateCopy.getName(), certificateCopy);
        }

        @Override
        public void remove(Name certificateName) {
            this.anchorsByName_.remove(certificateName);
        }

        void clear() {
            this.anchorsByName_.clear();
        }

        int size() {
            return this.anchorsByName_.size();
        }
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

