/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.nio.ByteBuffer;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.util.Blob;

public class EncryptedContent {
    private EncryptAlgorithmType algorithmType_ = EncryptAlgorithmType.NONE;
    private KeyLocator keyLocator_ = new KeyLocator();
    private Blob initialVector_ = new Blob();
    private Blob payload_ = new Blob();
    private Blob payloadKey_ = new Blob();

    public EncryptedContent() {
    }

    public EncryptedContent(EncryptedContent encryptedContent) {
        this.algorithmType_ = encryptedContent.algorithmType_;
        this.keyLocator_ = new KeyLocator(encryptedContent.keyLocator_);
        this.initialVector_ = encryptedContent.initialVector_;
        this.payload_ = encryptedContent.payload_;
    }

    public final EncryptAlgorithmType getAlgorithmType() {
        return this.algorithmType_;
    }

    public final KeyLocator getKeyLocator() {
        return this.keyLocator_;
    }

    public final Name getKeyLocatorName() {
        if (this.keyLocator_.getType() != KeyLocatorType.KEYNAME) {
            throw new Error("getKeyLocatorName: The KeyLocator type must be KEYNAME");
        }
        return this.keyLocator_.getKeyName();
    }

    public final boolean hasInitialVector() {
        return !this.initialVector_.isNull();
    }

    public final Blob getInitialVector() {
        return this.initialVector_;
    }

    public final Blob getPayload() {
        return this.payload_;
    }

    public final Blob getPayloadKey() {
        return this.payloadKey_;
    }

    public final EncryptedContent setAlgorithmType(EncryptAlgorithmType algorithmType) {
        this.algorithmType_ = algorithmType;
        return this;
    }

    public final EncryptedContent setKeyLocator(KeyLocator keyLocator) {
        this.keyLocator_ = keyLocator == null ? new KeyLocator() : new KeyLocator(keyLocator);
        return this;
    }

    public final EncryptedContent setKeyLocatorName(Name keyName) {
        this.keyLocator_.setType(KeyLocatorType.KEYNAME);
        this.keyLocator_.setKeyName(keyName);
        return this;
    }

    public final EncryptedContent setInitialVector(Blob initialVector) {
        this.initialVector_ = initialVector == null ? new Blob() : initialVector;
        return this;
    }

    public final EncryptedContent setPayload(Blob payload) {
        this.payload_ = payload == null ? new Blob() : payload;
        return this;
    }

    public final EncryptedContent setPayloadKey(Blob payloadKey) {
        this.payloadKey_ = payloadKey == null ? new Blob() : payloadKey;
        return this;
    }

    public final void clear() {
        this.algorithmType_ = EncryptAlgorithmType.NONE;
        this.keyLocator_ = new KeyLocator();
        this.initialVector_ = new Blob();
        this.payload_ = new Blob();
        this.payloadKey_ = new Blob();
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeEncryptedContent(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final Blob wireEncodeV2(WireFormat wireFormat) {
        return wireFormat.encodeEncryptedContentV2(this);
    }

    public final Blob wireEncodeV2() {
        return this.wireEncodeV2(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeEncryptedContent(this, input, true);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeEncryptedContent(this, input.buf(), false);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecodeV2(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeEncryptedContentV2(this, input, true);
    }

    public final void wireDecodeV2(ByteBuffer input) throws EncodingException {
        this.wireDecodeV2(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecodeV2(Blob input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeEncryptedContentV2(this, input.buf(), false);
    }

    public final void wireDecodeV2(Blob input) throws EncodingException {
        this.wireDecodeV2(input, WireFormat.getDefaultWireFormat());
    }
}

