/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import java.util.Random;
import net.named_data.jndn.Interest;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.Tlv0_3WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;

public class Tlv0_2WireFormat
extends Tlv0_3WireFormat {
    private static final Random random_ = new Random();
    private static Tlv0_2WireFormat instance_ = new Tlv0_2WireFormat();

    @Override
    public Blob encodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        ByteBuffer nonce;
        if (!interest.getDidSetCanBePrefix_() && !didCanBePrefixWarning_) {
            System.out.println("WARNING: The default CanBePrefix will change. See Interest.setDefaultCanBePrefix() for details.");
            didCanBePrefixWarning_ = true;
        }
        if (interest.hasApplicationParameters()) {
            return Tlv0_2WireFormat.encodeInterestV03(interest, signedPortionBeginOffset, signedPortionEndOffset);
        }
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        if (interest.getForwardingHint().size() > 0) {
            if (interest.getSelectedDelegationIndex() >= 0) {
                throw new Error("An Interest may not have a selected delegation when encoding a forwarding hint");
            }
            if (interest.hasLink()) {
                throw new Error("An Interest may not have a link object when encoding a forwarding hint");
            }
            int forwardingHintSaveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeDelegationSet(interest.getForwardingHint(), encoder);
            encoder.writeTypeAndLength(30, encoder.getLength() - forwardingHintSaveLength);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(32, interest.getSelectedDelegationIndex());
        try {
            Blob linkWireEncoding = interest.getLinkWireEncoding(this);
            if (!linkWireEncoding.isNull()) {
                encoder.writeBuffer(linkWireEncoding.buf());
            }
        }
        catch (EncodingException ex) {
            throw new Error(ex.getMessage());
        }
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(12, interest.getInterestLifetimeMilliseconds());
        if (interest.getNonce().size() == 0) {
            nonce = ByteBuffer.allocate(4);
            random_.nextBytes(nonce.array());
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() < 4) {
            nonce = ByteBuffer.allocate(4);
            nonce.put(interest.getNonce().buf());
            for (int i = 0; i < 4 - interest.getNonce().size(); ++i) {
                nonce.put((byte)random_.nextInt());
            }
            nonce.flip();
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() == 4) {
            encoder.writeBlobTlv(10, interest.getNonce().buf());
        } else {
            nonce = interest.getNonce().buf();
            nonce.limit(nonce.position() + 4);
            encoder.writeBlobTlv(10, nonce);
        }
        Tlv0_2WireFormat.encodeSelectors(interest, encoder);
        int[] tempSignedPortionBeginOffset = new int[1];
        int[] tempSignedPortionEndOffset = new int[1];
        Tlv0_2WireFormat.encodeName(interest.getName(), tempSignedPortionBeginOffset, tempSignedPortionEndOffset, encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength() - tempSignedPortionBeginOffset[0];
        int signedPortionEndOffsetFromBack = encoder.getLength() - tempSignedPortionEndOffset[0];
        encoder.writeTypeAndLength(5, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    public static Tlv0_2WireFormat get() {
        return instance_;
    }
}

