/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.Node;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnRegisterSuccess;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.RegistrationOptions;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.transport.TcpTransport;
import net.named_data.jndn.transport.Transport;
import net.named_data.jndn.util.Blob;

public class Face {
    protected final Node node_;
    protected KeyChain commandKeyChain_ = null;
    protected Name commandCertificateName_ = new Name();

    public Face(Transport transport, Transport.ConnectionInfo connectionInfo) {
        this.node_ = new Node(transport, connectionInfo);
    }

    public Face(String host, int port) {
        this.node_ = new Node(new TcpTransport(), new TcpTransport.ConnectionInfo(host, port));
    }

    public Face(String host) {
        this.node_ = new Node(new TcpTransport(), new TcpTransport.ConnectionInfo(host, 6363));
    }

    public Face() {
        this.node_ = new Node(new TcpTransport(), new TcpTransport.ConnectionInfo("localhost", 6363));
    }

    public final void setInterestLoopbackEnabled(boolean interestLoopbackEnabled) {
        this.node_.setInterestLoopbackEnabled(interestLoopbackEnabled);
    }

    public long expressInterest(Interest interest, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack, WireFormat wireFormat) throws IOException {
        long pendingInterestId = this.node_.getNextEntryId();
        this.node_.expressInterest(pendingInterestId, interest, onData, onTimeout, onNetworkNack, wireFormat, this);
        return pendingInterestId;
    }

    public long expressInterest(Interest interest, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack) throws IOException {
        return this.expressInterest(interest, onData, onTimeout, onNetworkNack, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Interest interest, OnData onData, OnTimeout onTimeout, WireFormat wireFormat) throws IOException {
        return this.expressInterest(interest, onData, onTimeout, null, wireFormat);
    }

    public long expressInterest(Interest interest, OnData onData, OnTimeout onTimeout) throws IOException {
        return this.expressInterest(interest, onData, onTimeout, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Interest interest, OnData onData, WireFormat wireFormat) throws IOException {
        return this.expressInterest(interest, onData, null, wireFormat);
    }

    public long expressInterest(Interest interest, OnData onData) throws IOException {
        return this.expressInterest(interest, onData, null, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack, WireFormat wireFormat) throws IOException {
        long pendingInterestId = this.node_.getNextEntryId();
        this.node_.expressInterest(pendingInterestId, Face.getInterestCopy(name, interestTemplate), onData, onTimeout, onNetworkNack, wireFormat, this);
        return pendingInterestId;
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack) throws IOException {
        return this.expressInterest(name, interestTemplate, onData, onTimeout, onNetworkNack, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack, WireFormat wireFormat) throws IOException {
        return this.expressInterest(name, null, onData, onTimeout, onNetworkNack, wireFormat);
    }

    public long expressInterest(Name name, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack) throws IOException {
        return this.expressInterest(name, null, onData, onTimeout, onNetworkNack, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData, OnTimeout onTimeout, WireFormat wireFormat) throws IOException {
        return this.expressInterest(name, interestTemplate, onData, onTimeout, null, wireFormat);
    }

    public long expressInterest(Name name, OnData onData, OnTimeout onTimeout, WireFormat wireFormat) throws IOException {
        return this.expressInterest(name, null, onData, onTimeout, wireFormat);
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData, WireFormat wireFormat) throws IOException {
        return this.expressInterest(name, interestTemplate, onData, null, wireFormat);
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData, OnTimeout onTimeout) throws IOException {
        return this.expressInterest(name, interestTemplate, onData, onTimeout, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, Interest interestTemplate, OnData onData) throws IOException {
        return this.expressInterest(name, interestTemplate, onData, null, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, OnData onData, OnTimeout onTimeout) throws IOException {
        return this.expressInterest(name, null, onData, onTimeout, WireFormat.getDefaultWireFormat());
    }

    public long expressInterest(Name name, OnData onData, WireFormat wireFormat) throws IOException {
        return this.expressInterest(name, null, onData, null, wireFormat);
    }

    public long expressInterest(Name name, OnData onData) throws IOException {
        return this.expressInterest(name, null, onData, null, WireFormat.getDefaultWireFormat());
    }

    public void removePendingInterest(long pendingInterestId) {
        this.node_.removePendingInterest(pendingInterestId);
    }

    public void setCommandSigningInfo(KeyChain keyChain, Name certificateName) {
        this.commandKeyChain_ = keyChain;
        this.commandCertificateName_ = new Name(certificateName);
    }

    public void setCommandCertificateName(Name certificateName) {
        this.commandCertificateName_ = new Name(certificateName);
    }

    public void makeCommandInterest(Interest interest, WireFormat wireFormat) throws SecurityException {
        this.node_.makeCommandInterest(interest, this.commandKeyChain_, this.commandCertificateName_, wireFormat);
    }

    public void makeCommandInterest(Interest interest) throws SecurityException {
        this.makeCommandInterest(interest, WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, RegistrationOptions registrationOptions, WireFormat wireFormat) throws IOException, SecurityException {
        long registeredPrefixId = this.node_.getNextEntryId();
        this.node_.registerPrefix(registeredPrefixId, prefix, onInterest, onRegisterFailed, onRegisterSuccess, registrationOptions, wireFormat, this.commandKeyChain_, this.commandCertificateName_, this);
        return registeredPrefixId;
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterSuccess onRegisterSuccess, OnRegisterFailed onRegisterFailed, RegistrationOptions registrationOptions, WireFormat wireFormat) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, registrationOptions, wireFormat);
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, RegistrationOptions registrationOptions) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, registrationOptions, WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterSuccess onRegisterSuccess, OnRegisterFailed onRegisterFailed, RegistrationOptions registrationOptions) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, registrationOptions, WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, WireFormat wireFormat) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, new RegistrationOptions(), wireFormat);
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterSuccess onRegisterSuccess, OnRegisterFailed onRegisterFailed, WireFormat wireFormat) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, new RegistrationOptions(), wireFormat);
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, new RegistrationOptions(), WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterSuccess onRegisterSuccess, OnRegisterFailed onRegisterFailed) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, onRegisterSuccess, new RegistrationOptions(), WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, RegistrationOptions registrationOptions, WireFormat wireFormat) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, null, registrationOptions, wireFormat);
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, RegistrationOptions registrationOptions) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, null, registrationOptions, WireFormat.getDefaultWireFormat());
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, WireFormat wireFormat) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, null, new RegistrationOptions(), wireFormat);
    }

    public long registerPrefix(Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed) throws IOException, SecurityException {
        return this.registerPrefix(prefix, onInterest, onRegisterFailed, null, new RegistrationOptions(), WireFormat.getDefaultWireFormat());
    }

    public void removeRegisteredPrefix(long registeredPrefixId) {
        this.node_.removeRegisteredPrefix(registeredPrefixId);
    }

    public long setInterestFilter(InterestFilter filter, OnInterestCallback onInterest) {
        long interestFilterId = this.node_.getNextEntryId();
        this.node_.setInterestFilter(interestFilterId, filter, onInterest, this);
        return interestFilterId;
    }

    public long setInterestFilter(Name prefix, OnInterestCallback onInterest) {
        return this.setInterestFilter(new InterestFilter(prefix), onInterest);
    }

    public void unsetInterestFilter(long interestFilterId) {
        this.node_.unsetInterestFilter(interestFilterId);
    }

    public void putData(Data data, WireFormat wireFormat) throws IOException {
        this.node_.putData(data, wireFormat);
    }

    public void putData(Data data) throws IOException {
        this.putData(data, WireFormat.getDefaultWireFormat());
    }

    public void send(Blob encoding) throws IOException {
        this.send(encoding.buf());
    }

    public void send(ByteBuffer encoding) throws IOException {
        this.node_.send(encoding);
    }

    public final void putNack(Interest interest, NetworkNack networkNack) throws IOException {
        this.node_.putNack(interest, networkNack);
    }

    public void processEvents() throws IOException, EncodingException {
        this.node_.processEvents();
    }

    public boolean isLocal() throws IOException {
        return this.node_.isLocal();
    }

    public void shutdown() {
        this.node_.shutdown();
    }

    public static int getMaxNdnPacketSize() {
        return 8800;
    }

    public void callLater(double delayMilliseconds, Runnable callback) {
        this.node_.callLater(delayMilliseconds, callback);
    }

    protected static Interest getInterestCopy(Name name, Interest interestTemplate) {
        if (interestTemplate != null) {
            Interest interestCopy = new Interest(interestTemplate);
            interestCopy.setName(name);
            return interestCopy;
        }
        Interest interestCopy = new Interest(name);
        interestCopy.setInterestLifetimeMilliseconds(4000.0);
        return interestCopy;
    }
}

