/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.impl;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public class PendingInterestTable {
    private final ArrayList<Entry> table_ = new ArrayList();
    private final ArrayList<Long> removeRequests_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger(PendingInterestTable.class.getName());
    private static Common dummyCommon_ = new Common();

    public final synchronized Entry add(long pendingInterestId, Interest interestCopy, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack) {
        int removeRequestIndex = this.removeRequests_.indexOf(pendingInterestId);
        if (removeRequestIndex >= 0) {
            this.removeRequests_.remove(removeRequestIndex);
            return null;
        }
        Entry entry = new Entry(pendingInterestId, interestCopy, onData, onTimeout, onNetworkNack);
        this.table_.add(entry);
        return entry;
    }

    public final synchronized void extractEntriesForExpressedInterest(Data data, ArrayList<Entry> entries) {
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            Entry pendingInterest = this.table_.get(i);
            if (!pendingInterest.getInterest().matchesData(data)) continue;
            entries.add(this.table_.get(i));
            this.table_.remove(i);
            pendingInterest.setIsRemoved();
        }
    }

    public final synchronized void extractEntriesForNackInterest(Interest interest, ArrayList<Entry> entries) {
        SignedBlob encoding = interest.wireEncode();
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            Entry pendingInterest = this.table_.get(i);
            if (pendingInterest.getOnNetworkNack() == null || !pendingInterest.getInterest().wireEncode().equals(encoding)) continue;
            entries.add(this.table_.get(i));
            this.table_.remove(i);
            pendingInterest.setIsRemoved();
        }
    }

    public final synchronized void removePendingInterest(long pendingInterestId) {
        int count = 0;
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            if (this.table_.get(i).getPendingInterestId() != pendingInterestId) continue;
            ++count;
            this.table_.get(i).setIsRemoved();
            this.table_.remove(i);
        }
        if (count == 0) {
            logger_.log(Level.WARNING, "removePendingInterest: Didn't find pendingInterestId {0}", pendingInterestId);
        }
        if (count == 0 && this.removeRequests_.indexOf(pendingInterestId) < 0) {
            this.removeRequests_.add(pendingInterestId);
        }
    }

    public final synchronized boolean removeEntry(Entry pendingInterest) {
        if (pendingInterest.getIsRemoved()) {
            return false;
        }
        if (this.table_.remove(pendingInterest)) {
            pendingInterest.setIsRemoved();
            return true;
        }
        return false;
    }

    public static class Entry {
        private final Interest interest_;
        private final long pendingInterestId_;
        private final OnData onData_;
        private final OnTimeout onTimeout_;
        private final OnNetworkNack onNetworkNack_;
        private boolean isRemoved_ = false;

        public Entry(long pendingInterestId, Interest interest, OnData onData, OnTimeout onTimeout, OnNetworkNack onNetworkNack) {
            this.pendingInterestId_ = pendingInterestId;
            this.interest_ = interest;
            this.onData_ = onData;
            this.onTimeout_ = onTimeout;
            this.onNetworkNack_ = onNetworkNack;
        }

        public final long getPendingInterestId() {
            return this.pendingInterestId_;
        }

        public final Interest getInterest() {
            return this.interest_;
        }

        public final OnData getOnData() {
            return this.onData_;
        }

        public final OnNetworkNack getOnNetworkNack() {
            return this.onNetworkNack_;
        }

        public final void setIsRemoved() {
            this.isRemoved_ = true;
        }

        public final boolean getIsRemoved() {
            return this.isRemoved_;
        }

        public final void callTimeout() {
            if (this.onTimeout_ != null) {
                try {
                    this.onTimeout_.onTimeout(this.interest_);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                }
            }
        }
    }
}

